/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.util;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.map.ICubeBlock;
import com.collaxa.cube.engine.core.map.ICubeElement;
import com.collaxa.cube.engine.core.map.ICubeNode;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.map.builder.util.BPMNCubeMapExporter;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CatchAllErrorHandlingPolicy;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNBlock;
import oracle.bpm.bpmn.engine.model.blocks.TryBlock;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.common.FaultHandler;
import oracle.bpm.bpmn.engine.model.common.FaultHandlerImpl;
import oracle.bpm.bpmn.engine.model.common.FaultHandlers;
import oracle.bpm.bpmn.engine.model.nodes.BaseBPMNActivityNode;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.IMicroInstruction;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;

public class BPMNCubeMapPlainExporter
extends BPMNCubeMapExporter {
    private static final String CONNECTOR = " -> ";

    @Override
    protected void printBlock(PrintWriter writer, ICubeBlock block, int indent) throws CubeException {
        Object element = ((BPMNCubeElement)block).getFlowElement();
        String label = null;
        if (element != null) {
            label = element.getDefaultLabel();
        }
        if (label == null || label.isEmpty()) {
            label = block.getId();
        }
        this.printIndent(writer, indent);
        writer.println("block " + label + "(" + this.getBlockDescription(block) + ")");
        this.printMicroInstructions(writer, (ICubeElement)block, indent + 1);
        super.printBlock(writer, block, indent);
        this.printIndent(writer, indent);
        writer.println("end block");
    }

    @Override
    protected void printNodeDefinition(PrintWriter writer, ICubeNode node, int indent, FlowElement flowElement, String id) {
        this.printIndent(writer, indent);
        writer.println("Node " + id + this.getBpmnType(flowElement));
        this.printMicroInstructions(writer, (ICubeElement)node, indent + 1);
    }

    @Override
    protected void addConnector(String id, String targetNodeId, String targetActivityId, String connectorMetadata) {
        this.addConnector(id + CONNECTOR + targetNodeId + "[" + targetActivityId + "]" + connectorMetadata + ";");
    }

    protected String getBpmnType(FlowElement flowElement) {
        String result = flowElement instanceof FlowNode ? " (" + ((FlowNode)flowElement).getBpmnType().name().toLowerCase() + ")" : "";
        return result;
    }

    protected void printMicroInstructions(PrintWriter writer, ICubeElement element, int indent) {
        block4: {
            block3: {
                if (!(element instanceof BaseBPMNActivityNode)) break block3;
                BaseBPMNActivityNode bpmnNode = (BaseBPMNActivityNode)element;
                List<IMicroInstruction> instructions = bpmnNode.getMicroInstructions();
                if (instructions == null || instructions.isEmpty()) break block4;
                for (IMicroInstruction instruction : instructions) {
                    this.printIndent(writer, indent);
                    writer.println(instruction.getMicroInstructionId());
                }
                break block4;
            }
            if (element instanceof BPMNCubeElement) {
                BPMNCubeElement bpmnElement = (BPMNCubeElement)element;
                Map<String, oracle.bpm.bpmn.engine.microkernel.IMicroInstruction> map = bpmnElement.getMicroInstructionMap();
                for (Map.Entry<String, oracle.bpm.bpmn.engine.microkernel.IMicroInstruction> entry : map.entrySet()) {
                    this.printIndent(writer, indent);
                    writer.println(entry.getKey() + " " + entry.getValue().getMicroInstructionDescription());
                }
            }
        }
    }

    private String getBlockDescription(ICubeBlock block) {
        StringBuilder builder = new StringBuilder();
        if (block instanceof BaseBPMNBlock) {
            TryBlock tryBlock;
            FaultHandlers faultHandlers;
            BaseBPMNBlock bpmnBlock = (BaseBPMNBlock)block;
            List<BPMNCubeElement> entries = bpmnBlock.getSequenceFlowMetadata().getEntryElements();
            Collections.sort(entries, new Comparator<BPMNCubeElement>(){

                @Override
                public int compare(BPMNCubeElement o1, BPMNCubeElement o2) {
                    return o1.getId().compareTo(o2.getId());
                }
            });
            builder.append("EntryElements:");
            for (BPMNCubeElement element : entries) {
                builder.append(element.getId()).append(";");
            }
            if (block instanceof TryBlock && (faultHandlers = (tryBlock = (TryBlock)block).getFaultHandlers()) != null) {
                builder.append("FaultHandlers:");
                List<FaultHandler> faultHandlersList = faultHandlers.getFaultHandlers();
                for (FaultHandler fh : faultHandlersList) {
                    this.appendFaultHandlerDescription(builder, fh);
                }
                if (faultHandlers.getDefaultHandler() != null) {
                    this.appendFaultHandlerDescription(builder, faultHandlers.getDefaultHandler());
                }
            }
        }
        return builder.toString();
    }

    private void appendFaultHandlerDescription(StringBuilder builder, FaultHandler fh) {
        FaultHandlerImpl fhImpl = (FaultHandlerImpl)fh;
        CatchAllErrorHandlingPolicy errorHandlingPolicy = fhImpl.getErrorHandlingPolicy();
        Set<QName> nameSet = fhImpl.getFaultHandlerErrorCodes();
        builder.append(fhImpl.getId()).append("-CatchAll:").append(errorHandlingPolicy.isCatchAll()).append("-CatchAllBusiness:").append(errorHandlingPolicy.isCatchAllBusiness()).append("-CatchAllSystem:").append(errorHandlingPolicy.isCatchAllSystem());
        builder.append("-ErrorCodes:").append(nameSet).append(";");
    }
}

