/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.util;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.map.ICubeBlock;
import com.collaxa.cube.engine.core.map.ICubeElement;
import com.collaxa.cube.engine.core.map.ICubeMap;
import com.collaxa.cube.engine.core.map.ICubeNode;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.bpmn.engine.map.builder.util.BPMNCubeMapExporter;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNBlock;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.nodes.BaseBPMNActivityNode;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.IMicroInstruction;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.SequenceFlowInfo;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMRuntimeLogger;
import oracle.bpm.project.model.processes.BpmnSequenceFlowType;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;

public class BPMNCubeMapDotExporter
extends BPMNCubeMapExporter {
    private boolean addMicroInstructionsDetails;
    private Map<String, String> colorsByFlowElement = new HashMap<String, String>();
    private String[] excludedMicroInstructions;
    private boolean isDiffPath = false;
    private int nextCluster = 0;
    private int nextColor = 0;
    private static final String HIGHLIGHT_COLOR = "green";
    private static final String INACTIVE_COLOR = "gray";
    private static final int FONT_SIZE = 12;
    private static final String DIFF_COLOR = "red";
    private static final String CONDITIONAL_EDGE_COLOR = "red";
    private static final String BLOCK_NODE_SHAPE = "square";
    private static String[] allColors = new String[]{"blueviolet", "deeppink4", "brown", "darkorchid1", "darkslategray1", "azure3", "chocolate1", "cyan4", "cornsilk3", "darkorange2", "azure4", "brown1", "blanchedalmond", "antiquewhite", "firebrick", "darkslategray", "firebrick1", "chartreuse", "cornsilk4", "dimgray", "darkolivegreen", "darkorange4", "antiquewhite4", "cornsilk", "brown3", "darkorchid4", "aquamarine4", "firebrick3", "dimgrey", "darkorchid3", "goldenrod", "darkgoldenrod3", "darkturquoise", "cyan3", "darkviolet", "chartreuse4", "bisque4black", "blue", "bisque", "gold3", "goldenrod4", "azure", "darkseagreen1", "deeppink1", "chartreuse1", "forestgreen", "chartreuse3", "aliceblue", "cadetblue", "darkorange3", "dodgerblue", "chocolate", "dodgerblue3", "dodgerblue4", "darkolivegreen1", "chocolate3", "goldenrod1", "darkseagreen", "aquamarine", "deeppink3", "cyan", "gold", "aquamarine3", "goldenrod3", "burlywood1", "firebrick4", "darkslategrey", "blue4", "darkolivegreen4", "blue3", "chocolate4", "darkslategray4", "darksalmon", "crimson", "deepskyblue", "deepskyblue3", "bisque2", "darkslategray3", "cornflowerblue", "bisque3", "floralwhite", "brown4", "coral3", "beige", "darkgreen", "cadetblue4", "gainsboro", "darkkhaki", "darkolivegreen3", "darkgoldenrod", "burlywood", "coral4", "burlywood3", "darkgoldenrod1", "darkslateblue", "darkorange", "deepskyblue1", "darkseagreen3", "coral", "burlywood4", "darkorchid", "cadetblue3", "deepskyblue4", "gold4", "deeppink", "darkgoldenrod4", "cadetblue1", "darkseagreen4"};
    private static final String CONNECTOR = " -> ";
    private static final String NODE_COLOR = "darkolivegreen3";

    public BPMNCubeMapDotExporter(boolean addMicroInstructionsDetails) {
        this(addMicroInstructionsDetails, null);
    }

    public BPMNCubeMapDotExporter(boolean addMicroInstructionsDetails, String[] excludedMicroInstructions) {
        this.addMicroInstructionsDetails = addMicroInstructionsDetails;
        this.excludedMicroInstructions = excludedMicroInstructions == null ? new String[]{} : excludedMicroInstructions;
    }

    public void setDiffPath(boolean enabled) {
        this.isDiffPath = enabled;
    }

    public boolean isDiffPath() {
        return this.isDiffPath;
    }

    public boolean isExecutionDot() {
        return this.nodeLabelData != null;
    }

    public String getHighlightColor() {
        return this.isDiffPath() ? "red" : HIGHLIGHT_COLOR;
    }

    @Override
    protected void print(PrintWriter out, ICubeMap cubeMap) throws CubeException {
        out.println("digraph G {");
        super.print(out, cubeMap);
        out.println("}");
    }

    @Override
    protected void printBlock(PrintWriter writer, ICubeBlock block, int indent) throws CubeException {
        this.printIndent(writer, indent);
        writer.println("subgraph cluster" + this.getNextCluster() + " {");
        this.printIndent(writer, indent + 1);
        writer.println("node [style=filled,color=" + this.getDefaultNodeColor() + "];");
        this.printIndent(writer, indent + 1);
        String blockId = block.getId();
        writer.println("label=\"" + blockId + "\";");
        super.printBlock(writer, block, indent);
        if (block instanceof BaseBPMNBlock && this.addMicroInstructionsDetails) {
            BaseBPMNBlock bpmnBlock = (BaseBPMNBlock)block;
            String id = blockId;
            if (bpmnBlock.getFlowElement() != null) {
                id = id + "[" + bpmnBlock.getFlowElement().getDefaultLabel() + "]";
            }
            writer.println(this.escapeNodeId(blockId) + " [shape=" + BLOCK_NODE_SHAPE + ", color=" + this.getColor((FlowElement)bpmnBlock.getFlowElement(), id) + ",fontsize=" + 12 + ",label=\"" + blockId + this.getData(id, (ICubeElement)block) + "\"]");
        }
        this.printIndent(writer, indent);
        writer.println("}");
    }

    @Override
    protected void addConnector(String id, String targetNodeId, String targetActivityId, String connectorMetadata) {
        this.addConnector(this.escapeNodeId(id) + CONNECTOR + this.escapeNodeId(targetNodeId + "[" + targetActivityId + "]") + connectorMetadata + ";");
    }

    @Override
    protected void printNodeDefinition(PrintWriter writer, ICubeNode node, int indent, FlowElement flowElement, String id) {
        this.printIndent(writer, indent);
        String color = this.getColor(flowElement, id);
        writer.println(this.escapeNodeId(id) + " [color=" + color + ",fontsize=" + 12 + ",label=\"" + id + this.getBpmnType(flowElement) + this.getData(id, (ICubeElement)node) + "\"]");
    }

    protected String getBpmnType(FlowElement flowElement) {
        String result = flowElement instanceof FlowNode ? "\\n(" + ((FlowNode)flowElement).getBpmnType().name().toLowerCase() + ")" : "";
        return result;
    }

    protected String getMicroInstructions(ICubeElement element) {
        if (this.addMicroInstructionsDetails) {
            StringBuilder result = new StringBuilder();
            if (element instanceof BaseBPMNActivityNode) {
                BaseBPMNActivityNode bpmnNode = (BaseBPMNActivityNode)element;
                List<IMicroInstruction> instructions = bpmnNode.getMicroInstructions();
                if (instructions != null) {
                    for (IMicroInstruction instruction : instructions) {
                        result.append("\\n");
                        result.append(instruction.getMicroInstructionId());
                    }
                }
            } else if (element instanceof BPMNCubeElement) {
                BPMNCubeElement bpmnElement = (BPMNCubeElement)element;
                Map<String, oracle.bpm.bpmn.engine.microkernel.IMicroInstruction> map = bpmnElement.getMicroInstructionMap();
                for (Map.Entry<String, oracle.bpm.bpmn.engine.microkernel.IMicroInstruction> entry : map.entrySet()) {
                    result.append("\\n");
                    result.append(entry.getKey() + " " + entry.getValue().getMicroInstructionDescription());
                }
            }
            return result.toString();
        }
        return "";
    }

    @Override
    protected String getEdgeMetadata(SequenceFlowInfo outgoingSequenceFlow) {
        String result = "";
        if (outgoingSequenceFlow.getBpmnSequenceFlowType() == BpmnSequenceFlowType.CONDITIONAL) {
            result = "[color=red]";
        }
        return result;
    }

    protected String escapeNodeId(String id) {
        return this._escapeNodeId("\"" + id + "\"");
    }

    private boolean isNodeInPath(String id) {
        return this.nodeLabelData.get(id) != null && !((List)this.nodeLabelData.get(id)).isEmpty();
    }

    private String getDefaultNodeColor() {
        return NODE_COLOR;
    }

    private String getData(String id, ICubeElement element) {
        StringBuilder result = new StringBuilder();
        if (this.nodeLabelData != null) {
            List pathRecordList = (List)this.nodeLabelData.get(id);
            if (pathRecordList != null && !pathRecordList.isEmpty()) {
                NodeLabel label = new NodeLabel(id);
                for (BPMRuntimeLogger.Record record : pathRecordList) {
                    if (this.containsExcludedMicroInstructions(record)) continue;
                    label.addData(record.getNodeLabelData());
                }
                label.appendTo(result);
            }
        } else {
            result.append(this.getMicroInstructions(element));
        }
        return result.toString();
    }

    private boolean containsExcludedMicroInstructions(BPMRuntimeLogger.Record record) {
        if (record instanceof BPMRuntimeLogger.PathRecord) {
            for (String str : this.excludedMicroInstructions) {
                if (!((BPMRuntimeLogger.PathRecord)record).getMicroInstruction().contains(str)) continue;
                return true;
            }
        }
        return false;
    }

    private String getColor(FlowElement flowElement, String id) {
        String color = this.isExecutionDot() ? (this.isNodeInPath(id) ? this.getHighlightColor() : INACTIVE_COLOR) : this.doGetColor(flowElement);
        return color;
    }

    private String doGetColor(FlowElement element) {
        String id = element == null ? "" : element.getId();
        String color = this.colorsByFlowElement.get(id);
        if (color == null) {
            color = this.getUnassignedColor();
            this.colorsByFlowElement.put(id, color);
        }
        return color;
    }

    private int getNextCluster() {
        return this.nextCluster++;
    }

    private String getUnassignedColor() {
        if (this.nextColor >= allColors.length) {
            this.nextColor = 0;
        }
        return allColors[this.nextColor++];
    }

    private String _escapeNodeId(String id) {
        boolean isAlphaDig = id.matches("[a-zA-Z]+([\\w_]*)?");
        boolean isDoubleQuoted = id.matches("\".*\"");
        boolean isDotNumber = id.matches("[-]?([.][0-9]+|[0-9]+([.][0-9]*)?)");
        boolean isHTML = id.matches("<.*>");
        if (isAlphaDig || isDotNumber || isDoubleQuoted || isHTML) {
            return id;
        }
        throw new RuntimeException("Generated id '" + id + "'for vertex '" + id + "' is not valid with respect to the .dot language");
    }

    public static class NodeLabel {
        private List<NodeLabelData> data;
        private String id;

        public NodeLabel(String id) {
            this(id, new ArrayList<NodeLabelData>());
        }

        public NodeLabel(String id, List<NodeLabelData> data) {
            this.id = id.replace("\"", "");
            this.data = data;
        }

        public void addData(NodeLabelData data) {
            this.data.add(data);
        }

        public void addData(int thread, String miprocedure, String msg) {
            this.data.add(new NodeLabelData(thread, miprocedure, msg));
        }

        public String getId() {
            return this.id;
        }

        public List<NodeLabelData> getData() {
            return this.data;
        }

        public void appendTo(StringBuilder builder) {
            for (NodeLabelData data : this.getData()) {
                builder.append("\\n");
                data.appendTo(builder);
            }
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            this.appendTo(str);
            return str.toString();
        }

        public NodeLabel fromString(String str) {
            String[] parts = str.split("\\n");
            String id = parts[0];
            NodeLabel nodeLabel = new NodeLabel(id);
            for (int i = 1; i < parts.length; ++i) {
                NodeLabelData nodeLabelData = NodeLabelData.fromString(parts[i]);
                nodeLabel.addData(nodeLabelData);
            }
            return nodeLabel;
        }

        public static class NodeLabelData {
            private String msg;
            private String miprocedure;
            private int thread;

            public NodeLabelData(int thread, String miprocedure, String msg) {
                this.thread = thread;
                this.miprocedure = miprocedure;
                this.msg = msg;
            }

            public static NodeLabelData fromString(String str) {
                String[] parts = str.split(",");
                int thread = Integer.valueOf(parts[0].substring(1));
                String miprocedure = parts[2].substring(0, parts[2].length() - 1);
                String msg = parts[4];
                return new NodeLabelData(thread, miprocedure, msg);
            }

            public int getThread() {
                return this.thread;
            }

            public String getMiProcedure() {
                return this.miprocedure;
            }

            public String getMsg() {
                return this.msg;
            }

            public String toString() {
                StringBuilder str = new StringBuilder();
                this.appendTo(str);
                return str.toString();
            }

            protected void appendTo(StringBuilder builder) {
                builder.append("[");
                builder.append(this.getThread());
                builder.append(",");
                builder.append(this.getMiProcedure());
                builder.append("] ");
                builder.append(this.msg.replace(" ", "_"));
            }
        }
    }
}

