/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder;

import com.collaxa.cube.CubeException;
import oracle.bpm.bpmn.engine.map.builder.ModelCreatorFactory;
import oracle.bpm.bpmn.engine.map.builder.ModelCreatorFactoryInterface;

public class ModelCreatorFactoryHelper {
    private static volatile ModelCreatorFactoryInterface instance;
    private static final Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModelCreatorFactoryInterface getFactory() throws CubeException {
        Object object = lock;
        synchronized (object) {
            if (instance == null) {
                ModelCreatorFactoryHelper.init();
            }
        }
        return instance;
    }

    private static void init() {
        String factoryName = System.getProperty("bpmn.engine.map.builder.factory");
        if (factoryName == null) {
            instance = new ModelCreatorFactory();
        } else {
            try {
                Class<?> clazz = Class.forName(factoryName, true, Thread.currentThread().getContextClassLoader());
                instance = (ModelCreatorFactoryInterface)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static {
        lock = new Object();
    }
}

