/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.InitiationInfo;
import com.collaxa.cube.engine.core.map.ICubeBlock;
import com.collaxa.cube.engine.core.map.ICubeElement;
import com.collaxa.cube.engine.core.map.ICubeNode;
import com.collaxa.cube.engine.delivery.CorrelationSetDef;
import com.collaxa.cube.engine.deployment.DeploymentException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMap;
import oracle.bpm.bpmn.engine.map.builder.ServiceLink;
import oracle.bpm.bpmn.engine.map.builder.Tag;
import oracle.bpm.bpmn.engine.map.builder.TagInfo;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.IPostCompiler;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNActivityBlock;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.nodes.AbstractGatewayNode;
import oracle.bpm.bpmn.engine.model.nodes.ExclusiveGatewayNode;
import oracle.bpm.bpmn.engine.model.nodes.InclusiveGatewayNode;
import oracle.bpm.bpmn.engine.model.runtime.common.BPMNRuntimeConstants;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.ConditionalSequenceFlowInfo;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.SequenceFlowInfoFactory;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.UnconditionalSequenceFlowInfo;
import oracle.bpm.bpmn.engine.model.runtime.util.ConversationUtils;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.ConditionalFlow;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.services.common.exception.BPMException;
import oracle.fabric.common.wsdl.WSDLManager;
import oracle.fabric.composite.model.ComponentModel;
import org.jetbrains.annotations.NotNull;

public class BPMNCubeMapBuilderContext {
    private Boolean compilingInstantiateBlock;
    private ComponentModel componentModel;
    private boolean createInstanceEventPresent = false;
    private final BPMNCubeMap cubeMap;
    private BaseBPMNActivityBlock currentBlock;
    private Deque<Map<TagInfo, BPMNCubeElement>> elementsByTag = new ArrayDeque<Map<TagInfo, BPMNCubeElement>>();
    private Map<String, Map<TagInfo, BPMNCubeElement>> elementsByTagByProcessId = new HashMap<String, Map<TagInfo, BPMNCubeElement>>();
    private Set<ServiceLink> extraServiceLinks = new TreeSet<ServiceLink>();
    private Collection<IPostCompiler> postCompilers = new ArrayList<IPostCompiler>();
    private String prefixCache = "";
    private Deque<String> prefixes = new ArrayDeque<String>();

    public BPMNCubeMapBuilderContext(BPMNCubeMap cubeMap) {
        this.cubeMap = cubeMap;
        this.componentModel = cubeMap.getComponentModel();
        HashMap defaultElementMap = new HashMap();
        this.elementsByTag.add(defaultElementMap);
        this.elementsByTagByProcessId.put(cubeMap.getProcessModel().getId(), defaultElementMap);
    }

    public WSDLManager getWSDLManager() {
        if (this.getComponentModel() != null) {
            return this.getComponentModel().getComposite().getWSDLManager();
        }
        return null;
    }

    public BaseBPMNActivityBlock getCurrentBlock() {
        return this.currentBlock;
    }

    public void setCurrentBlock(BaseBPMNActivityBlock currentBlock) {
        this.currentBlock = currentBlock;
    }

    public void addElementToCurrentBlock(ICubeElement element) {
        this.addElementToBlock(element, (ICubeBlock)this.currentBlock);
    }

    public void addElementToBlock(ICubeElement element, ICubeBlock parent) {
        assert (element instanceof ICubeNode && !this.cubeMap.containsNode(element.getId()) || element instanceof ICubeBlock && !this.cubeMap.containsBlock(element.getId()));
        if (parent != null) {
            element.setParentBlock(parent);
            parent.addChildElement(element);
        }
        if (element instanceof ICubeNode) {
            this.cubeMap.addNode(element.getId(), (ICubeNode)element);
        } else if (element instanceof ICubeBlock) {
            this.cubeMap.addBlock(element.getId(), (ICubeBlock)element);
        }
    }

    public void tagElement(TagInfo tagInfo, BPMNCubeElement element) {
        Map<TagInfo, BPMNCubeElement> map = this.elementsByTag.getLast();
        assert (map != null);
        this.elementsByTag.getLast().put(tagInfo, element);
    }

    public BPMNCubeElement getElementByTag(TagInfo tagInfo) {
        assert (this.elementsByTag.getLast() != null);
        return this.elementsByTag.getLast().get(tagInfo);
    }

    public BPMNCubeElement getElementByTagOnTop(TagInfo tagInfo) {
        assert (this.elementsByTag.getFirst() != null);
        return this.elementsByTag.getFirst().get(tagInfo);
    }

    public void link(BPMNCubeElement source, BPMNCubeElement target) {
        this.link(null, source, target);
    }

    public void link(SequenceFlow sequenceFlow) {
        String sourceActivityId = sequenceFlow.getSource().getId();
        String targetActivityId = sequenceFlow.getTarget().getId();
        BPMNCubeElement entryPoint = this.getElementByTag(TagInfo.createTagInfo(targetActivityId, Tag.ENTRY_POINT));
        BPMNCubeElement exitPoint = this.getElementByTag(TagInfo.createTagInfo(sourceActivityId, Tag.EXIT_POINT));
        this.link(sequenceFlow, exitPoint, entryPoint);
    }

    public void linkConditional(SequenceFlow sequenceFlow) throws CubeException {
        if (sequenceFlow.getSource() == null || sequenceFlow.getTarget() == null) {
            throw new CubeException((Throwable)new BPMException(71500));
        }
        String sourceActivityId = sequenceFlow.getSource().getId();
        String targetActivityId = sequenceFlow.getTarget().getId();
        AbstractGatewayNode sourceNode = (AbstractGatewayNode)this.getElementByTag(TagInfo.createTagInfo(sourceActivityId, Tag.GATEWAY_NODE));
        AbstractGatewayNode targetNode = (AbstractGatewayNode)this.getElementByTag(TagInfo.createTagInfo(targetActivityId, Tag.GATEWAY_NODE));
        BPMNCubeElement targetEntryPoint = this.getElementByTag(TagInfo.createTagInfo(targetActivityId, Tag.ENTRY_POINT));
        ConditionalSequenceFlowInfo conditionalSequenceFlowInfo = SequenceFlowInfoFactory.createConditional((ConditionalFlow)sequenceFlow, targetEntryPoint.getId());
        assert (sourceNode != null) : "A conditional link must have a source node tagged as a gateway node, but is null";
        sourceNode.getGatewaySequenceFlowMetadata().addOutgoingSequenceFlow(conditionalSequenceFlowInfo);
        if (targetNode != null) {
            targetNode.getGatewaySequenceFlowMetadata().addIncomingSequenceFlow(conditionalSequenceFlowInfo);
        }
    }

    public void addInitiationInfo(InitiationInfo initiationInfo) {
        this.cubeMap.addInitiationInfo(initiationInfo);
    }

    public Collection<InitiationInfo> getInitiationInfo() {
        return this.cubeMap.getInitiationsInfo();
    }

    public void addInitiateInfo(CatchEvent event) {
        this.setCreateInstanceEventInitiationInfo();
        this.cubeMap.addTimerEvent(event);
    }

    public Collection<CatchEvent> getTimerEvents() {
        return this.cubeMap.getTimerEvents();
    }

    public void setCompilingInstantiateBlock(boolean instantiate) {
        this.compilingInstantiateBlock = instantiate;
    }

    public void unsetCompilingInstantiateBlock() {
        this.compilingInstantiateBlock = null;
    }

    public Boolean isCompilingInstantiateBlock() {
        return this.compilingInstantiateBlock;
    }

    public void setCreateInstanceEventInitiationInfo() {
        if (!this.createInstanceEventPresent) {
            InitiationInfo initiationInfo = new InitiationInfo(BPMNRuntimeConstants.CREATE_COMPONENT_INSTANCE_EVENT_QNAME);
            this.addInitiationInfo(initiationInfo);
            this.createInstanceEventPresent = true;
        }
    }

    public ComponentModel getComponentModel() {
        return this.componentModel;
    }

    public void registerPostCompiler(IPostCompiler compiler) {
        this.postCompilers.add(compiler);
    }

    public void executePostCompilers() {
        for (IPostCompiler compiler : this.postCompilers) {
            compiler.compile();
        }
    }

    public BPMNCubeMap getCubeMap() {
        return this.cubeMap;
    }

    public void pushContext(StackContext context) {
        this.addCubeElementPrefix(context.prefix);
        HashMap currentMapping = new HashMap();
        this.elementsByTag.addLast(currentMapping);
        this.elementsByTagByProcessId.put(context.process.getId(), currentMapping);
    }

    public void popContext() {
        this.removeLastCubeElementPrefix();
        this.elementsByTag.removeLast();
    }

    public String getCubeElementId(@NotNull ProjectObject element, String idSuffix) {
        return this.prefixCache + element.getId() + idSuffix;
    }

    public Set<ServiceLink> getExtraServiceLinks() {
        return this.extraServiceLinks;
    }

    public void addExtraServiceLinkDeclaration(@NotNull String serviceLinkName) throws DeploymentException {
        ServiceLink serviceLink = ConversationUtils.getServiceLinkDeclaration(this.getComponentModel(), serviceLinkName, false);
        if (serviceLink != null) {
            this.extraServiceLinks.add(serviceLink);
        }
    }

    public ICubeBlock getBlockForFlowElement(ICubeBlock parentBlock, FlowNode element) {
        if (ModelVisitorUtil.isTopLevelStart(element)) {
            BPMNCubeElement multiStartBlock = this.getElementByTag(TagInfo.createTagInfo(element.getParentObject().getId(), Tag.MULTISTART_BLOCK));
            if (multiStartBlock != null) {
                parentBlock = (ICubeBlock)multiStartBlock;
            } else {
                BPMNCubeElement tryProcessBlock = this.getElementByTag(TagInfo.createTagInfo(element.getParentObject().getId(), Tag.TRY_BLOCK));
                parentBlock = tryProcessBlock.getParentBlock();
            }
        }
        return parentBlock;
    }

    public Map<TagInfo, BPMNCubeElement> getElementsByTagByProcessId(String processId) {
        return Collections.unmodifiableMap(this.elementsByTagByProcessId.get(processId));
    }

    public void addCorrelationSubscription(String key, CorrelationSetDef correlationSetDef) {
        this.cubeMap.addCorrelationSubscription(key, correlationSetDef);
    }

    public CorrelationSetDef getCorrelationSetDef(String key) {
        return this.cubeMap.getCorrelationSetDef(key);
    }

    private void link(SequenceFlow sequenceFlow, BPMNCubeElement source, BPMNCubeElement target) {
        AbstractGatewayNode abstractGatewayNode;
        Object sourceFlowElement = source.getFlowElement();
        if (sourceFlowElement != null && source.getParentBlock() != target.getParentBlock() && ModelVisitorUtil.isTopLevelStart(sourceFlowElement, true)) {
            target = (BPMNCubeElement)target.getParentBlock();
        }
        UnconditionalSequenceFlowInfo sequenceFlowInfo = sequenceFlow != null ? SequenceFlowInfoFactory.createUnconditional(sequenceFlow, target.getId()) : SequenceFlowInfoFactory.createUnconditional(this.buildSequenceFlowId(source, target), sourceFlowElement == null ? source.getId() : sourceFlowElement.getId(), target.getFlowElement() == null ? target.getId() : target.getFlowElement().getId(), target.getId());
        if (source instanceof AbstractGatewayNode) {
            abstractGatewayNode = (AbstractGatewayNode)source;
            if (abstractGatewayNode instanceof ExclusiveGatewayNode || abstractGatewayNode instanceof InclusiveGatewayNode) {
                abstractGatewayNode.getGatewaySequenceFlowMetadata().setDefaultOutgoingSequenceFlow(sequenceFlowInfo);
            } else {
                abstractGatewayNode.getGatewaySequenceFlowMetadata().addOutgoingSequenceFlow(sequenceFlowInfo);
            }
        } else {
            source.getSequenceFlowMetadata().setOutgoingSequenceFlow(sequenceFlowInfo);
        }
        if (target instanceof AbstractGatewayNode) {
            abstractGatewayNode = (AbstractGatewayNode)target;
            abstractGatewayNode.getGatewaySequenceFlowMetadata().addIncomingSequenceFlow(sequenceFlowInfo);
        } else {
            target.getSequenceFlowMetadata().setIncomingSequenceFlow(sequenceFlowInfo);
        }
    }

    private String buildSequenceFlowId(BPMNCubeElement source, BPMNCubeElement target) {
        return source.getId() + "To" + target.getId();
    }

    private void addCubeElementPrefix(String prefix) {
        this.prefixes.addLast(prefix);
        this.createPrefixString();
    }

    private void removeLastCubeElementPrefix() {
        this.prefixes.removeLast();
        this.createPrefixString();
    }

    private void createPrefixString() {
        StringBuilder str = new StringBuilder();
        for (String p : this.prefixes) {
            str.append(p);
        }
        this.prefixCache = str.toString();
    }

    public static class StackContext {
        public String prefix;
        public Process process;

        public StackContext(Process process, String prefix) {
            this.process = process;
            this.prefix = prefix;
        }
    }
}

