/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.map.ICubeBlock;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMap;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.Tag;
import oracle.bpm.bpmn.engine.map.builder.TagInfo;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.map.builder.visitors.ProcessModelVisitor;
import oracle.bpm.bpmn.engine.model.blocks.BPMNProcessBlock;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNActivityBlock;
import oracle.bpm.bpmn.engine.model.blocks.BlockFactory;
import oracle.bpm.bpmn.engine.model.blocks.MultiStartBlock;
import oracle.bpm.bpmn.engine.model.blocks.ProcessTryBlock;
import oracle.bpm.bpmn.engine.model.blocks.TryBlock;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.collections.Predicate;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.fabric.composite.model.ComponentModel;
import org.jetbrains.annotations.Nullable;

public class BPMNCubeMapBuilder {
    private BPMNCubeMap cubeMap;
    private BPMNCubeMapBuilderContext cubeMapBuilderContext;
    private Process processModel;
    private ModelVisitor visitor = null;
    private static final String BACKWARD_COMPATIBLE_CALLABLE_COMPILER = "oracle.bpm.bpmn.use-backward-compatible-callable-compiler";

    public BPMNCubeMapBuilder(Process processModel, BPMNCubeMap cubeMap) {
        this.processModel = processModel;
        this.cubeMap = cubeMap;
        this.cubeMapBuilderContext = new BPMNCubeMapBuilderContext(cubeMap);
    }

    public BPMNCubeMapBuilder(Process processModel, BPMNCubeMapBuilderContext context) {
        this.processModel = processModel;
        this.cubeMapBuilderContext = context;
        this.cubeMap = this.cubeMapBuilderContext.getCubeMap();
    }

    public static BPMNCubeMapBuilderContext buildMaps(Process process, BPMNCubeMap cubeMap) throws CubeException {
        BPMNCubeMapBuilder builder = new BPMNCubeMapBuilder(process, cubeMap);
        builder.build(true, true);
        return builder.cubeMapBuilderContext;
    }

    public static void buildMaps(Process process, BPMNCubeMapBuilderContext context) throws CubeException {
        BPMNCubeMapBuilder builder = new BPMNCubeMapBuilder(process, context);
        builder.build(false, false);
    }

    private void build(boolean executePostCompilers, boolean addProcessBlock) throws CubeException {
        this.visitor = new ProcessModelVisitor(this.cubeMapBuilderContext, this.processModel);
        this.buildProcessBlock(addProcessBlock);
        if (executePostCompilers) {
            this.cubeMapBuilderContext.executePostCompilers();
        }
    }

    private void buildProcessBlock(boolean addProcessBlock) throws CubeException {
        String id = this.processModel.getId();
        String name = this.processModel.getName();
        int index = id.lastIndexOf("/");
        if (index >= 0) {
            id = id.substring(index + 1);
        }
        BaseBPMNActivityBlock newBlock = null;
        BPMNProcessBlock processBlock = null;
        TryBlock tryBlock = null;
        BaseBPMNActivityBlock oldCurrentBlock = this.cubeMapBuilderContext.getCurrentBlock();
        if (addProcessBlock) {
            processBlock = new BPMNProcessBlock(this.cubeMapBuilderContext, id, this.processModel, this.cubeMapBuilderContext.getExtraServiceLinks());
            this.cubeMapBuilderContext.addElementToBlock(processBlock, null);
            this.cubeMap.setMethodBlock((ICubeBlock)processBlock);
            tryBlock = BlockFactory.createProcessTryBlock(this.cubeMapBuilderContext, id, null);
            tryBlock.setFaultHandlers(null);
            this.cubeMapBuilderContext.addElementToBlock(tryBlock, (ICubeBlock)processBlock);
            this.cubeMapBuilderContext.tagElement(TagInfo.createTagInfo(id, Tag.TRY_BLOCK), tryBlock);
            if (this.hasMultipleStartPoints()) {
                MultiStartBlock multiStartBlock = BlockFactory.createMultiStartBlock(this.cubeMapBuilderContext, id, null);
                this.cubeMapBuilderContext.addElementToBlock(multiStartBlock, (ICubeBlock)processBlock);
                this.cubeMapBuilderContext.tagElement(TagInfo.createTagInfo(id, Tag.MULTISTART_BLOCK), multiStartBlock);
                processBlock.getSequenceFlowMetadata().addEntryElement(multiStartBlock);
                this.cubeMapBuilderContext.link(multiStartBlock, tryBlock);
            }
            newBlock = tryBlock;
        } else if (this.useBackwardCompatibleCallableCompiler()) {
            newBlock = oldCurrentBlock;
        } else {
            tryBlock = BlockFactory.createTryBlock(this.cubeMapBuilderContext, id, this.cubeMapBuilderContext.getCurrentBlock().getFlowElement());
            tryBlock.setFaultHandlers(null);
            this.cubeMapBuilderContext.addElementToBlock(tryBlock, (ICubeBlock)oldCurrentBlock);
            this.cubeMapBuilderContext.tagElement(TagInfo.createTagInfo(id, Tag.TRY_BLOCK), tryBlock);
            oldCurrentBlock.getSequenceFlowMetadata().addEntryElement(tryBlock);
            newBlock = tryBlock;
        }
        this.cubeMapBuilderContext.setCurrentBlock(newBlock);
        this.visitor.visit();
        if (tryBlock != null) {
            ModelVisitorUtil.processInlineCompilationResult(newBlock, tryBlock, this.visitor.getInlineErrorSubProcesses());
            if (addProcessBlock) {
                ((ProcessTryBlock)tryBlock).setConditionalInitiateElements(this.visitor.getConditionalInitiateElement());
            }
        }
        this.cubeMapBuilderContext.setCurrentBlock(oldCurrentBlock);
    }

    private boolean hasMultipleStartPoints() {
        int starts = 0;
        starts += this.processModel.getEvents(StartEvent.class).toArray().length;
        return (starts += this.processModel.getGateways(EventBasedGateway.class).select((Predicate)new Predicate<EventBasedGateway>(){

            public boolean check(@Nullable EventBasedGateway value) {
                return value != null && value.isInstantiate();
            }
        }).toArray().length) > 1;
    }

    private boolean useBackwardCompatibleCallableCompiler() {
        boolean result = false;
        ComponentModel componentModel = this.cubeMapBuilderContext.getComponentModel();
        if (componentModel != null) {
            result = BPMNServiceEngine.isPropertySet(componentModel, BACKWARD_COMPATIBLE_CALLABLE_COMPILER);
        }
        return result || Boolean.getBoolean(BACKWARD_COMPATIBLE_CALLABLE_COMPILER);
    }
}

