/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.InitiationInfo;
import com.collaxa.cube.engine.core.map.BlockNotFoundException;
import com.collaxa.cube.engine.core.map.ICubeBlock;
import com.collaxa.cube.engine.core.map.ICubeMap;
import com.collaxa.cube.engine.core.map.ICubeNode;
import com.collaxa.cube.engine.core.map.NodeNotFoundException;
import com.collaxa.cube.engine.delivery.CorrelationSetDef;
import com.collaxa.cube.engine.util.collections.CubeBlockHashMap;
import com.collaxa.cube.engine.util.collections.CubeNodeHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilder;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.Process;
import oracle.fabric.composite.model.ComponentModel;
import org.jetbrains.annotations.Nullable;

public final class BPMNCubeMap
implements ICubeMap {
    private ComponentModel componentModel;
    private Map<String, CorrelationSetDef> correlationSubscriptions;
    private BPMNCubeMapBuilderContext cubeMapBuilderContext;
    private Collection<InitiationInfo> initiationsInfo;
    private ICubeBlock[] mBlockList;
    private CubeBlockHashMap mBlocks = new CubeBlockHashMap();
    private ICubeBlock mMethodBlock;
    private ICubeNode[] mNodeList;
    private CubeNodeHashMap mNodes = new CubeNodeHashMap();
    private Process mProcessModel;
    private Collection<CatchEvent> timerEvents;
    private List<String> wsdlImportLocations;
    private List<String> xsdImportLocations;

    public BPMNCubeMap(Process process, @Nullable ComponentModel componentModel) {
        this.mProcessModel = process;
        this.componentModel = componentModel;
        this.initiationsInfo = new ArrayList<InitiationInfo>();
        this.timerEvents = new ArrayList<CatchEvent>();
        this.wsdlImportLocations = new ArrayList<String>();
        this.xsdImportLocations = new ArrayList<String>();
        this.correlationSubscriptions = new HashMap<String, CorrelationSetDef>();
    }

    public void addXsdImportLocation(String location) {
        this.xsdImportLocations.add(location);
    }

    public void addWsdlImportLocation(String location) {
        this.wsdlImportLocations.add(location);
    }

    public Sequence<String> getXsdImportLocations() {
        return CollectionUtils.asSequence(this.xsdImportLocations);
    }

    public Sequence<String> getWsdlImportLocations() {
        return CollectionUtils.asSequence(this.wsdlImportLocations);
    }

    public Process getProcessModel() {
        return this.mProcessModel;
    }

    @Nullable
    public ComponentModel getComponentModel() {
        return this.componentModel;
    }

    public void load(ICubeContext ctx) throws CubeException {
        this.cubeMapBuilderContext = BPMNCubeMapBuilder.buildMaps(this.mProcessModel, this);
    }

    public void setMethodBlock(ICubeBlock block) {
        this.mMethodBlock = block;
    }

    public void init(ICubeContext ctx) throws CubeException {
        ctx.addToEnvironment("__map-size", (Object)(this.mNodes.size() + this.mBlocks.size()));
        this.mMethodBlock.init(ctx);
        int i = 0;
        int size = this.mNodes.size();
        this.mNodeList = new ICubeNode[size];
        CubeNodeHashMap.Iterator ni = this.mNodes.iterator();
        while (ni.next()) {
            this.mNodeList[i++] = ni.value();
        }
        i = 0;
        size = this.mBlocks.size();
        this.mBlockList = new ICubeBlock[size];
        CubeBlockHashMap.Iterator bi = this.mBlocks.iterator();
        while (bi.next()) {
            this.mBlockList[i++] = bi.value();
        }
    }

    public void unload(ICubeContext ctx) throws CubeException {
    }

    public void addInitiationInfo(InitiationInfo initiationInfo) {
        this.initiationsInfo.add(initiationInfo);
    }

    public void addTimerEvent(CatchEvent event) {
        this.timerEvents.add(event);
    }

    public ICubeBlock getMethodBlock() {
        return this.mMethodBlock;
    }

    public Collection<InitiationInfo> getInitiationsInfo() {
        return Collections.unmodifiableCollection(this.initiationsInfo);
    }

    public Collection<CatchEvent> getTimerEvents() {
        return Collections.unmodifiableCollection(this.timerEvents);
    }

    public ICubeNode[] getAllNodes() {
        return this.mNodeList;
    }

    public ICubeBlock[] getAllBlocks() {
        return this.mBlockList;
    }

    public ICubeNode getNode(String id) throws CubeException {
        ICubeNode n = this.mNodes.get(id);
        if (n == null) {
            throw new NodeNotFoundException(id);
        }
        return n;
    }

    public boolean containsNode(String id) {
        return this.mNodes.containsKey(id);
    }

    public ICubeBlock getBlock(String id) throws CubeException {
        ICubeBlock b = this.mBlocks.get(id);
        if (b == null) {
            throw new BlockNotFoundException(id);
        }
        return b;
    }

    public boolean containsBlock(String id) {
        return this.mBlocks.containsKey(id);
    }

    public void uninit(ICubeContext ctx) throws CubeException {
    }

    public void addNode(String id, ICubeNode node) {
        this.mNodes.put(id, node);
    }

    public void addBlock(String id, ICubeBlock block) {
        this.mBlocks.put(id, block);
    }

    public BPMNCubeMapBuilderContext getCubeMapBuilderContext() {
        return this.cubeMapBuilderContext;
    }

    public void addCorrelationSubscription(String key, CorrelationSetDef correlationSetDef) {
        this.correlationSubscriptions.put(key, correlationSetDef);
    }

    public Map<String, CorrelationSetDef> getCorrelationSubscriptions() {
        return Collections.unmodifiableMap(this.correlationSubscriptions);
    }

    public CorrelationSetDef getCorrelationSetDef(String key) {
        return this.correlationSubscriptions.get(key);
    }
}

