/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.logging;

import com.collaxa.ServerLogger;
import com.collaxa.cube.CubeLogger;
import com.collaxa.cube.cluster.ClusterLogger;
import com.collaxa.cube.engine.CubeEngineLogger;
import com.collaxa.cube.engine.agents.AgentLogger;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.data.PersistenceLogger;
import com.collaxa.cube.engine.delivery.DeliveryLogger;
import com.collaxa.cube.engine.deployment.DeploymentLogger;
import com.collaxa.cube.engine.dispatch.DispatchLogger;
import com.collaxa.cube.engine.sensor.common.SensorLogger;
import com.collaxa.cube.lang.compiler.BPELCompilerLogger;
import com.collaxa.cube.persistence.dao.impl.jpa.BaseDao;
import com.collaxa.cube.util.logging.ICubeLoggerManager;
import com.collaxa.cube.ws.WSLogger;
import com.collaxa.cube.xml.CubeXMLLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class BPMNLoggerManager
implements ICubeLoggerManager {
    private static Map<String, String> gsLoggerNames = new HashMap<String, String>();
    private static Map<String, Logger> gsLoggers = new HashMap<String, Logger>();
    private static ICubeLoggerManager sLoggerManager = new BPMNLoggerManager();

    private BPMNLoggerManager() {
    }

    public static ICubeLoggerManager getInstance() {
        return sLoggerManager;
    }

    public Logger getLogger(String className) {
        Logger logger = gsLoggers.get(className);
        if (logger == null) {
            throw new RuntimeException("Cannot find logger for className: " + className);
        }
        return logger;
    }

    static {
        gsLoggerNames.put(CubeLogger.class.getName(), "oracle.soa.bpmn.system");
        gsLoggerNames.put(ServerLogger.class.getName(), "oracle.soa.bpmn.system");
        gsLoggerNames.put(CubeEngineLogger.class.getName(), "oracle.soa.bpmn.engine");
        gsLoggerNames.put(AgentLogger.class.getName(), "oracle.soa.bpmn.engine.agents");
        gsLoggerNames.put(BPELExecutionLogger.class.getName(), "oracle.soa.bpmn.engine.bpmn");
        gsLoggerNames.put(PersistenceLogger.class.getName(), "oracle.soa.bpmn.engine.data");
        gsLoggerNames.put(DeliveryLogger.class.getName(), "oracle.soa.bpmn.engine.delivery");
        gsLoggerNames.put(DeploymentLogger.class.getName(), "oracle.soa.bpmn.engine.deployment");
        gsLoggerNames.put(DispatchLogger.class.getName(), "oracle.soa.bpmn.engine.dispatch");
        gsLoggerNames.put(SensorLogger.class.getName(), "oracle.soa.bpmn.engine.sensor");
        gsLoggerNames.put(ClusterLogger.class.getName(), "oracle.soa.bpmn.engine.cluster");
        gsLoggerNames.put(BPELCompilerLogger.class.getName(), "oracle.soa.bpmn.engine.compiler");
        gsLoggerNames.put(BaseDao.class.getName(), "oracle.soa.bpmn.jpa");
        gsLoggerNames.put(WSLogger.class.getName(), "oracle.soa.bpmn.engine.ws");
        gsLoggerNames.put(CubeXMLLogger.class.getName(), "oracle.soa.bpmn.engine.xml");
        gsLoggerNames.put(Logger.class.getName(), "");
        gsLoggerNames.put(Logger.class.getName(), "");
        gsLoggerNames.put(Logger.class.getName(), "");
        gsLoggerNames.put(Logger.class.getName(), "");
        for (Map.Entry<String, String> entry : gsLoggerNames.entrySet()) {
            gsLoggers.put(entry.getKey(), Logger.getLogger(entry.getValue()));
        }
    }
}

