/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.instancemanagement.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.soa.management.config.bpmn.BPMNConfig;
import org.quartz.CronExpression;

public class UserInitiateProcessCleanupConfig
implements Serializable {
    private String action;
    private String cronExpression;
    private boolean enabled;
    private boolean onlyZombie;
    private double retentionDays;
    private List<String> taskStates;
    private static UserInitiateProcessCleanupConfig instance;
    private static final Object lockObj;
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserInitiateProcessCleanupConfig getInstance() {
        Object object = lockObj;
        synchronized (object) {
            if (instance == null) {
                BPMNConfig config = UserInitiateProcessCleanupConfig.getServiceEngine().getBPMNConfig();
                instance = new UserInitiateProcessCleanupConfig();
                instance.update(config);
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(BPMNConfig config) {
        Object object = lockObj;
        synchronized (object) {
            UserInitiateProcessCleanupConfig.instance.action = config.getUserInitiateProcessCleanupAction();
            UserInitiateProcessCleanupConfig.instance.onlyZombie = true;
            UserInitiateProcessCleanupConfig.instance.enabled = !"OFF".equals(UserInitiateProcessCleanupConfig.instance.action);
            UserInitiateProcessCleanupConfig.instance.retentionDays = config.getUserInitiateProcessCleanupRetentionDays();
            UserInitiateProcessCleanupConfig.instance.cronExpression = config.getUserInitiateProcessCleanupCronExpression();
            String stateStr = config.getUserInitiateProcessCleanupTaskStates();
            String[] states = stateStr.indexOf(",") >= 0 ? stateStr.split(",") : new String[]{stateStr};
            if (states.length > 0) {
                UserInitiateProcessCleanupConfig.instance.taskStates = Arrays.asList(states);
            }
        }
    }

    public void setOnlyZombie(boolean abortZombie) {
        this.onlyZombie = abortZombie;
    }

    public boolean isOnlyZombie() {
        return this.onlyZombie;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setRetentionDays(double retentionDays) {
        this.retentionDays = retentionDays;
    }

    public double getRetentionDays() {
        return this.retentionDays;
    }

    public void setCronExpression(String schedulingExpression) {
        this.cronExpression = schedulingExpression;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setTaskStates(List<String> taskStates) {
        this.taskStates = taskStates;
    }

    public List<String> getTaskStates() {
        return this.taskStates;
    }

    public Date nextSchedule() throws Exception {
        return this.nextSchedule(new Date(System.currentTimeMillis()));
    }

    public Date nextSchedule(Date now) throws Exception {
        CronExpression cron = new CronExpression(this.getCronExpression());
        return cron.getNextValidTimeAfter(now);
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("enabled=").append(this.enabled).append(", action=").append(this.action).append(", retentionDays=").append(this.retentionDays).append(", taskStates=").append(this.taskStates).append(", cronExpression=").append(this.cronExpression);
        return sb.toString();
    }

    private static BPMNServiceEngine getServiceEngine() {
        return BPMNServiceEngine.getInstance();
    }

    static {
        lockObj = new Object();
    }
}

