/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.instancemanagement.impl;

import com.collaxa.cube.engine.deployment.DeploymentLogger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import oracle.bpel.services.workflow.client.IWorkflowServiceClient;
import oracle.bpel.services.workflow.client.WorkflowServiceClientFactory;
import oracle.bpel.services.workflow.metadata.ITaskMetadataService;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TaskDefinition;
import oracle.bpel.services.workflow.query.ITaskQueryService;
import oracle.bpel.services.workflow.repos.Ordering;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.repos.TableConstants;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.bpmn.engine.instancemanagement.IUserInitiateProcessCleanup;
import oracle.bpm.bpmn.engine.instancemanagement.impl.UserInitiateProcessCleanupConfig;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.bpmn.engine.service.Util;
import oracle.soa.management.facade.CompositeInstance;
import oracle.soa.management.facade.Locator;
import oracle.soa.management.facade.LocatorFactory;
import oracle.soa.management.util.CompositeInstanceFilter;

public class UserInitiateProcessCleanup
implements IUserInitiateProcessCleanup {
    private boolean abortOnlyZombie = true;
    private String action;
    private boolean justVerify = false;
    private Locator locator;
    private double retentionDays;
    private List<String> taskStates;
    private IWorkflowServiceClient wfClient;
    private IWorkflowContext wfContext;
    private static final Class logClassName = UserInitiateProcessCleanup.class;

    public UserInitiateProcessCleanup() {
    }

    public UserInitiateProcessCleanup(IWorkflowContext wfContext, IWorkflowServiceClient wfClient, Locator locator) {
        this.wfClient = wfClient;
        this.wfContext = wfContext;
        this.locator = locator;
    }

    public void initialize(UserInitiateProcessCleanupConfig config) {
        this.retentionDays = config.getRetentionDays();
        this.taskStates = config.getTaskStates();
        this.abortOnlyZombie = config.isOnlyZombie();
        this.action = config.getAction();
    }

    @Override
    public void doRemoveInstances(UserInitiateProcessCleanupConfig config) throws Exception {
        this.initialize(config);
        this.startAbortingInstances();
    }

    private Locator getLocator() throws Exception {
        return this.locator == null ? LocatorFactory.createLocator() : this.locator;
    }

    private IWorkflowContext getWorkflowContext() throws Exception {
        return this.wfContext == null ? Util.getInternalWorkflowContext() : this.wfContext;
    }

    private IWorkflowServiceClient getWorkflowClient() throws Exception {
        IWorkflowServiceClient client = this.wfClient == null ? WorkflowServiceClientFactory.getWorkflowServiceClient((String)"LOCAL") : this.wfClient;
        return client;
    }

    private ITaskQueryService getTaskQueryService() throws Exception {
        return this.getWorkflowClient().getTaskQueryService();
    }

    private boolean checkTaskForInitiatorPattern(IWorkflowContext context, String taskDefinitionId) throws Exception {
        String logMethodName = "checkTaskForInitiatorPattern";
        DeploymentLogger.LOG.debug(logClassName, "checkTaskForInitiatorPattern", new Object[]{"BEGIN ", " taskDefinitionId {" + taskDefinitionId + "}"});
        IWorkflowServiceClient client = this.getWorkflowClient();
        ITaskMetadataService metadataService = client.getTaskMetadataService();
        TaskDefinition id = null;
        try {
            id = metadataService.getTaskDefinitionById(context, taskDefinitionId);
        }
        catch (Exception e) {
            DeploymentLogger.LOG.debug(logClassName, "checkTaskForInitiatorPattern", new Object[]{"Unable to find the task definition ID"});
            return false;
        }
        DeploymentLogger.LOG.debug(logClassName, "checkTaskForInitiatorPattern", new Object[]{"_TASK DEFINITION ID {" + taskDefinitionId + "}", " ID {" + (id != null ? id.getId() + "globalCreationTask(" + id.getWorkflowConfiguration().isGlobalCreationTask() + ")" : "NULL") + "}"});
        if (id != null && id.getWorkflowConfiguration().isGlobalCreationTask()) {
            DeploymentLogger.LOG.debug(logClassName, "checkTaskForInitiatorPattern", new Object[]{"END: TRUE "});
            return true;
        }
        DeploymentLogger.LOG.debug(logClassName, "checkTaskForInitiatorPattern", new Object[]{"END: FALSE "});
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void startAbortingInstances() throws Exception {
        logMethodName = "startAbortingInstances";
        DeploymentLogger.LOG.info(UserInitiateProcessCleanup.logClassName, "startAbortingInstances", new Object[]{"START OF " + this.action + " instances"});
        context = null;
        queryService = null;
        try {
            displayColumns = new ArrayList<String>();
            displayColumns.add(TableConstants.WFTASK_COMPOSITEINSTANCEID_COLUMN.getName());
            order = new Ordering(TableConstants.WFTASK_CREATEDDATE_COLUMN, false, false);
            queryPredicate = this.getMainPredicateBasedOnDate();
            this.addStatePredicate(queryPredicate);
            DeploymentLogger.LOG.debug(UserInitiateProcessCleanup.logClassName, "startAbortingInstances", new Object[]{"Using query predicate ** " + queryPredicate + " **  for aborting instances "});
            queryService = this.getTaskQueryService();
            context = this.getWorkflowContext();
            tasks = queryService.queryTasks(context, displayColumns, new ArrayList<E>(), ITaskQueryService.AssignmentFilter.ALL, "", queryPredicate, order, 0, 0);
            compositeInstanceIds = new HashSet<String>();
            for (Task task : tasks) {
                if (!this.checkTaskForInitiatorPattern(context, task.getTaskDefinitionId())) continue;
                DeploymentLogger.LOG.debug(UserInitiateProcessCleanup.logClassName, "startAbortingInstances", new Object[]{"Attaching { " + task.getSca().getCompositeInstanceId() + "} to the list of tasks to process"});
                compositeInstanceIds.add(task.getSca().getCompositeInstanceId());
            }
            if (!compositeInstanceIds.isEmpty()) {
                iter = compositeInstanceIds.iterator();
                svc = BPMNServiceEngine.getInstance();
                while (iter.hasNext()) {
                    instanceId = (String)iter.next();
                    instance = this.getCompositeInstance(instanceId);
                    cal = Calendar.getInstance();
                    cal.setTime(instance.getCreationDate());
                    DeploymentLogger.LOG.debug(UserInitiateProcessCleanup.logClassName, "startAbortingInstances", new Object[]{"Creation date of instance is " + this.getDateFormat(cal)});
                    if (this.justVerify) continue;
                    if (this.action.equals("ABORT")) {
                        this.abortCompositeInstance(instance);
                        continue;
                    }
                    if (!this.action.equals("DELETE")) continue;
                    this.deleteCompositeInstance(instance);
                }
            } else {
                DeploymentLogger.LOG.debug(UserInitiateProcessCleanup.logClassName, "startAbortingInstances", new Object[]{"NOT able to find any instances to " + this.action.toLowerCase()});
            }
            ** if (context == null || queryService == null) goto lbl-1000
        }
        catch (Throwable var14_14) {
            if (context != null && queryService != null) {
                queryService.destroyWorkflowContext(context);
            }
            throw var14_14;
        }
lbl-1000:
        // 1 sources

        {
            queryService.destroyWorkflowContext(context);
        }
lbl-1000:
        // 2 sources

        {
        }
        DeploymentLogger.LOG.info(UserInitiateProcessCleanup.logClassName, "startAbortingInstances", new Object[]{"END OF " + this.action + " instances"});
    }

    private CompositeInstance getCompositeInstance(String instanceId) throws Exception {
        String logMethodName = "getCompositeInstance";
        DeploymentLogger.LOG.debug(logClassName, "getCompositeInstance", new Object[]{"Start of getting compositeinstance id " + instanceId});
        CompositeInstanceFilter filter = new CompositeInstanceFilter();
        filter.setId(instanceId);
        List compositeInstance = this.getLocator().getCompositeInstances(filter);
        if (compositeInstance.size() > 0) {
            DeploymentLogger.LOG.debug(logClassName, "getCompositeInstance", new Object[]{"End of getting compositeinstance id " + instanceId});
            return (CompositeInstance)compositeInstance.get(0);
        }
        throw new Exception("Not able to find composite instance for " + instanceId);
    }

    private void abortCompositeInstance(CompositeInstance instance) throws Exception {
        String logMethodName = "abortCompositeInstance";
        DeploymentLogger.LOG.info(logClassName, "abortCompositeInstance", new Object[]{"Aborting composite instance " + instance.getId()});
        instance.abort();
    }

    private void deleteCompositeInstance(CompositeInstance instance) throws Exception {
        String logMethodName = "deleteCompositeInstance";
        DeploymentLogger.LOG.info(logClassName, "deleteCompositeInstance", new Object[]{"Deleting composite instance " + instance.getId()});
        CompositeInstanceFilter filter = new CompositeInstanceFilter();
        filter.setId(String.valueOf(instance.getId()));
        this.getLocator().purgeInstance(filter);
    }

    private void addStatePredicate(Predicate pred) throws Exception {
        if (this.taskStates != null && !((Object)this.taskStates).equals("")) {
            if (this.taskStates.indexOf("COMPLETED") >= 0) {
                throw new Exception("Not allowed to abort/delete instances for completed state");
            }
            if (this.taskStates != null && !this.taskStates.isEmpty()) {
                pred.addClause(7, TableConstants.WFTASK_STATE_COLUMN, 9, this.taskStates);
            }
            pred.addClause(7, TableConstants.WFTASK_COMPONENTTYPE_COLUMN, 0, (Object)"Workflow");
            return;
        }
        throw new Exception("Initiate task states are not specified correctly");
    }

    private String getDateFormat(Calendar cal) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyy.MMMMM.dd GGG hh:mm aaa");
        return dateFormat.format(cal.getTime());
    }

    private Predicate getMainPredicateBasedOnDate() throws Exception {
        String logMethodName = "getMainPredicateBasedOnDate";
        Calendar currentTime = Calendar.getInstance();
        int days = (int)this.retentionDays;
        int seconds = (int)((this.retentionDays - (double)days) * 86400.0);
        if (days > 0) {
            currentTime.add(5, -days);
        }
        if (seconds > 0) {
            currentTime.add(13, -seconds);
        }
        DeploymentLogger.LOG.debug(logClassName, "getMainPredicateBasedOnDate", new Object[]{"Deleting no of days old instances " + this.retentionDays, "(" + days + " days, " + seconds + " seconds)"});
        DeploymentLogger.LOG.debug(logClassName, "getMainPredicateBasedOnDate", new Object[]{"Deleting or aborting instances before creation date " + this.getDateFormat(currentTime)});
        Predicate createDateRange = new Predicate(TableConstants.WFTASK_CREATEDDATE_COLUMN, 5, (Object)currentTime);
        if (this.abortOnlyZombie) {
            createDateRange.addClause(7, TableConstants.WFTASK_CREATEDDATE_COLUMN, 0, TableConstants.WFTASK_UPDATEDDATE_COLUMN);
        }
        return createDateRange;
    }
}

