/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.instancemanagement.impl;

import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.audit.IAuditEvent;
import com.collaxa.cube.engine.audit.IAuditTrail;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.client.IWorkflowServiceClient;
import oracle.bpel.services.workflow.client.IWorkflowServiceClientConstants;
import oracle.bpel.services.workflow.client.WorkflowServiceClientFactory;
import oracle.bpel.services.workflow.query.ITaskQueryService;
import oracle.bpel.services.workflow.repos.IPersistencyService;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.repos.TableConstants;
import oracle.bpel.services.workflow.repos.Transaction;
import oracle.bpel.services.workflow.task.ITaskService;
import oracle.bpel.services.workflow.task.impl.TaskAssignee;
import oracle.bpel.services.workflow.task.impl.WorkflowUtil;
import oracle.bpel.services.workflow.task.model.SystemAttributesType;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.bpmn.engine.instancemanagement.IInternalInstanceManagementService;
import oracle.bpm.bpmn.engine.instancemanagement.IUserInitiateProcessCleanup;
import oracle.bpm.bpmn.engine.instancemanagement.impl.UserInitiateProcessCleanup;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ProcessInstance;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNPayloadMappingCache;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;
import oracle.bpm.bpmn.engine.service.BPMNAuditEvent;
import oracle.bpm.bpmn.engine.service.BPMNAuditTrail;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.bpmn.engine.service.Util;
import oracle.bpm.bpmn.engine.service.audit.AuditServiceFactory;
import oracle.bpm.bpmn.engine.service.audit.AuditUtil;
import oracle.bpm.bpmn.engine.service.audit.IAuditService;
import oracle.bpm.bpmn.engine.service.audit.persistence.AuditPersistenceException;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQuery;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryVariableRange;
import oracle.bpm.services.common.AbstractBPMService;
import oracle.bpm.services.common.BPMServiceLocator;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancemanagement.model.IIdentityType;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;
import oracle.bpm.services.instancemanagement.model.IProcessSystemAttributes;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.instancequery.IAuditVariableMetadata;
import oracle.bpm.services.instancequery.IColumnConstants;
import oracle.bpm.services.instancequery.IInstanceQueryInput;
import oracle.bpm.services.instancequery.IInstanceQueryService;
import oracle.bpm.services.instancequery.impl.AuditInstance;
import oracle.bpm.services.instancequery.impl.InstanceQueryInput;
import oracle.soa.management.ComponentDN;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InternalInstanceManagementService
extends AbstractBPMService
implements IInternalInstanceManagementService {
    private static final String CUBE_INSTANCE_ID_BPMN_PREFIX = "bpmn:";

    public static ProcessInstance adaptInstance(IProcessInstance processInstance) {
        long cubeInstanceId = InternalInstanceManagementService.getCubeInstanceId(processInstance);
        int thread = processInstance.getSystemAttributes().getThread();
        String workItemKeyURI = processInstance.getSystemAttributes().getWorkItemKey();
        String absoluteScopeId = processInstance.getSystemAttributes().getTokenKey();
        ProcessInstance result = ProcessInstance.createWithWorkItemKeyURI(cubeInstanceId, thread, workItemKeyURI, processInstance.getSystemAttributes().getActivityId());
        result.setAbsoluteScopeId(BPMNUtility.getAbsoluteScopeIdFromTokenKey(absoluteScopeId));
        result.setMapElementId(BPMNUtility.getCubeElementIdFromTokenKey(absoluteScopeId));
        result.setState(processInstance.getSystemAttributes().getState());
        return result;
    }

    public static long getCubeInstanceId(IProcessInstance processInstance) {
        String cubeInstanceIdStr = processInstance.getCubeInstanceId();
        long cubeInstanceId = !cubeInstanceIdStr.startsWith(CUBE_INSTANCE_ID_BPMN_PREFIX) ? Long.parseLong(cubeInstanceIdStr) : Long.parseLong(cubeInstanceIdStr.substring(CUBE_INSTANCE_ID_BPMN_PREFIX.length()));
        return cubeInstanceId;
    }

    @Override
    public IProcessInstance insertUpdateInstance(IBPMContext context, IProcessInstance instance) throws BPMException {
        this.logDebug("insertUpdateInstance()", "Start of inserting process instance");
        boolean inTransaction = false;
        String taskId = null;
        try {
            inTransaction = Transaction.inTransaction();
            if (!inTransaction) {
                Transaction.start();
            }
            IPersistencyService service = Transaction.getPersistencyService();
            Task taskObject = ((oracle.bpm.services.instancemanagement.model.impl.ProcessInstance)instance).getTask();
            SystemAttributesType attributes = taskObject.getSystemAttributes();
            if (context != null) {
                String userName = context.getUser();
                attributes.getUpdatedBy().setId(userName);
            }
            Calendar updatedDate = Calendar.getInstance();
            updatedDate.setTimeInMillis(System.currentTimeMillis());
            attributes.setUpdatedDate(updatedDate);
            taskId = taskObject.getSystemAttributes().getTaskId();
            List removeAssignees = instance.getRemoveAssignees();
            if (removeAssignees != null) {
                IProcessSystemAttributes sysAttribute = instance.getSystemAttributes();
                ArrayList currentAssignees = new ArrayList(sysAttribute.getAssignees());
                sysAttribute.clearAssignees();
                for (IIdentityType type : removeAssignees) {
                    sysAttribute.addAssignee(type);
                }
                service.removeAssigneeFromProcessInstance((IWorkflowContext)context, taskObject);
                sysAttribute.clearAssignees();
                for (IIdentityType type : currentAssignees) {
                    sysAttribute.addAssignee(type);
                }
            }
            taskObject = service.insertUpdateProcessInstance((IWorkflowContext)context, taskObject);
            ((oracle.bpm.services.instancemanagement.model.impl.ProcessInstance)instance).setTask(taskObject);
        }
        catch (Exception exc) {
            Object[] obj = new String[]{taskId};
            throw new BPMException(70202, obj, (Throwable)exc);
        }
        finally {
            if (!inTransaction) {
                try {
                    Transaction.close();
                }
                catch (Exception exc) {}
            }
        }
        this.logDebug("insertUpdateInstance()", "End of inserting process instance");
        return instance;
    }

    @Override
    public List<IAuditEvent> persistAuditData(IAuditTrail auditTrail) throws BPMException {
        List<Object> persisted = null;
        if (auditTrail instanceof BPMNAuditTrail && ((BPMNAuditTrail)auditTrail).getEventCount() > 0) {
            try {
                IAuditService audit = AuditServiceFactory.getInstance().getAuditService();
                persisted = audit.persistAuditData(auditTrail);
            }
            catch (AuditPersistenceException ape) {
                Object[] objs = new String[]{auditTrail + " "};
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AUDIT_CORE, (Severity)Severity.ERRORS, (String)ape.getMessage());
                throw new BPMException(71300, objs, (Throwable)ape);
            }
            catch (Exception e) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AUDIT_CORE, (Severity)Severity.ERRORS, (Throwable)e);
                Object[] objs = new String[]{auditTrail + " "};
                throw new BPMException(71300, objs, (Throwable)e);
            }
        }
        if (persisted == null) {
            persisted = new ArrayList();
        }
        return persisted;
    }

    @Override
    public void publishToMeasurement(IAuditTrail auditTrail) throws BPMException {
        if (auditTrail instanceof BPMNAuditTrail && ((BPMNAuditTrail)auditTrail).getEventCount() > 0) {
            try {
                IAuditService audit = AuditServiceFactory.getInstance().getAuditService();
                audit.publishToMeasurement(auditTrail);
            }
            catch (Exception e) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AUDIT_CORE, (Severity)Severity.ERRORS, (Throwable)e);
                Object[] objs = new String[]{auditTrail + " "};
                throw new BPMException(71300, objs, (Throwable)e);
            }
        }
    }

    @Override
    public void insertAuditVariableMetadata(IAuditVariableMetadata metadata, List<AuditQueryVariableRange> ranges) throws BPMException {
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            service.persistAuditMetadata(metadata, ranges);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AUDIT_CORE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] objs = new String[]{metadata + " "};
            throw new BPMException(71300, objs, (Throwable)e);
        }
    }

    @Override
    public IAuditVariableMetadata getPreviousDeployment(String compositeDn) throws BPMException {
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            return service.getPreviousDeployment(compositeDn);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AUDIT_CORE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] objs = new String[]{compositeDn + " "};
            throw new BPMException(71300, objs, (Throwable)e);
        }
    }

    @Override
    public void markInstanceAsStaleAndRemoveFlexFieldMapping(String processDN) throws BPMException {
        boolean inTransaction = false;
        this.logDebug("markInstanceAsStale()", "Start of marking instance as stale for process DN " + processDN);
        try {
            inTransaction = Transaction.inTransaction();
            if (!inTransaction) {
                Transaction.start((boolean)false);
            }
            this.markInstanceAsStale(processDN);
            IPersistencyService service = Transaction.getPersistencyService();
            service.deleteAttributeLabelUsageByTaskMetadataId(processDN);
            BPMNPayloadMappingCache.clearEntry(processDN);
        }
        catch (Exception exc) {
            Object[] obj = new String[]{processDN};
            throw new BPMException(70202, obj, (Throwable)exc);
        }
        finally {
            if (!inTransaction) {
                try {
                    Transaction.close();
                }
                catch (Exception exc) {}
            }
        }
        this.logDebug("markInstanceAsStale()", "End of marking instance as stale");
    }

    @Override
    public void markInstanceAsStale(String processDN) throws BPMException {
        boolean inTransaction = false;
        this.logDebug("markInstanceAsStale()", "Start of marking instance as stale for process DN " + processDN);
        try {
            inTransaction = Transaction.inTransaction();
            if (!inTransaction) {
                Transaction.start((boolean)false);
            }
            IPersistencyService service = Transaction.getPersistencyService();
            ArrayList<String> states = new ArrayList<String>();
            Set<String> runningStates = BPMNServiceEngine.getProcessStatesForComponentState(0);
            states.addAll(runningStates);
            service.markProcessInstancesStale(processDN, states);
        }
        catch (Exception exc) {
            Object[] obj = new String[]{processDN};
            throw new BPMException(70202, obj, (Throwable)exc);
        }
        finally {
            if (!inTransaction) {
                try {
                    Transaction.close();
                }
                catch (Exception exc) {}
            }
        }
        this.logDebug("markInstanceAsStale()", "End of marking instance as stale");
    }

    @Override
    public int abortInstancesByCompositeInstanceId(IBPMContext context, long compositeInstanceId) throws Exception {
        this.logDebug("abortInstancesByCompositeInstanceId()", "Start of aborting instances based on composite instance id " + compositeInstanceId);
        Predicate pred = new Predicate(IColumnConstants.PROCESS_COMPOSITEINSTANCEID_COLUMN, 0, (Object)String.valueOf(compositeInstanceId));
        InstanceQueryInput input = new InstanceQueryInput();
        input.addState("OPEN");
        input.setAssignmentFilter(IInstanceQueryInput.AssignmentFilter.ALL);
        IInstanceQueryService service = BPMServiceLocator.getInstanceQueryService();
        ArrayList displayColumns = new ArrayList();
        List instances = service.queryInstances(context, displayColumns, pred, null, (IInstanceQueryInput)input);
        for (IProcessInstance instance : instances) {
            instance.getSystemAttributes().setState("ABORTED");
            this.insertUpdateInstance(context, instance);
        }
        this.logDebug("abortInstancesByCompositeInstanceId()", "End of aborting instances based on composite instance id " + compositeInstanceId + compositeInstanceId);
        return instances.size();
    }

    @Override
    public List<AuditQuery> queryLastEventforCompositeDN(String compositeDN, int firstResult, int maxResult) throws BPMException {
        List<AuditQuery> events = null;
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            events = service.queryLastEventforCompositeDN(compositeDN, firstResult, maxResult);
        }
        catch (Exception e) {
            throw new BPMException(e);
        }
        return events;
    }

    @Override
    @Deprecated
    public void markAuditAsStale(List<AuditQuery> events) throws BPMException {
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            service.markAuditAsStale(events);
        }
        catch (Exception e) {
            throw new BPMException(e);
        }
    }

    @Override
    public long markAuditAsStale(String compositeDN, long batchSize) throws BPMException {
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            return service.markAuditAsStale(compositeDN, batchSize);
        }
        catch (Exception e) {
            throw new BPMException(e);
        }
    }

    @Override
    public void markAuditAsAborted(IBPMContext context, String compositeInstanceId) throws BPMException {
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            service.markAuditAsAborted(compositeInstanceId);
        }
        catch (Exception e) {
            throw new BPMException(e);
        }
    }

    @Override
    public void markAuditCancelled(IBPMContext context, String instanceId) throws BPMException {
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            service.markAuditCancelled(String.valueOf(instanceId));
        }
        catch (Exception e) {
            throw new BPMException(e);
        }
    }

    @Override
    public void markInstanceCancelled(IBPMContext context, String instanceId) throws BPMException {
        this.logDebug("markInstanceCancelled()", "Start of marking instance as cancelled. Id: " + instanceId);
        try {
            IInstanceQueryService service = BPMServiceLocator.getInstanceQueryService();
            Predicate pred = new Predicate(IColumnConstants.PROCESS_ID_COLUMN, 0, (Object)String.valueOf(instanceId));
            InstanceQueryInput input = new InstanceQueryInput();
            ArrayList displayColumns = new ArrayList();
            input.setAssignmentFilter(IInstanceQueryInput.AssignmentFilter.ALL);
            List instances = service.queryInstances(context, displayColumns, pred, null, (IInstanceQueryInput)input);
            for (IProcessInstance instance : instances) {
                this.logDebug("markInstanceCancelled()", "Marking instance '" + instance.getSystemAttributes().getProcessInstanceId() + "' corresponding to cube instance '" + instanceId + "' as cancelled.");
                instance.getSystemAttributes().setState("CANCELED");
                this.insertUpdateInstance(context, instance);
            }
        }
        catch (WorkflowException e) {
            Object[] obj = new String[]{instanceId};
            throw new BPMException(70202, obj, (Throwable)e);
        }
        this.logDebug("markInstanceCancelled()", "End of marking instance as cancelled. Id: " + instanceId);
    }

    @Override
    public void withdrawWorkflowTasks(@NotNull List<String> taskIds) throws BPMException {
        this.withdrawWorkflowTasks(taskIds, false);
    }

    @Override
    public void withdrawWorkflowTasks(@NotNull List<String> taskIds, Boolean useTaskServiceParticipate) throws BPMException {
        IBPMContext context = null;
        try {
            context = Util.getInternalWorkflowContext();
        }
        catch (Exception e) {
            throw new BPMException(70208, null, (Throwable)e);
        }
        this.withdrawWorkflowTasks(context, taskIds, useTaskServiceParticipate);
    }

    @Override
    public void withdrawWorkflowTasks(IBPMContext context, @NotNull List<String> taskIds) throws BPMException {
        this.withdrawWorkflowTasks(context, taskIds, false);
    }

    @Override
    public void withdrawWorkflowTasks(IBPMContext context, @NotNull List<String> taskIds, Boolean useTaskServiceParticipate) throws BPMException {
        this.logDebug("withdrawWorkflowTasks()", "Start of withdraw tasks");
        if (!taskIds.isEmpty()) {
            try {
                IWorkflowServiceClient wfSvcClient = this.getWorkflowServiceClient(useTaskServiceParticipate);
                ArrayList<String> displayColumns = new ArrayList<String>();
                displayColumns.add(TableConstants.WFTASK_STATE_COLUMN.getName());
                Predicate predicate = new Predicate(TableConstants.WFTASK_TASKID_COLUMN, 9, taskIds);
                ITaskQueryService queryService = wfSvcClient.getTaskQueryService();
                List tasks = queryService.queryTasks((IWorkflowContext)context, displayColumns, new ArrayList(), ITaskQueryService.AssignmentFilter.ALL, "", predicate, null, 0, 0);
                ITaskService taskService = wfSvcClient.getTaskService();
                for (Task task : tasks) {
                    try {
                        if (WorkflowUtil.isTaskStale((Task)task)) continue;
                        taskService.withdrawTask((IWorkflowContext)context, task.getSystemAttributes().getTaskId());
                    }
                    catch (Exception e) {
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (String)InternalInstanceManagementService.class.getName(), (String)"withdrawWorkflowTasks", (String)("Unable to withdraw task [" + task.getSystemAttributes().getTaskId() + "] {" + e.toString() + "}"));
                    }
                }
            }
            catch (Exception exc) {
                throw new BPMException(70208, null, (Throwable)exc);
            }
        } else {
            this.logDebug("withrawWorkflowTasks()", "No user tasks to withdraw");
        }
        this.logDebug("withdrawWorkflowTasks()", "Start of withdraw tasks");
    }

    @Override
    public void updatePriorityOfWorkflowTasks(@NotNull List<String> taskIds, int priority) throws BPMException {
        IBPMContext context = null;
        try {
            context = Util.getInternalWorkflowContext();
        }
        catch (Exception e) {
            throw new BPMException(70211, null, (Throwable)e);
        }
        this.updatePriorityOfWorkflowTasks(context, taskIds, priority);
    }

    @Override
    public void updatePriorityOfWorkflowTasks(IBPMContext context, @NotNull List<String> taskIds, int priority) throws BPMException {
        this.logDebug("updatePriorityOfWorkflowTasks()", "Start of updating priority of tasks");
        if (!taskIds.isEmpty()) {
            try {
                IWorkflowServiceClient wfSvcClient = WorkflowServiceClientFactory.getWorkflowServiceClient((String)"LOCAL");
                List<Task> tasks = this.queryTasksUsingTQService(taskIds, (IWorkflowContext)context, wfSvcClient);
                ITaskService taskService = wfSvcClient.getTaskService();
                for (Task task : tasks) {
                    try {
                        if (WorkflowUtil.isTaskStale((Task)task)) continue;
                        taskService.updatePriority((IWorkflowContext)context, task.getSystemAttributes().getTaskId(), ITaskService.UpdatePriorityType.UPDATE, priority);
                    }
                    catch (Exception e) {
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (String)InternalInstanceManagementService.class.getName(), (String)"updatePriorityOfWorkflowTasks", (String)("Unable to update priority of task [" + task.getSystemAttributes().getTaskId() + "] {" + e.toString() + "}"));
                    }
                }
            }
            catch (Exception exc) {
                throw new BPMException(70211, null, (Throwable)exc);
            }
        } else {
            this.logDebug("updatePriorityOfWorkflowTasks()", "No workflow tasks to update priority");
        }
        this.logDebug("updatePriorityOfWorkflowTasks()", "End of updating priority of tasks");
    }

    @Override
    public void updateWorkflowTasksOutcome(@NotNull List<String> taskIds, String outcome) throws BPMException {
        IBPMContext context = null;
        try {
            context = Util.getInternalWorkflowContext();
        }
        catch (Exception e) {
            throw new BPMException(70212, null, (Throwable)e);
        }
        this.updateWorkflowTasksOutcome(context, taskIds, outcome);
    }

    @Override
    public void updateWorkflowTasksOutcome(IBPMContext context, @NotNull List<String> taskIds, String outcome) throws BPMException {
        this.logDebug("updateWorkflowTasksOutcome()", "Start of updating outcome of workflow tasks");
        if (!taskIds.isEmpty()) {
            try {
                IWorkflowServiceClient wfSvcClient = WorkflowServiceClientFactory.getWorkflowServiceClient((String)"LOCAL");
                List<Task> tasks = this.queryTasksUsingTQService(taskIds, (IWorkflowContext)context, wfSvcClient);
                ITaskService taskService = wfSvcClient.getTaskService();
                for (Task task : tasks) {
                    try {
                        if (WorkflowUtil.isTaskStale((Task)task)) continue;
                        taskService.updateTaskOutcome((IWorkflowContext)context, task.getSystemAttributes().getTaskId(), outcome);
                    }
                    catch (Exception e) {
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (String)InternalInstanceManagementService.class.getName(), (String)"updateWorkflowTasksOutcome", (String)("Unable to update priority of task [" + task.getSystemAttributes().getTaskId() + "] {" + e.toString() + "}"));
                    }
                }
            }
            catch (Exception exc) {
                throw new BPMException(70212, null, (Throwable)exc);
            }
        } else {
            this.logDebug("updateWorkflowTasksOutcome()", "No workflow tasks to update outcome");
        }
        this.logDebug("updateWorkflowTasksOutcome()", "End of updating outcome of workflow tasks");
    }

    @Override
    public void suspendWorkflowTasks(@NotNull List<String> taskIds) throws BPMException {
        IBPMContext context = null;
        try {
            context = Util.getInternalWorkflowContext();
        }
        catch (Exception e) {
            throw new BPMException(70214, null, (Throwable)e);
        }
        this.suspendWorkflowTasks(context, taskIds);
    }

    @Override
    public void suspendWorkflowTasks(IBPMContext context, @NotNull List<String> taskIds) throws BPMException {
        this.logDebug("suspendWorkflowTasks()", "Start of suspending workflow tasks");
        if (!taskIds.isEmpty()) {
            try {
                IWorkflowServiceClient wfSvcClient = WorkflowServiceClientFactory.getWorkflowServiceClient((String)"LOCAL");
                List<Task> tasks = this.queryTasksUsingTQService(taskIds, (IWorkflowContext)context, wfSvcClient);
                ITaskService taskService = wfSvcClient.getTaskService();
                for (Task task : tasks) {
                    try {
                        if (WorkflowUtil.isTaskStale((Task)task)) continue;
                        taskService.suspendTask((IWorkflowContext)context, task.getSystemAttributes().getTaskId());
                    }
                    catch (Exception e) {
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (String)InternalInstanceManagementService.class.getName(), (String)"suspendWorkflowTasks", (String)("Unable to suspend workflow task [" + task.getSystemAttributes().getTaskId() + "] {" + e.toString() + "}"));
                    }
                }
            }
            catch (Exception exc) {
                throw new BPMException(70214, null, (Throwable)exc);
            }
        } else {
            this.logDebug("suspendWorkflowTasks()", "No workflow tasks to suspend");
        }
        this.logDebug("suspendWorkflowTasks()", "End of suspending workflow tasks");
    }

    @Override
    public void resumeWorkflowTasks(@NotNull List<String> taskIds) throws BPMException {
        IBPMContext context = null;
        try {
            context = Util.getInternalWorkflowContext();
        }
        catch (Exception e) {
            throw new BPMException(70215, null, (Throwable)e);
        }
        this.resumeWorkflowTasks(context, taskIds);
    }

    @Override
    public void resumeWorkflowTasks(IBPMContext context, @NotNull List<String> taskIds) throws BPMException {
        this.logDebug("resumeWorkflowTasks()", "Start of resuming workflow tasks");
        if (!taskIds.isEmpty()) {
            try {
                IWorkflowServiceClient wfSvcClient = WorkflowServiceClientFactory.getWorkflowServiceClient((String)"LOCAL");
                List<Task> tasks = this.queryTasksUsingTQService(taskIds, (IWorkflowContext)context, wfSvcClient);
                ITaskService taskService = wfSvcClient.getTaskService();
                for (Task task : tasks) {
                    try {
                        if (WorkflowUtil.isTaskStale((Task)task)) continue;
                        taskService.resumeTask((IWorkflowContext)context, task.getSystemAttributes().getTaskId());
                    }
                    catch (Exception e) {
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (String)InternalInstanceManagementService.class.getName(), (String)"resumeWorkflowTasks", (String)("Unable to resume workflow task [" + task.getSystemAttributes().getTaskId() + "] {" + e.toString() + "}"));
                    }
                }
            }
            catch (Exception exc) {
                throw new BPMException(70215, null, (Throwable)exc);
            }
        } else {
            this.logDebug("resumeWorkflowTasks()", "No workflow tasks to resume");
        }
        this.logDebug("resumeWorkflowTasks()", "End of resuming workflow tasks");
    }

    @Override
    public void escalateWorkflowTasks(@NotNull List<String> taskIds) throws BPMException {
        IBPMContext context = null;
        try {
            context = Util.getInternalWorkflowContext();
        }
        catch (Exception e) {
            throw new BPMException(70216, null, (Throwable)e);
        }
        this.escalateWorkflowTasks(context, taskIds);
    }

    @Override
    public void escalateWorkflowTasks(IBPMContext context, @NotNull List<String> taskIds) throws BPMException {
        this.logDebug("escalateWorkflowTasks()", "Start of escalating workflow tasks");
        if (!taskIds.isEmpty()) {
            try {
                IWorkflowServiceClient wfSvcClient = WorkflowServiceClientFactory.getWorkflowServiceClient((String)"LOCAL");
                List<Task> tasks = this.queryTasksUsingTQService(taskIds, (IWorkflowContext)context, wfSvcClient);
                ITaskService taskService = wfSvcClient.getTaskService();
                for (Task task : tasks) {
                    try {
                        if (WorkflowUtil.isTaskStale((Task)task)) continue;
                        taskService.escalateTask((IWorkflowContext)context, task.getSystemAttributes().getTaskId());
                    }
                    catch (Exception e) {
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (String)InternalInstanceManagementService.class.getName(), (String)"escalateWorkflowTasks", (String)("Unable to escalate workflow task [" + task.getSystemAttributes().getTaskId() + "] {" + e.toString() + "}"));
                    }
                }
            }
            catch (Exception exc) {
                throw new BPMException(70216, null, (Throwable)exc);
            }
        } else {
            this.logDebug("escalateWorkflowTasks()", "No workflow tasks to escalate");
        }
        this.logDebug("escalateWorkflowTasks()", "End of escalating workflow tasks");
    }

    @Override
    public void reassignWorkflowTasks(@NotNull List<String> taskIds, String reassignUser) throws BPMException {
        IBPMContext context = null;
        try {
            context = Util.getInternalWorkflowContext();
        }
        catch (Exception e) {
            throw new BPMException(70213, null, (Throwable)e);
        }
        this.reassignWorkflowTasks(context, taskIds, reassignUser);
    }

    @Override
    public void reassignWorkflowTasks(IBPMContext context, @NotNull List<String> taskIds, String reassignUser) throws BPMException {
        this.logDebug("reassignWorkflowTasks()", "Start of reassigning workflow tasks");
        if (!taskIds.isEmpty()) {
            try {
                IWorkflowServiceClient wfSvcClient = WorkflowServiceClientFactory.getWorkflowServiceClient((String)"LOCAL");
                List<Task> tasks = this.queryTasksUsingTQService(taskIds, (IWorkflowContext)context, wfSvcClient);
                ITaskService taskService = wfSvcClient.getTaskService();
                for (Task task : tasks) {
                    try {
                        if (WorkflowUtil.isTaskStale((Task)task)) continue;
                        TaskAssignee reAssignee = new TaskAssignee(reassignUser, "user");
                        ArrayList<TaskAssignee> l = new ArrayList<TaskAssignee>();
                        l.add(reAssignee);
                        taskService.reassignTask((IWorkflowContext)context, task.getSystemAttributes().getTaskId(), l);
                    }
                    catch (Exception e) {
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (String)InternalInstanceManagementService.class.getName(), (String)"reassignWorkflowTasks", (String)("Unable to reassign workflow task [" + task.getSystemAttributes().getTaskId() + "] {" + e.toString() + "}"));
                    }
                }
            }
            catch (Exception exc) {
                throw new BPMException(70213, null, (Throwable)exc);
            }
        } else {
            this.logDebug("reassignWorkflowTasks()", "No workflow tasks to reassign");
        }
        this.logDebug("reassignWorkflowTasks()", "End of reassigning workflow tasks");
    }

    @Override
    public void suspendTimersOnWorkflowTasks(@NotNull List<String> taskIds) throws BPMException {
        IBPMContext context = null;
        try {
            context = Util.getInternalWorkflowContext();
        }
        catch (Exception e) {
            throw new BPMException(70217, null, (Throwable)e);
        }
        this.suspendTimersOnWorkflowTasks(context, taskIds);
    }

    @Override
    public void suspendTimersOnWorkflowTasks(IBPMContext context, @NotNull List<String> taskIds) throws BPMException {
        this.logDebug("suspendTimersOnWorkflowTasks()", "Start of suspending timers on workflow tasks");
        if (!taskIds.isEmpty()) {
            try {
                IWorkflowServiceClient wfSvcClient = WorkflowServiceClientFactory.getWorkflowServiceClient((String)"LOCAL");
                List<Task> tasks = this.queryTasksUsingTQService(taskIds, (IWorkflowContext)context, wfSvcClient);
                ITaskService taskService = wfSvcClient.getTaskService();
                for (Task task : tasks) {
                    try {
                        if (WorkflowUtil.isTaskStale((Task)task)) continue;
                        taskService.suspendTimers((IWorkflowContext)context, task.getSystemAttributes().getTaskId());
                    }
                    catch (Exception e) {
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (String)InternalInstanceManagementService.class.getName(), (String)"suspendTimersOnWorkflowTasks", (String)("Unable to suspend timers for workflow task [" + task.getSystemAttributes().getTaskId() + "] {" + e.toString() + "}"));
                    }
                }
            }
            catch (Exception exc) {
                throw new BPMException(70217, null, (Throwable)exc);
            }
        } else {
            this.logDebug("suspendTimersOnWorkflowTasks", "No workflow tasks to suspend timers on");
        }
        this.logDebug("suspendTimersOnWorkflowTasks", "End of suspending timers on workflow tasks");
    }

    @Override
    public void resumeTimersOnWorkflowTasks(@NotNull List<String> taskIds) throws BPMException {
        IBPMContext context = null;
        try {
            context = Util.getInternalWorkflowContext();
        }
        catch (Exception e) {
            throw new BPMException(70218, null, (Throwable)e);
        }
        this.resumeTimersOnWorkflowTasks(context, taskIds);
    }

    @Override
    public void resumeTimersOnWorkflowTasks(IBPMContext context, @NotNull List<String> taskIds) throws BPMException {
        this.logDebug("resumeTimersOnWorkflowTasks()", "Start of resuming timers on workflow tasks");
        if (!taskIds.isEmpty()) {
            try {
                IWorkflowServiceClient wfSvcClient = WorkflowServiceClientFactory.getWorkflowServiceClient((String)"LOCAL");
                List<Task> tasks = this.queryTasksUsingTQService(taskIds, (IWorkflowContext)context, wfSvcClient);
                ITaskService taskService = wfSvcClient.getTaskService();
                for (Task task : tasks) {
                    try {
                        if (WorkflowUtil.isTaskStale((Task)task)) continue;
                        taskService.resumeTimers((IWorkflowContext)context, task.getSystemAttributes().getTaskId());
                    }
                    catch (Exception e) {
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (String)InternalInstanceManagementService.class.getName(), (String)"resumeTimersOnWorkflowTasks", (String)("Unable to resume timers for workflow task [" + task.getSystemAttributes().getTaskId() + "] {" + e.toString() + "}"));
                    }
                }
            }
            catch (Exception exc) {
                throw new BPMException(70218, null, (Throwable)exc);
            }
        } else {
            this.logDebug("resumeTimersOnWorkflowTasks", "No workflow tasks to resume timers on");
        }
        this.logDebug("resumeTimersOnWorkflowTasks", "End of resuming timers on workflow tasks");
    }

    @Override
    public Long nextIDFromStore(String sequenceName, int extent) throws BPMException {
        String logMethodName = "nextIDFromStore";
        Long nextId = null;
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            nextId = service.nextIDFromStore(sequenceName, extent);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AUDIT_CORE, (Severity)Severity.ERRORS, (String)InternalInstanceManagementService.class.getName(), (String)"nextIDFromStore", (String)("Unable to get the next ID from the store {" + e.toString() + "}"));
            throw new BPMException(e);
        }
        return nextId;
    }

    @Override
    public IAuditInstance createNewAuditInstance(String compositeDn) throws BPMException {
        String logMethodName = "createNewAuditInstance";
        this.logDebug("createNewAuditInstance", "BEGIN");
        IAuditInstance ai = null;
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            IAuditVariableMetadata varMd = service.getAuditVariableMetadata(compositeDn);
            ai = AuditInstance.newInstance((IAuditVariableMetadata)varMd);
        }
        catch (Exception e) {
            this.logDebug("createNewAuditInstance", "Unable to create a new AuditInstance {" + e + "}");
            throw new BPMException(71301, new Object[]{compositeDn}, (Throwable)e);
        }
        this.logDebug("createNewAuditInstance", "END");
        return ai;
    }

    @Override
    public void logAuditEvent(IBPMContext context, IAuditInstance event) throws BPMException {
        String logMethodName = "logAuditEvent";
        this.logDebug("logAuditEvent", "BEGIN");
        if (event.isMinimalInfoAvailable()) {
            try {
                BPMNAuditEvent evt = new BPMNAuditEvent(event);
                AuditUtil.getAuditTrailLocalService().logAuditEvent(evt);
            }
            catch (Exception e) {
                this.logDebug("logAuditEvent", "Unable to log audit event {" + event + "} {" + e.toString() + "}");
                BPMException exception = new BPMException(71301, new Object[]{event}, (Throwable)e);
                throw exception;
            }
        } else {
            this.logDebug("logAuditEvent", "Audit event defintion is incomplete {" + event + "}");
            BPMException exception = new BPMException(71301, new Object[]{event}, null);
            throw exception;
        }
        this.logDebug("logAuditEvent", "END");
    }

    @Override
    public void logAuditEvent(IBPMContext context, ICubeContext cubeContext, IAuditInstance event) throws BPMException {
        String logMethodName = "logAuditEvent";
        this.logDebug("logAuditEvent", "BEGIN");
        if (event.isMinimalInfoAvailable()) {
            try {
                BPMNAuditEvent evt = new BPMNAuditEvent(event);
                AuditUtil.getAuditTrailLocalService().logAuditEvent(cubeContext, evt);
            }
            catch (Exception e) {
                this.logDebug("logAuditEvent", "Unable to log audit event {" + event + "} {" + e.toString() + "}");
                BPMException exception = new BPMException(71301, new Object[]{event}, (Throwable)e);
                throw exception;
            }
        } else {
            this.logDebug("logAuditEvent", "Audit event defintion is incomplete {" + event + "}");
            BPMException exception = new BPMException(71301, new Object[]{event}, null);
            throw exception;
        }
        this.logDebug("logAuditEvent", "END");
    }

    @Override
    public void markInstanceSuspended(IBPMContext context, String instanceId) throws BPMException {
        this.logDebug("markInstanceSuspended()", "Start of marking instance as suspended. Id: " + instanceId);
        try {
            IInstanceQueryService service = BPMServiceLocator.getInstanceQueryService();
            Predicate pred = new Predicate(IColumnConstants.PROCESS_INSTANCEID_COLUMN, 0, (Object)String.valueOf(instanceId));
            InstanceQueryInput input = new InstanceQueryInput();
            ArrayList displayColumns = new ArrayList();
            input.setAssignmentFilter(IInstanceQueryInput.AssignmentFilter.ALL);
            List instances = service.queryInstances(context, displayColumns, pred, null, (IInstanceQueryInput)input);
            for (IProcessInstance instance : instances) {
                this.logDebug("markInstanceSuspended()", "Marking instance '" + instance.getSystemAttributes().getProcessInstanceId() + "' corresponding to cube instance '" + instanceId + "' as suspended.");
                String currentState = instance.getSystemAttributes().getState();
                if (currentState == null || currentState.equals("SUSPENDED") || currentState.equals("PENDING_MIGRATION_SUSPENDED") || currentState.equals("COMPLETED") || currentState.equals("STALE")) continue;
                if (currentState != null && currentState.equals("PENDING_MIGRATION")) {
                    instance.getSystemAttributes().setState("PENDING_MIGRATION_SUSPENDED");
                    String previousState = instance.getSystemAttributes().getPreviousState();
                    if (previousState == null || previousState.equals("")) {
                        instance.getSystemAttributes().setPreviousState("OPEN");
                    }
                } else {
                    instance.getSystemAttributes().setState("SUSPENDED");
                    instance.getSystemAttributes().setPreviousState(currentState);
                }
                this.insertUpdateInstance(context, instance);
            }
        }
        catch (WorkflowException e) {
            Object[] obj = new String[]{instanceId};
            throw new BPMException(70202, obj, (Throwable)e);
        }
        this.logDebug("markInstanceSuspended()", "End of marking instance as suspended. Id: " + instanceId);
    }

    @Override
    public void markProcessInstancesAsPendingMigration(IBPMContext context, String processDN) throws BPMException {
        this.logDebug("markProcessInstancesAsPendingMigration", "Start of marking instances as pending migration based on component dn " + processDN);
        ComponentDN compDN = new ComponentDN(processDN);
        String compositeDN = compDN.getCompositeDN();
        String componentName = compDN.getComponentName();
        Calendar updatedDate = Calendar.getInstance();
        updatedDate.setTimeInMillis(System.currentTimeMillis());
        boolean inTransaction = false;
        try {
            inTransaction = Transaction.inTransaction();
            if (!inTransaction) {
                Transaction.start((boolean)false);
            }
            IPersistencyService service = Transaction.getPersistencyService();
            service.markTaskAsPendingMigration(compositeDN, componentName, updatedDate);
        }
        catch (Exception exc) {
            Object[] obj = new String[]{processDN};
            throw new BPMException(70202, obj, (Throwable)exc);
        }
        finally {
            if (!inTransaction) {
                try {
                    Transaction.close();
                }
                catch (Exception exc) {}
            }
        }
        this.logDebug("markProcessInstancesAsPendingMigration", "End of marking instances as pending migration based on component dn " + processDN);
    }

    @Override
    public void revertProcessInstanceFromPendingMigrationOrSuspended(IBPMContext context, String instanceId, @Nullable String processDN) throws BPMException {
        try {
            IInstanceQueryService service = BPMServiceLocator.getInstanceQueryService();
            Predicate pred = new Predicate(IColumnConstants.PROCESS_INSTANCEID_COLUMN, 0, (Object)String.valueOf(instanceId));
            InstanceQueryInput input = new InstanceQueryInput();
            ArrayList displayColumns = new ArrayList();
            input.setAssignmentFilter(IInstanceQueryInput.AssignmentFilter.ALL);
            List instances = service.queryInstances(context, displayColumns, pred, null, (IInstanceQueryInput)input);
            String compositeDN = null;
            if (processDN != null) {
                ComponentDN componentDN = new ComponentDN(processDN);
                compositeDN = componentDN.getCompositeDN();
            }
            for (IProcessInstance instance : instances) {
                String currentState;
                if (compositeDN != null) {
                    instance.getSca().setCompositeDN(compositeDN);
                }
                if ((currentState = instance.getSystemAttributes().getState()) == null || currentState.equals("COMPLETED") || currentState.equals("STALE")) continue;
                String prevState = instance.getSystemAttributes().getPreviousState();
                String nextState = prevState != null && !prevState.isEmpty() ? prevState : "OPEN";
                instance.getSystemAttributes().setPreviousState("");
                instance.getSystemAttributes().setState(nextState);
                this.insertUpdateInstance(context, instance);
            }
            this.logDebug("revertProcessInstanceFromPendingMigration", "End of marking instance from pending migration to previous syaye based on instance id" + instanceId);
        }
        catch (Exception exc) {
            throw new BPMException(exc);
        }
    }

    @Override
    public IUserInitiateProcessCleanup getUserInitiateProcessCleanup() {
        return new UserInitiateProcessCleanup();
    }

    private IWorkflowServiceClient getWorkflowServiceClient(Boolean useTaskServiceParticipate) throws WorkflowException {
        HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.TASK_SERVICE_PARTICIPATE_IN_CLIENT_TRANSACTION, useTaskServiceParticipate.toString());
        return WorkflowServiceClientFactory.getWorkflowServiceClient((String)"LOCAL", properties, null);
    }

    private List<Task> queryTasksUsingTQService(@NotNull List<String> taskIds, IWorkflowContext context, IWorkflowServiceClient wfSvcClient) throws Exception {
        ArrayList<String> displayColumns = new ArrayList<String>();
        displayColumns.add(TableConstants.WFTASK_STATE_COLUMN.getName());
        Predicate predicate = new Predicate(TableConstants.WFTASK_TASKID_COLUMN, 9, taskIds);
        ITaskQueryService queryService = wfSvcClient.getTaskQueryService();
        List tasks = queryService.queryTasks(context, displayColumns, new ArrayList(), ITaskQueryService.AssignmentFilter.ALL, "", predicate, null, 0, 0);
        return tasks;
    }

    private void logDebug(String methodName, String message) {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"oracle.bpm.engine.instancemanagement.impl.InternalInstanceManagementService", (String)methodName, (String)message);
    }
}

