/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.wft;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import oracle.apps.fnd.wf.common.WorkflowContext;
import oracle.apps.fnd.wf.design.Activity;
import oracle.apps.fnd.wf.design.AttributeValue;
import oracle.apps.fnd.wf.design.DesignStore;
import oracle.apps.fnd.wf.design.EventActivity;
import oracle.apps.fnd.wf.design.ItemAttribute;
import oracle.apps.fnd.wf.design.ItemType;
import oracle.apps.fnd.wf.design.LookupCode;
import oracle.apps.fnd.wf.design.LookupType;
import oracle.apps.fnd.wf.design.ProcessActivity;
import oracle.apps.fnd.wf.design.Transition;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.bpmn.Event;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.Gateway;
import oracle.tutor.bpmn.GraphicalElement;
import oracle.tutor.bpmn.Lane;
import oracle.tutor.bpmn.Operation;
import oracle.tutor.bpmn.Pool;
import oracle.tutor.bpmn.Resource;
import oracle.tutor.bpmn.SequenceFlow;
import oracle.tutor.bpmn.Subprocess;
import oracle.tutor.bpmn.Task;

public class WFTConverter {
    private static final Logger LOG = Logger.getLogger(WFTConverter.class.getName());
    private static int seqNum = 0;
    private static float minX = 0.0f;
    private static float minY = 0.0f;
    private static float OBJECT_HEIGHT = 15.0f;
    private LinkedList resources;
    private DesignStore designStore;

    public BusinessProcessDiagram[] importWft(String wftFilePath) throws Exception {
        WorkflowContext ctx = new WorkflowContext(wftFilePath);
        try {
            List actattl;
            List<Activity> topLevelProcesses;
            this.designStore = DesignStore.getInstance((WorkflowContext)ctx);
            ArrayList<BusinessProcessDiagram> bpdList = new ArrayList<BusinessProcessDiagram>();
            int arrayIndex = 0;
            Iterator itts = this.designStore.getRoles().iterator();
            for (ItemType child : this.designStore.getItemTypes()) {
                topLevelProcesses = this.getTopLevelProcesses(child);
                if (topLevelProcesses.isEmpty()) {
                    LOG.info("There are no top level processes for item type" + child.getDisplayName());
                }
                for (Activity obj : topLevelProcesses) {
                    actattl = obj.getChildren();
                    BusinessProcessDiagram bpd = new BusinessProcessDiagram(obj.getId(), obj.getDisplayName());
                    bpd.setToolID("Oracle Workflow");
                    bpd.setCoordinateOrigin(BusinessProcessDiagram.CoordinateOrigins.UPPERLEFT);
                    bpd.setVersion(String.valueOf(this.designStore.getVersion().getVersionNumber()));
                    Pool p = new Pool("P0", "", bpd);
                    Lane l = new Lane("SYSADMIN", "SYSADMIN", p);
                    for (int i = 0; i < actattl.size(); ++i) {
                        for (Object myAct : actattl) {
                            if (!(myAct instanceof ProcessActivity)) continue;
                            ProcessActivity act = (ProcessActivity)myAct;
                            if (bpd.getAllNodes().containsKey(act.getId() + "_" + act.getParent().getId())) continue;
                            this.createNode(act, bpd, l);
                        }
                    }
                    this.setBpmnLaneWidth(l, bpd);
                    p.setWidth(l.getWidth());
                    p.setHeight(l.getHeight());
                    bpd.shift(Math.max(0.0f, -minX), Math.max(0.0f, -minY));
                    bpdList.add(bpd);
                    ++arrayIndex;
                }
            }
            arrayIndex = 0;
            for (ItemType child : this.designStore.getItemTypes()) {
                topLevelProcesses = this.getTopLevelProcesses(child);
                for (Activity obj : topLevelProcesses) {
                    actattl = obj.getChildren();
                    for (int j = 0; j < actattl.size(); ++j) {
                        if (!(actattl.get(j) instanceof ProcessActivity)) continue;
                        ProcessActivity act = (ProcessActivity)actattl.get(j);
                        this.createFlows(act, (BusinessProcessDiagram)bpdList.get(arrayIndex));
                    }
                    ++arrayIndex;
                }
            }
            BusinessProcessDiagram[] bpdArray = bpdList.toArray(new BusinessProcessDiagram[bpdList.size()]);
            return bpdArray;
        }
        catch (Exception e) {
            LOG.severe("Could nor load Workflow Design Store");
            e.printStackTrace();
            throw e;
        }
    }

    private FlowObject createNode(ProcessActivity act, BusinessProcessDiagram bpd, Lane l) {
        Event e = null;
        Gateway g = null;
        Task t = null;
        String performerName = null;
        String tempFunction = "";
        String string = act.getActivity().getType();
        act.getActivity();
        if (string.equals("PROCESS")) {
            Subprocess s = new Subprocess(act.getId() + "_" + act.getParent().getId(), act.getActivity().getDisplayName().replaceAll(" ", "_"), l);
            Activity subProc = act.getActivity();
            float subProcObjX = 0.0f;
            float subProcObjY = 0.0f;
            s.setExpanded(Boolean.valueOf(false));
            this.setCommonPropertiesOnBpmnObjects((FlowObject)s, act, bpd, l);
            bpd.setRelativeObjectCoordinates(true);
            List actattl = subProc.getChildren();
            for (int i = 0; i < actattl.size(); ++i) {
                if (!(actattl.get(i) instanceof ProcessActivity)) continue;
                ProcessActivity subProcAct = (ProcessActivity)actattl.get(i);
                FlowObject f = null;
                f = bpd.getAllNodes().containsKey(subProcAct.getId() + "_" + subProcAct.getParent().getId()) ? bpd.getNode(subProcAct.getId() + "_" + subProcAct.getParent().getId()) : this.createNode(subProcAct, bpd, l);
                if (f.getX() > subProcObjX) {
                    subProcObjX = f.getX() + OBJECT_HEIGHT;
                }
                if (f.getY() > subProcObjY) {
                    subProcObjY = f.getY() + OBJECT_HEIGHT;
                }
                f.setParentSubProcess(s);
            }
            s.setExpandedHeight((double)subProcObjY);
            s.setExpandedWidth((double)subProcObjX);
            return s;
        }
        if (act.getPerformerName() != null) {
            performerName = act.getPerformerName();
        }
        if (act.getActivity().getTempFunction() != null) {
            tempFunction = act.getActivity().getTempFunction();
        }
        if (tempFunction.equals("WF_STANDARD.ANDJOIN")) {
            g = new Gateway(act.getId() + "_" + act.getParent().getId(), act.getActivity().getDisplayName(), l);
            this.setCommonPropertiesOnBpmnObjects((FlowObject)g, act, bpd, l);
            return g;
        }
        if (tempFunction.equals("WF_STANDARD.ORJOIN")) {
            g = new Gateway(act.getId() + "_" + act.getParent().getId(), act.getActivity().getDisplayName().replaceAll(" ", "_"), l);
            g.setGatewayType(Gateway.GatewayType.XOR_DATA);
            this.setCommonPropertiesOnBpmnObjects((FlowObject)g, act, bpd, l);
            return g;
        }
        if (act.isAStartNode(null)) {
            e = new Event(act.getId() + "_" + act.getParent().getId(), act.getActivity().getDisplayName(), l);
            e.setEventType(Event.EventType.START);
            this.setCommonPropertiesOnBpmnObjects((FlowObject)e, act, bpd, l);
            return e;
        }
        if (act.isEndNode()) {
            e = new Event(act.getId() + "_" + act.getParent().getId(), act.getActivity().getDisplayName(), l);
            e.setEventType(Event.EventType.END);
            this.setCommonPropertiesOnBpmnObjects((FlowObject)e, act, bpd, l);
            return e;
        }
        String string2 = act.getActivity().getType();
        act.getActivity();
        if (string2.equals("EVENT")) {
            EventActivity evtAct = (EventActivity)act.getActivity();
            e = new Event(act.getId() + "_" + act.getParent().getId(), act.getActivity().getDisplayName(), l);
            e.setEventType(Event.EventType.INTERMEDIATE);
            if (evtAct.getAction() != null) {
                if (evtAct.getAction().equals("SEND") || evtAct.getAction().equals("RAISE")) {
                    e.setTrigger(Event.Trigger.MESSAGE);
                    e.setDirection(Event.Direction.THROW);
                } else if (evtAct.getAction().equals("RECEIVE")) {
                    e.setTrigger(Event.Trigger.MESSAGE);
                    e.setDirection(Event.Direction.CATCH);
                }
            }
            this.setCommonPropertiesOnBpmnObjects((FlowObject)e, act, bpd, l);
            return e;
        }
        if (tempFunction.equals("WF_STANDARD.WAIT")) {
            e = new Event(act.getId() + "_" + act.getParent().getId(), act.getActivity().getDisplayName(), l);
            e.setTrigger(Event.Trigger.TIMER);
            e.setEventType(Event.EventType.INTERMEDIATE);
            this.setCommonPropertiesOnBpmnObjects((FlowObject)e, act, bpd, l);
            return e;
        }
        if (tempFunction.equals("WF_STANDARD.WAITFORFLOW")) {
            e = new Event(act.getId() + "_" + act.getParent().getId(), act.getActivity().getDisplayName(), l);
            e.setTrigger(Event.Trigger.SIGNAL);
            e.setDirection(Event.Direction.THROW);
            e.setEventType(Event.EventType.INTERMEDIATE);
            this.setCommonPropertiesOnBpmnObjects((FlowObject)e, act, bpd, l);
            return e;
        }
        if (tempFunction.equals("WF_STANDARD.CONTINUEFLOW")) {
            e = new Event(act.getId() + "_" + act.getParent().getId(), act.getActivity().getDisplayName(), l);
            e.setTrigger(Event.Trigger.SIGNAL);
            e.setDirection(Event.Direction.CATCH);
            e.setEventType(Event.EventType.INTERMEDIATE);
            this.setCommonPropertiesOnBpmnObjects((FlowObject)e, act, bpd, l);
            return e;
        }
        if (tempFunction.equals("WF_STANDARD.BLOCK")) {
            e = new Event(act.getId() + "_" + act.getParent().getId(), act.getActivity().getDisplayName(), l);
            e.setTrigger(Event.Trigger.MESSAGE);
            e.setDirection(Event.Direction.CATCH);
            e.setEventType(Event.EventType.INTERMEDIATE);
            this.setCommonPropertiesOnBpmnObjects((FlowObject)e, act, bpd, l);
            return e;
        }
        if (tempFunction.equals("WF_STANDARD.NOOP")) {
            e = new Event(act.getId() + "_" + act.getParent().getId(), act.getActivity().getDisplayName(), l);
            e.setTrigger(Event.Trigger.NONE);
            e.setEventType(Event.EventType.INTERMEDIATE);
            this.setCommonPropertiesOnBpmnObjects((FlowObject)e, act, bpd, l);
            return e;
        }
        if (tempFunction.equals("WF_STANDARD.COMPARE")) {
            g = new Gateway(act.getId() + "_" + act.getParent().getId(), act.getActivity().getDisplayName(), l);
            g.setGatewayType(Gateway.GatewayType.XOR_DATA);
            this.setCommonPropertiesOnBpmnObjects((FlowObject)g, act, bpd, l);
            return g;
        }
        if (tempFunction.equals("WF_STANDARD.LOOPCOUNTER")) {
            t = new Task(act.getId() + "_" + act.getParent().getId(), act.getActivity().getDisplayName(), l);
            t.setTaskType(Task.TaskType.SCRIPT);
            this.setCommonPropertiesOnBpmnObjects((FlowObject)t, act, bpd, l);
            return t;
        }
        if (act.getActivity().isRunnable() || tempFunction.equals("WF_STANDARD.ROLERESOLUTION")) {
            t = new Task(act.getId() + "_" + act.getParent().getId(), act.getActivity().getDisplayName(), l);
            t.setCompensation(Boolean.valueOf(false));
            t.setTaskType(Task.TaskType.SERVICE);
            this.setCommonPropertiesOnBpmnObjects((FlowObject)t, act, bpd, l);
            if (performerName != null) {
                t.addResource(new Resource(performerName));
            }
            t.setOperationRef(new Operation(tempFunction));
            t.setLane(l);
            this.setAttributes((FlowObject)t, act);
            return t;
        }
        if (tempFunction.equals("WF_STANDARD.NOTIFY") || tempFunction.equals("WF_STANDARD.VOTEFORRESULTTYPE") || act.getActivity().getType().equals("NOTICE")) {
            t = new Task(act.getId() + "_" + act.getParent().getId(), act.getActivity().getDisplayName(), l);
            t.setCompensation(Boolean.valueOf(false));
            t.setTaskType(Task.TaskType.USER);
            this.setCommonPropertiesOnBpmnObjects((FlowObject)t, act, bpd, l);
            if (performerName != null) {
                t.addResource(new Resource(performerName));
            }
            if (performerName != null) {
                t.addResource(new Resource(performerName));
            }
            t.setOperationRef(new Operation(tempFunction));
            return t;
        }
        t = new Task(act.getId() + "_" + act.getParent().getId(), act.getActivity().getDisplayName(), l);
        t.setCompensation(Boolean.valueOf(false));
        this.setCommonPropertiesOnBpmnObjects((FlowObject)t, act, bpd, l);
        if (performerName != null) {
            t.addResource(new Resource(performerName));
        }
        t.setOperationRef(new Operation(tempFunction));
        return t;
    }

    private void createFlows(ProcessActivity act, BusinessProcessDiagram bpd) {
        String string = act.getActivity().getType();
        act.getActivity();
        if (string.equals("PROCESS")) {
            Activity subProc = act.getActivity();
            List actattl = subProc.getChildren();
            for (Object obj : actattl) {
                if (!(obj instanceof ProcessActivity)) continue;
                ProcessActivity subProcAct = (ProcessActivity)obj;
                this.createFlows(subProcAct, bpd);
            }
        }
        Iterator i = act.getTransitions();
        while (i.hasNext()) {
            Transition tr = (Transition)i.next();
            String seqLabel = "";
            ++seqNum;
            if (tr.getActivityResultCode() != null && tr.getActivityResultCode() != "*") {
                seqLabel = this.getTransitionLabelFromResultCode(tr.getActivityResultCode(), act);
            }
            FlowObject bpmnSrc = bpd.getNode(act.getId() + "_" + act.getParent().getId());
            FlowObject bpmnTgt = bpd.getNode(tr.getToNode().getId() + "_" + tr.getToNode().getParent().getId());
            SequenceFlow sf = new SequenceFlow("Flow_" + seqNum, seqLabel, (GraphicalElement)bpmnSrc, (GraphicalElement)bpmnTgt);
            sf.setDefault(Boolean.valueOf(tr.isDefaultTransition()));
        }
    }

    private float getNodeX(String iconGeometry) {
        String X = iconGeometry.substring(0, iconGeometry.indexOf(","));
        Float xVal = Float.valueOf(Float.valueOf(X).floatValue());
        if (xVal.floatValue() < minX) {
            minX = xVal.floatValue();
        }
        return xVal.floatValue();
    }

    private float getNodeY(String iconGeometry) {
        String Y = iconGeometry.substring(iconGeometry.indexOf(",") + 1, iconGeometry.length());
        Float yVal = Float.valueOf(Float.valueOf(Y).floatValue());
        if (yVal.floatValue() < minY) {
            minY = yVal.floatValue();
        }
        return yVal.floatValue();
    }

    public String exportWFT(BusinessProcessDiagram bpd) {
        return "null";
    }

    public void setBpmnLaneWidth(Lane l, BusinessProcessDiagram bpd) {
        double maxWidth = 0.0;
        double maxHeight = 0.0;
        for (FlowObject bpmnNode : bpd.getAllNodes().values()) {
            float hsize = 0.0f;
            float vsize = 0.0f;
            if (bpmnNode.getParentSubProcess() != null) continue;
            if (bpmnNode instanceof Subprocess && !((Subprocess)bpmnNode).isExpanded().booleanValue()) {
                Subprocess tempSp = (Subprocess)bpmnNode;
                hsize = (float)tempSp.getExpandedWidth() / 2.0f + tempSp.getX();
                vsize = (float)tempSp.getExpandedHeight() / 2.0f + tempSp.getY();
            } else {
                hsize = bpmnNode.getWidth() / 2.0f + bpmnNode.getX();
                vsize = bpmnNode.getHeight() / 2.0f + bpmnNode.getY();
            }
            if (maxWidth < (double)hsize) {
                maxWidth = hsize;
            }
            if (!(maxHeight < (double)vsize)) continue;
            maxHeight = vsize;
        }
        l.setWidth(maxWidth + (double)OBJECT_HEIGHT);
        l.setHeight(maxHeight + (double)OBJECT_HEIGHT);
    }

    public void setCommonPropertiesOnBpmnObjects(FlowObject bpmnFlowObject, ProcessActivity act, BusinessProcessDiagram bpd, Lane l) {
        bpmnFlowObject.setDocumentation(act.getActivity().getDescription());
        bpmnFlowObject.setWidth(15.0f);
        bpmnFlowObject.setHeight(15.0f);
        bpmnFlowObject.setObjectPin(GraphicalElement.ObjectPin.MIDDLE);
        String iconGeometry = act.getIconGeometry();
        if (iconGeometry != null) {
            bpmnFlowObject.setX(this.getNodeX(iconGeometry));
            bpmnFlowObject.setY(this.getNodeY(iconGeometry));
        }
        bpmnFlowObject.setLane(l);
        this.setAttributes(bpmnFlowObject, act);
        bpd.addNode(bpmnFlowObject);
    }

    private String getTransitionLabelFromResultCode(String resultCode, ProcessActivity act) {
        for (ItemType child : this.designStore.getItemTypes()) {
            for (Object obj : child.getChildren()) {
                if (!(obj instanceof LookupType)) continue;
                LookupType lt = (LookupType)obj;
                if (!act.getActivity().getResult().equals(lt.getName())) continue;
                List lookupCL = lt.getChildren();
                for (int j = 0; j < lookupCL.size(); ++j) {
                    LookupCode lc;
                    if (!(lookupCL.get(j) instanceof LookupCode) || !(lc = (LookupCode)lookupCL.get(j)).getName().equals(resultCode)) continue;
                    return lc.getDisplayName();
                }
            }
        }
        return "";
    }

    private void setAttributes(FlowObject bpdNode, ProcessActivity act) {
        if (act.getAttributeValues() == null) {
            return;
        }
        Iterator i = act.getAttributeValues();
        while (i.hasNext()) {
            AttributeValue attrVal = (AttributeValue)i.next();
            if (attrVal.getValueType().equals("CONSTANT")) {
                bpdNode.setAttribute(attrVal.getAttributeName(), attrVal.getValue());
                continue;
            }
            block1: for (ItemType child : this.designStore.getItemTypes()) {
                List itemAttrs = child.getAttributes();
                for (int j = 0; j < itemAttrs.size(); ++j) {
                    ItemAttribute itAttr = (ItemAttribute)itemAttrs.get(j);
                    if (!itAttr.getName().equals(attrVal.getItemName())) continue;
                    bpdNode.setAttribute(attrVal.getAttributeName(), (Object)itAttr.getDisplayName());
                    continue block1;
                }
            }
        }
    }

    public List<Activity> getTopLevelProcesses(ItemType child) {
        ArrayList<Activity> actList = new ArrayList<Activity>();
        for (Object obj : child.getChildren()) {
            if (!(obj instanceof Activity)) continue;
            Activity activity = (Activity)obj;
            if (!activity.getType().equals("PROCESS") || this.isSubProcess(activity, child)) continue;
            actList.add(activity);
        }
        return actList;
    }

    private boolean isSubProcess(Activity activity, ItemType child) {
        for (Object obj : child.getChildren()) {
            if (!(obj instanceof Activity)) continue;
            List actattl = ((Activity)obj).getChildren();
            for (int i = 0; i < actattl.size(); ++i) {
                if (!(actattl.get(i) instanceof ProcessActivity)) continue;
                ProcessActivity procAct = (ProcessActivity)actattl.get(i);
                String string = procAct.getActivity().getType();
                procAct.getActivity();
                if (!string.equals("PROCESS") || !procAct.getActivity().getName().equals(activity.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

