/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.bpel.sensor;

import com.collaxa.cube.engine.sensor.common.SensorLogger;
import com.collaxa.cube.engine.sensor.dca.data.BpelCapturedData;
import com.collaxa.cube.engine.sensor.dca.data.ICapturedData;
import com.collaxa.cube.engine.sensor.registry.ISensorActionInfo;
import com.collaxa.cube.engine.sensor.registry.ISensorInfo;
import com.collaxa.cube.engine.sensor.registry.RegistryException;
import com.collaxa.cube.engine.sensor.sa.SensorAgencyException;
import com.oracle.bpel.sensor.schemas.TSensorAction;
import com.oracle.bpel.sensor.schemas.TSensorActionFactory;
import java.util.NoSuchElementException;
import oracle.bpm.analytics.AnalyticsLogger;
import oracle.bpm.analytics.bpel.runtime.AnalyticPublisher;
import oracle.bpm.analytics.bpel.sensor.AnalyticSensorInfo;
import oracle.fabric.composite.model.ComponentModel;
import oracle.soa.common.util.CXStringUtils;
import org.w3c.dom.Element;

public class AnalyticSensorActionInfo
implements ISensorActionInfo {
    private static final String CLASSNAME = "AnalyticSensorActionInfo";
    private ComponentModel m_component_model;
    private TSensorAction m_sensor_action;
    private String m_name;
    boolean m_is_enabled;
    private String m_publish_desc;
    ThreadLocal mLocalSensorAction = new ThreadLocal(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object initialValue() {
            TSensorAction tSensorAction = AnalyticSensorActionInfo.this.m_sensor_action;
            synchronized (tSensorAction) {
                try {
                    return TSensorActionFactory.createFacade((Element)AnalyticSensorActionInfo.this.m_sensor_action.getRootElement());
                }
                catch (Exception ex) {
                    SensorLogger.LOG.error(this.getClass(), "initialValue", new Object[]{"error in sensor clone", ex});
                    return null;
                }
            }
        }
    };

    public AnalyticSensorActionInfo(ComponentModel componentModel, TSensorAction sensorAction) throws RegistryException {
        this(sensorAction);
        this.m_component_model = componentModel;
    }

    public AnalyticSensorActionInfo(TSensorAction sensorAction) throws RegistryException {
        this.m_sensor_action = sensorAction;
        this.m_name = sensorAction.getName();
        try {
            this.m_is_enabled = sensorAction.getEnabled();
        }
        catch (NoSuchElementException nsee) {
            this.m_is_enabled = true;
        }
        String type = sensorAction.getPublishType();
        if (CXStringUtils.isEmpty((String)type)) {
            throw new RegistryException((Throwable)new Exception("publish type required"));
        }
    }

    public boolean isActive() {
        return this.m_is_enabled;
    }

    public String getName() {
        return this.m_name;
    }

    public TSensorAction getFacade() {
        return (TSensorAction)this.mLocalSensorAction.get();
    }

    public void publish(ISensorInfo sInfo, ICapturedData cData) throws SensorAgencyException {
        String methodName = "publish";
        BpelCapturedData capturedData = (BpelCapturedData)cData;
        AnalyticSensorInfo sensorInfo = (AnalyticSensorInfo)sInfo;
        AnalyticsLogger.debug(CLASSNAME, "publish", (Object)"Publish called ", (Object)sInfo.getName(), (Object)", node id ", (Object)sensorInfo.getActivityNodeId());
        AnalyticPublisher.publish((AnalyticSensorInfo)sInfo, this, capturedData);
    }

    public String getPublishDescription() {
        return this.m_publish_desc;
    }
}

