/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.bpel.runtime;

import com.collaxa.cube.engine.sensor.dca.data.BpelCapturedData;
import com.collaxa.cube.engine.sensor.registry.BpelSensorInfo;
import com.collaxa.cube.engine.sensor.sa.SensorAgencyException;
import com.collaxa.cube.engine.sensor.sa.publisher.toplink.ToplinkPublisher;
import com.oracle.bpel.sensor.schemas.ITActivityData;
import com.oracle.bpel.sensor.schemas.ITHeaderInfo;
import com.oracle.bpel.sensor.schemas.ITSensorData;
import com.oracle.bpel.sensor.schemas.TSensorActionData;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import oracle.bpm.analytics.AnalyticsLogger;
import oracle.bpm.analytics.bpel.datastore.BpmDataStore;
import oracle.bpm.analytics.bpel.datastore.BpmDataStoreFactory;
import oracle.bpm.analytics.bpel.datastore.model.BpmActivity;
import oracle.bpm.analytics.bpel.datastore.model.BpmActivityInstance;
import oracle.bpm.analytics.bpel.datastore.model.BpmProcess;
import oracle.bpm.analytics.bpel.sensor.AnalyticSensorActionInfo;
import oracle.bpm.analytics.bpel.sensor.AnalyticSensorInfo;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.CompositeModel;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.sessions.Session;
import oracle.toplink.sessions.UnitOfWork;

public class AnalyticPublisher {
    private static final String CLASSNAME = "AnalyticPublisher";
    private static final int RETRY_COUNT = 3;
    private static BpmDataStoreFactory s_store_factory = BpmDataStoreFactory.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void publish(AnalyticSensorInfo sensor, AnalyticSensorActionInfo sensorAction, BpelCapturedData data) throws SensorAgencyException {
        String methodName = "publish";
        BpmDataStore dataStore = null;
        Session session = null;
        UnitOfWork uow = null;
        int retryCount = 0;
        boolean done = false;
        boolean requiresCommit = false;
        long lastNodeSeqNum = 1L;
        AnalyticsLogger.debug(CLASSNAME, "publish", (Object)"sensor ", (Object)sensor.getName(), (Object)", target ", sensor.getTarget(), (Object)", node ", (Object)sensor.getActivityNodeId());
        while (!done && retryCount < 3) {
            BpmActivity bpmActivityShadow;
            block14: {
                dataStore = s_store_factory.getDataStore();
                session = dataStore.createSession();
                uow = session.getActiveUnitOfWork();
                if (uow == null) {
                    uow = session.acquireUnitOfWork();
                    requiresCommit = true;
                }
                if ((bpmActivityShadow = AnalyticPublisher.selectActivity(session, uow, sensor)) != null) break block14;
                AnalyticsLogger.debug(CLASSNAME, "publish", (Object)"No BPM Activity found for sensor ", (Object)sensor.getName(), (Object)" return.");
                if (dataStore != null) {
                    dataStore.releaseUnitOfWork(uow);
                    dataStore.releaseSession(session);
                }
                return;
            }
            try {
                BpmActivityInstance bpmActivityInstance;
                BpmActivity bpmActivity = (BpmActivity)uow.registerExistingObject((Object)bpmActivityShadow);
                Collection bpmActivityInstanceCollection = bpmActivity.getBpmActivityInstanceCollection();
                if (bpmActivityInstanceCollection.isEmpty()) {
                    AnalyticsLogger.debug(CLASSNAME, "publish", (Object)"empty activity instance collection, insert data for ", (Object)sensor.getActivityNodeId());
                    bpmActivityInstance = AnalyticPublisher.createRow(uow, sensor, data);
                    bpmActivityInstance.setNodeSeqNum(1L);
                    bpmActivity.addToBpmActivityInstanceCollection(bpmActivityInstance);
                } else {
                    Iterator instanceIterator = bpmActivityInstanceCollection.iterator();
                    boolean updatedActivity = false;
                    while (instanceIterator.hasNext()) {
                        BpmActivityInstance bpmActivityInstanceOld = (BpmActivityInstance)instanceIterator.next();
                        lastNodeSeqNum = bpmActivityInstanceOld.getNodeSeqNum();
                        if (!bpmActivityInstanceOld.getEvalPoint().equals("activation")) continue;
                        AnalyticsLogger.debug(CLASSNAME, "publish", (Object)"update activity instance ", (Object)sensor.getActivityNodeId(), (Object)", node seq# ", (Object)bpmActivityInstanceOld.getNodeSeqNum());
                        bpmActivityInstance = (BpmActivityInstance)uow.registerExistingObject((Object)bpmActivityInstanceOld);
                        AnalyticPublisher.updateRow(bpmActivityInstance, sensor, data);
                        updatedActivity = true;
                    }
                    if (!updatedActivity) {
                        AnalyticsLogger.debug(CLASSNAME, "publish", (Object)"create new activity instance for ", (Object)sensor.getActivityNodeId(), (Object)", node seq# ", (Object)(lastNodeSeqNum + 1L));
                        bpmActivityInstance = AnalyticPublisher.createRow(uow, sensor, data);
                        bpmActivityInstance.setNodeSeqNum(lastNodeSeqNum + 1L);
                    }
                }
                if (requiresCommit) {
                    uow.validateCache();
                    uow.validateObjectSpace();
                    uow.commit();
                }
                done = true;
                if (dataStore == null) continue;
                dataStore.releaseUnitOfWork(uow);
                dataStore.releaseSession(session);
            }
            catch (Exception e) {
                try {
                    s_store_factory.recreateDataStore();
                    ++retryCount;
                    if (dataStore == null) continue;
                    dataStore.releaseUnitOfWork(uow);
                    dataStore.releaseSession(session);
                }
                catch (Throwable throwable) {
                    if (dataStore != null) {
                        dataStore.releaseUnitOfWork(uow);
                        dataStore.releaseSession(session);
                    }
                    throw throwable;
                }
            }
        }
    }

    private static BpmActivityInstance createRow(UnitOfWork uow, AnalyticSensorInfo sensor, BpelCapturedData data) throws Exception {
        String methodName = "createRow";
        TSensorActionData actionData = data.getFacade((BpelSensorInfo)sensor);
        ITHeaderInfo headerInfo = actionData.getHeader();
        ITSensorData sensorData = actionData.getPayload();
        ITActivityData activityData = sensorData.getActivityData();
        long millis = headerInfo.getTimestamp().getTimeInMillis();
        BpmActivityInstance result = (BpmActivityInstance)uow.registerObject((Object)new BpmActivityInstance());
        AnalyticsLogger.debug(CLASSNAME, "createRow", (Object)"create row for ", (Object)sensor.getActivityNodeId(), (Object)", process id ", (Object)sensor.getProcessId(), (Object)", activity id ", (Object)sensor.getActivityId(), (Object)", process instance ", (Object)headerInfo.getInstanceId());
        result.setActivity(sensor.getActivityId());
        result.setProcess(sensor.getProcessId());
        result.setProcessInstance(headerInfo.getInstanceId());
        result.setCreationDate(new Timestamp(millis));
        result.setEvalPoint(activityData.getEvalPoint());
        if (activityData.getErrorMessage() != null) {
            result.setErrorMessage(activityData.getErrorMessage());
        }
        return result;
    }

    private static void updateRow(BpmActivityInstance activityInstance, AnalyticSensorInfo sensor, BpelCapturedData data) throws Exception {
        String methodName = "updateRow";
        TSensorActionData actionData = data.getFacade((BpelSensorInfo)sensor);
        ITHeaderInfo headerInfo = actionData.getHeader();
        ITSensorData sensorData = actionData.getPayload();
        ITActivityData activityData = sensorData.getActivityData();
        long millis = headerInfo.getTimestamp().getTimeInMillis();
        AnalyticsLogger.debug(CLASSNAME, "updateRow", (Object)"update row for ", (Object)sensor.getActivityNodeId(), (Object)", process id ", (Object)sensor.getProcessId(), (Object)", activity id ", (Object)sensor.getActivityId(), (Object)", process instance ", (Object)headerInfo.getInstanceId());
        activityInstance.setModifyDate(new Timestamp(millis));
        activityInstance.setEvalPoint(activityData.getEvalPoint());
        activityInstance.setEvalTime(ToplinkPublisher.evalTime((Timestamp)activityInstance.getCreationDate(), (Timestamp)activityInstance.getModifyDate()));
        if (activityData.getErrorMessage() != null) {
            activityInstance.setErrorMessage(activityData.getErrorMessage());
        }
    }

    private static BpmActivityInstance selectActivityInstance(Session session, AnalyticSensorInfo sensor, long cikey) throws Exception {
        BpmActivityInstance queryObject = new BpmActivityInstance();
        ReadObjectQuery instanceQuery = new ReadObjectQuery();
        queryObject.setActivity(sensor.getActivityId());
        queryObject.setProcessInstance(cikey);
        instanceQuery.setReferenceClass(BpmActivityInstance.class);
        instanceQuery.setExampleObject((Object)queryObject);
        BpmActivityInstance result = (BpmActivityInstance)session.executeQuery((DatabaseQuery)instanceQuery);
        if (result != null) {
            return (BpmActivityInstance)session.refreshObject((Object)result);
        }
        return null;
    }

    private static BpmActivity selectActivity(Session session, UnitOfWork uow, AnalyticSensorInfo sensor) throws Exception {
        BpmActivity queryObject = new BpmActivity();
        ReadObjectQuery instanceQuery = new ReadObjectQuery();
        BpmProcess bpmProcessShadow = AnalyticPublisher.selectProcess(session, sensor.getComponentModel());
        BpmProcess bpmProcess = (BpmProcess)uow.registerExistingObject((Object)bpmProcessShadow);
        queryObject.setId(sensor.getActivityId());
        queryObject.setBpmProcess(bpmProcess);
        instanceQuery.setReferenceClass(BpmActivity.class);
        instanceQuery.setExampleObject((Object)queryObject);
        BpmActivity result = (BpmActivity)session.executeQuery((DatabaseQuery)instanceQuery);
        if (result != null) {
            return (BpmActivity)session.refreshObject((Object)result);
        }
        return null;
    }

    private static BpmProcess selectProcess(Session session, ComponentModel componentModel) {
        String methodName = "selectProcess";
        ReadObjectQuery instanceQuery = new ReadObjectQuery();
        BpmProcess sampleProcess = new BpmProcess();
        CompositeModel compositeModel = componentModel.getComposite();
        AnalyticsLogger.debug(CLASSNAME, "selectProcess", (Object)"component ", (Object)componentModel.getName());
        sampleProcess.setApplicationName(componentModel.getApplicationName());
        sampleProcess.setCompositeName(compositeModel.getName());
        sampleProcess.setRevision(compositeModel.getRevision());
        sampleProcess.setLabel(compositeModel.getLabel());
        sampleProcess.setName(componentModel.getName());
        instanceQuery.setReferenceClass(BpmProcess.class);
        instanceQuery.setExampleObject((Object)sampleProcess);
        BpmProcess result = (BpmProcess)session.executeQuery((DatabaseQuery)instanceQuery);
        if (result != null) {
            AnalyticsLogger.debug(CLASSNAME, "selectProcess", (Object)"found ", (Object)result.getName());
            return (BpmProcess)session.refreshObject((Object)result);
        }
        AnalyticsLogger.debug(CLASSNAME, "selectProcess", (Object)componentModel.getName(), (Object)" not found");
        return null;
    }
}

