/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.bpel.deployment;

import com.collaxa.cube.engine.core.ICubeProcess;
import com.collaxa.cube.engine.observer.ProcessDeployAspect;
import com.collaxa.cube.engine.observer.ProcessStaleAspect;
import com.collaxa.cube.engine.observer.ProcessUndeployAspect;
import com.collaxa.cube.observer.ICubeAspect;
import com.collaxa.cube.observer.ICubeObserver;
import java.io.File;
import oracle.bpm.analytics.AnalyticLevelEnum;
import oracle.bpm.analytics.AnalyticsLogger;
import oracle.bpm.analytics.bpel.deployment.BPELProcessAnalysisDeployer;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.PropertyModel;

public class BPELProcessAnalysisListener
implements ICubeObserver {
    public static final String CLASSNAME = "BPELProcessAnalysisListener";

    public void update(ICubeAspect iCubeAspect) throws Exception {
        String methodName = "update";
        AnalyticsLogger.debug(CLASSNAME, "update", "Aspect: " + iCubeAspect.getClass().getName());
        if (iCubeAspect instanceof ProcessDeployAspect) {
            ICubeProcess cubeProcess = ((ProcessDeployAspect)iCubeAspect).getProcess();
            ComponentModel componentModel = cubeProcess.getScaComponent();
            PropertyModel propertyModel = componentModel.getProperty(AnalyticLevelEnum.ANALYTIC_PROPERTY.getLevel());
            AnalyticsLogger.debug(CLASSNAME, "update", "deploy");
            if (propertyModel == null) {
                AnalyticsLogger.debug(CLASSNAME, "update", (Object)"Analysis disabled for ", (Object)componentModel.getName());
                return;
            }
            String analysisPropValue = propertyModel.getValue();
            AnalyticsLogger.debug(CLASSNAME, "update", (Object)AnalyticLevelEnum.ANALYTIC_PROPERTY.getLevel(), (Object)" ", (Object)analysisPropValue);
            if (!(analysisPropValue.equals(AnalyticLevelEnum.DESIGN.getLevel()) || analysisPropValue.equals(AnalyticLevelEnum.RUNTIME_BASIC.getLevel()) || analysisPropValue.equals(AnalyticLevelEnum.RUNTIME_INTERMEDIATE.getLevel()) || analysisPropValue.equals(AnalyticLevelEnum.RUNTIME_CUSTOM.getLevel()) || analysisPropValue.equals(AnalyticLevelEnum.RUNTIME_ALL.getLevel()))) {
                AnalyticsLogger.debug(CLASSNAME, "update", (Object)componentModel.getName(), (Object)", unknown property value ", (Object)analysisPropValue, (Object)" analysis disabled.");
                return;
            }
            AnalyticsLogger.debug(CLASSNAME, "update", (Object)"xml-model-file ", (Object)cubeProcess.getXMLModelFile().getAbsolutePath(), (Object)", timestamp ", (Object)cubeProcess.getXMLModelFile().lastModified());
            File wsdlFile = new File(cubeProcess.getContentRoot(), componentModel.getName() + ".wsdl");
            if (wsdlFile.exists()) {
                AnalyticsLogger.debug(CLASSNAME, "update", (Object)"wsdl", (Object)wsdlFile.getAbsolutePath());
            }
            BPELProcessAnalysisDeployer bpelDeployer = new BPELProcessAnalysisDeployer(componentModel, cubeProcess, wsdlFile, AnalyticLevelEnum.getLevel(analysisPropValue));
            AnalyticsLogger.info(CLASSNAME, "update", "Enable Design Analysis for " + componentModel.getName());
            bpelDeployer.deploy();
            AnalyticsLogger.debug(CLASSNAME, "update", "Deploy done.");
        } else if (iCubeAspect instanceof ProcessUndeployAspect) {
            ICubeProcess cubeProcess = ((ProcessUndeployAspect)iCubeAspect).getProcess();
            ComponentModel componentModel = cubeProcess.getScaComponent();
            PropertyModel propertyModel = componentModel.getProperty("configuration.analysisSchema");
            AnalyticsLogger.debug(CLASSNAME, "update", "undeploy");
            if (propertyModel == null) {
                AnalyticsLogger.debug(CLASSNAME, "update", componentModel.getName() + " analysis disabled.");
                return;
            }
            String analysisPropValue = propertyModel.getValue();
            AnalyticsLogger.debug(CLASSNAME, "update", (Object)AnalyticLevelEnum.ANALYTIC_PROPERTY.getLevel(), (Object)" ", (Object)analysisPropValue);
            if (!(analysisPropValue.equals(AnalyticLevelEnum.DESIGN.getLevel()) || analysisPropValue.equals(AnalyticLevelEnum.RUNTIME_BASIC.getLevel()) || analysisPropValue.equals(AnalyticLevelEnum.RUNTIME_INTERMEDIATE.getLevel()) || analysisPropValue.equals(AnalyticLevelEnum.RUNTIME_CUSTOM.getLevel()) || analysisPropValue.equals(AnalyticLevelEnum.RUNTIME_ALL.getLevel()))) {
                AnalyticsLogger.debug(CLASSNAME, "update", (Object)componentModel.getName(), (Object)", unknown property value ", (Object)analysisPropValue, (Object)" analysis disabled.");
                return;
            }
            File wsdlFile = new File(cubeProcess.getContentRoot(), componentModel.getName() + ".wsdl");
            BPELProcessAnalysisDeployer bpelDeployer = new BPELProcessAnalysisDeployer(componentModel, cubeProcess, wsdlFile, AnalyticLevelEnum.DESIGN);
            bpelDeployer.undeploy();
            AnalyticsLogger.debug(CLASSNAME, "update", "Undeploy done.");
        } else if (iCubeAspect instanceof ProcessStaleAspect) {
            ComponentModel componentModel = ((ProcessStaleAspect)iCubeAspect).getComponentModel();
            PropertyModel propertyModel = componentModel.getProperty("configuration.analysisSchema");
            AnalyticsLogger.debug(CLASSNAME, "update", "stale");
            if (propertyModel == null) {
                AnalyticsLogger.debug(CLASSNAME, "update", componentModel.getName() + " analysis disabled.");
                return;
            }
            String analysisPropValue = propertyModel.getValue();
            AnalyticsLogger.debug(CLASSNAME, "update", (Object)AnalyticLevelEnum.ANALYTIC_PROPERTY.getLevel(), (Object)" ", (Object)analysisPropValue);
            if (!(analysisPropValue.equals(AnalyticLevelEnum.DESIGN.getLevel()) || analysisPropValue.equals(AnalyticLevelEnum.RUNTIME_BASIC.getLevel()) || analysisPropValue.equals(AnalyticLevelEnum.RUNTIME_INTERMEDIATE.getLevel()) || analysisPropValue.equals(AnalyticLevelEnum.RUNTIME_CUSTOM.getLevel()) || analysisPropValue.equals(AnalyticLevelEnum.RUNTIME_ALL.getLevel()))) {
                AnalyticsLogger.debug(CLASSNAME, "update", (Object)componentModel.getName(), (Object)", unknown property value ", (Object)analysisPropValue, (Object)" analysis disabled.");
                return;
            }
            BPELProcessAnalysisDeployer bpelDeployer = new BPELProcessAnalysisDeployer(componentModel, AnalyticLevelEnum.DESIGN);
            bpelDeployer.undeploy();
            AnalyticsLogger.debug(CLASSNAME, "update", "Stale done.");
        }
    }
}

