/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.bpel.deployment;

import com.collaxa.cube.engine.core.ICubeProcess;
import com.collaxa.cube.engine.sensor.registry.ISensorActionInfo;
import com.collaxa.cube.engine.sensor.registry.ISensorInfo;
import com.collaxa.cube.engine.sensor.registry.ISensorRegistry;
import com.oracle.bpel.sensor.schemas.ITActivityConfig;
import com.oracle.bpel.sensor.schemas.TActivityConfig;
import com.oracle.bpel.sensor.schemas.TActivityConfigFactory;
import com.oracle.bpel.sensor.schemas.TSensor;
import com.oracle.bpel.sensor.schemas.TSensorAction;
import com.oracle.bpel.sensor.schemas.TSensorActionFactory;
import com.oracle.bpel.sensor.schemas.TSensorFactory;
import java.io.File;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import oracle.bpm.analytics.AnalyticLevelEnum;
import oracle.bpm.analytics.AnalyticsLogger;
import oracle.bpm.analytics.bpel.BpelActivityEnum;
import oracle.bpm.analytics.bpel.datastore.BpmActivityHandler;
import oracle.bpm.analytics.bpel.datastore.BpmDataStore;
import oracle.bpm.analytics.bpel.datastore.BpmProcessPartnerHandler;
import oracle.bpm.analytics.bpel.datastore.model.BpmActivity;
import oracle.bpm.analytics.bpel.datastore.model.BpmActivityProperty;
import oracle.bpm.analytics.bpel.datastore.model.BpmProcess;
import oracle.bpm.analytics.bpel.datastore.model.BpmProcessPartner;
import oracle.bpm.analytics.bpel.sensor.AnalyticSensorActionInfo;
import oracle.bpm.analytics.bpel.sensor.AnalyticSensorInfo;
import oracle.fabric.common.wsdl.WSDLManager;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.CompositeModel;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.sessions.Session;
import oracle.toplink.sessions.UnitOfWork;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.ProcessDocument;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TPartnerLink;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TPartnerLinks;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TProcess;
import org.xmlsoap.schemas.ws.x2003.x03.businessProcess.TSequence;

public class BPELProcessAnalysisDeployer {
    private static final String CLASSNAME = "BPELProcessAnalysisDeployer";
    private static final int STATUS_ACTIVE = 1;
    private static final int STATUS_INACTIVE = 0;
    private static final int STATUS_DELETED = -1;
    private ComponentModel m_component_model;
    private ICubeProcess m_cube_process;
    private File m_bpel_wsdl_source;
    private AnalyticLevelEnum m_analytic_level;

    public BPELProcessAnalysisDeployer(ComponentModel componentModel, ICubeProcess cubeProcess, File wsdlSource, AnalyticLevelEnum level) {
        this.m_component_model = componentModel;
        this.m_cube_process = cubeProcess;
        this.m_bpel_wsdl_source = wsdlSource;
        this.m_analytic_level = level;
    }

    public BPELProcessAnalysisDeployer(ComponentModel componentModel, AnalyticLevelEnum level) {
        this(componentModel, null, null, level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy() throws Exception {
        BpmProcess bpmProcess;
        long bpelSourceTimestamp;
        boolean requiresCommit;
        UnitOfWork uow;
        Session session;
        BpmDataStore dataStore;
        TProcess bpelProcess;
        block14: {
            String methodName = "deploy";
            ProcessDocument pDocument = ProcessDocument.Factory.parse((File)this.m_cube_process.getXMLModelFile());
            bpelProcess = pDocument.getProcess();
            dataStore = new BpmDataStore();
            session = null;
            uow = null;
            requiresCommit = false;
            AnalyticsLogger.debug(CLASSNAME, "deploy", (Object)"process ", (Object)this.m_cube_process.getProcessDN().toString());
            session = dataStore.createSession();
            uow = session.getActiveUnitOfWork();
            if (uow == null) {
                uow = session.acquireUnitOfWork();
                requiresCommit = true;
            }
            bpelSourceTimestamp = this.m_cube_process.getXMLModelFile().lastModified();
            bpmProcess = this.selectProcess(session);
            AnalyticsLogger.debug(CLASSNAME, "deploy", (Object)this.m_cube_process.getProcessDN().toString(), (Object)(" deploy timestamp " + bpelSourceTimestamp));
            if (bpmProcess == null || bpmProcess.getCreationDate().getTime() != bpelSourceTimestamp) break block14;
            AnalyticsLogger.debug(CLASSNAME, "deploy", (Object)this.m_cube_process.getProcessDN().toString(), (Object)" is up to date.");
            if (this.m_analytic_level == AnalyticLevelEnum.RUNTIME_BASIC || this.m_analytic_level == AnalyticLevelEnum.RUNTIME_CUSTOM || this.m_analytic_level == AnalyticLevelEnum.RUNTIME_INTERMEDIATE || this.m_analytic_level == AnalyticLevelEnum.RUNTIME_ALL) {
                AnalyticsLogger.debug(CLASSNAME, "deploy", (Object)"Prepare sensor registry of ", (Object)this.m_cube_process.getProcessDN().toString(), (Object)" for analytic Level ", (Object)this.m_analytic_level.toString());
                this.prepareSensorRegistry(session, uow, bpmProcess);
            }
            dataStore.releaseUnitOfWork(uow);
            dataStore.releaseSession(session);
            return;
        }
        try {
            if (bpmProcess != null) {
                AnalyticsLogger.debug(CLASSNAME, "deploy", (Object)this.m_cube_process.getProcessDN().toString(), (Object)" is stale, remove from persistence.");
                this.purgeSensorRegistry(bpmProcess);
                uow.deleteObject((Object)bpmProcess);
                if (requiresCommit) {
                    uow.commit();
                    dataStore.releaseUnitOfWork(uow);
                }
                AnalyticsLogger.debug(CLASSNAME, "deploy", (Object)"Recreate ", (Object)this.m_cube_process.getProcessDN().toString());
                uow = session.getActiveUnitOfWork();
                if (uow == null) {
                    uow = session.acquireUnitOfWork();
                    requiresCommit = true;
                }
            }
            AnalyticsLogger.debug(CLASSNAME, "deploy", (Object)"insert into bpm_process ", (Object)this.m_component_model.getName(), (Object)(", timestamp " + bpelSourceTimestamp));
            bpmProcess = this.upsertProcess(session, uow, bpelProcess, bpelSourceTimestamp);
            AnalyticsLogger.debug(CLASSNAME, "deploy", (Object)"insert into bpm_process_partner ", (Object)this.m_cube_process.getProcessDN().toString(), (Object)", #partners: ", (Object)bpelProcess.getPartnerLinks().sizeOfPartnerLinkArray());
            WSDLManager wsdlMgr = this.m_component_model.getComposite().getWSDLManager();
            String targetNamespace = bpelProcess.getTargetNamespace();
            List definitions = wsdlMgr.listDefinitions(targetNamespace);
            if (definitions.size() > 1) {
                AnalyticsLogger.debug(CLASSNAME, "deploy", (Object)"insert into bpm_process_partner ", (Object)this.m_cube_process.getProcessDN().toString(), (Object)", #targetNamespace: ", (Object)targetNamespace, (Object)", #Size of definitions is : ", (Object)definitions.size());
            }
            Definition definition = (Definition)definitions.get(0);
            List<BpmProcessPartner> partnerList = BpmProcessPartnerHandler.createProcessPartners(session, uow, bpmProcess, bpelProcess.getPartnerLinks(), this.m_cube_process.getInitiationInfos(), definition);
            AnalyticsLogger.debug(CLASSNAME, "deploy", (Object)"insert into bpm_activity ", (Object)this.m_cube_process.getProcessDN().toString(), (Object)", id ", (Object)bpmProcess.getId());
            this.createActivities(session, uow, bpmProcess, bpelProcess, partnerList);
            if (requiresCommit) {
                uow.commit();
            }
            if (this.m_analytic_level == AnalyticLevelEnum.RUNTIME_BASIC || this.m_analytic_level == AnalyticLevelEnum.RUNTIME_CUSTOM || this.m_analytic_level == AnalyticLevelEnum.RUNTIME_INTERMEDIATE || this.m_analytic_level == AnalyticLevelEnum.RUNTIME_ALL) {
                AnalyticsLogger.debug(CLASSNAME, "deploy", (Object)"Analytic Level ", (Object)this.m_analytic_level.toString());
                dataStore.releaseUnitOfWork(uow);
                dataStore.releaseSession(session);
                session = dataStore.createSession();
                uow = session.getActiveUnitOfWork();
                if (uow == null) {
                    uow = session.acquireUnitOfWork();
                    requiresCommit = true;
                }
                BpmProcess bpmProcessShadow = this.selectProcess(session);
                bpmProcess = (BpmProcess)uow.registerExistingObject((Object)bpmProcessShadow);
                this.prepareSensorRegistry(session, uow, bpmProcess);
                uow.release();
            }
            dataStore.releaseUnitOfWork(uow);
            dataStore.releaseSession(session);
        }
        catch (Throwable t) {
            try {
                t.printStackTrace();
                dataStore.releaseUnitOfWork(uow);
                dataStore.releaseSession(session);
            }
            catch (Throwable throwable) {
                dataStore.releaseUnitOfWork(uow);
                dataStore.releaseSession(session);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy() throws Exception {
        String methodName = "undeploy";
        BpmDataStore dataStore = new BpmDataStore();
        Session session = null;
        UnitOfWork uow = null;
        boolean requiresCommit = false;
        AnalyticsLogger.debug(CLASSNAME, "undeploy", (Object)"process ", (Object)this.m_component_model.getName());
        try {
            BpmProcess bpmProcess;
            session = dataStore.createSession();
            uow = session.getActiveUnitOfWork();
            if (uow == null) {
                uow = session.acquireUnitOfWork();
                requiresCommit = true;
            }
            if ((bpmProcess = this.selectProcess(session)) != null) {
                BpmProcess bpmProcessClone = (BpmProcess)uow.registerExistingObject((Object)bpmProcess);
                bpmProcessClone.setUndeployDate(new Timestamp(System.currentTimeMillis()));
                bpmProcessClone.setStatus(-1);
            }
            if (requiresCommit) {
                uow.commit();
            }
            dataStore.releaseUnitOfWork(uow);
            dataStore.releaseSession(session);
        }
        catch (Throwable throwable) {
            dataStore.releaseUnitOfWork(uow);
            dataStore.releaseSession(session);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stale() throws Exception {
        String methodName = "stale";
        BpmDataStore dataStore = new BpmDataStore();
        Session session = null;
        UnitOfWork uow = null;
        boolean requiresCommit = false;
        AnalyticsLogger.debug(CLASSNAME, "stale", (Object)"process ", (Object)this.m_component_model.getName());
        try {
            BpmProcess bpmProcess;
            session = dataStore.createSession();
            uow = session.getActiveUnitOfWork();
            if (uow == null) {
                uow = session.acquireUnitOfWork();
                requiresCommit = true;
            }
            if ((bpmProcess = this.selectProcess(session)) != null) {
                BpmProcess bpmProcessClone = (BpmProcess)uow.registerExistingObject((Object)bpmProcess);
                bpmProcessClone.setStatus(0);
            }
            if (requiresCommit) {
                uow.commit();
            }
            dataStore.releaseUnitOfWork(uow);
            dataStore.releaseSession(session);
        }
        catch (Throwable throwable) {
            dataStore.releaseUnitOfWork(uow);
            dataStore.releaseSession(session);
            throw throwable;
        }
    }

    private BpmProcess selectProcess(Session session) {
        String methodName = "selectProcess";
        ReadObjectQuery instanceQuery = new ReadObjectQuery();
        BpmProcess sampleProcess = new BpmProcess();
        CompositeModel compositeModel = this.m_component_model.getComposite();
        AnalyticsLogger.debug(CLASSNAME, "selectProcess", (Object)"component ", (Object)this.m_component_model.getName());
        sampleProcess.setApplicationName(this.m_component_model.getApplicationName());
        sampleProcess.setCompositeName(compositeModel.getName());
        sampleProcess.setRevision(compositeModel.getRevision());
        sampleProcess.setCompositeLabel(compositeModel.getLabel());
        sampleProcess.setName(this.m_component_model.getName());
        sampleProcess.setProcessType("BPEL");
        instanceQuery.setReferenceClass(BpmProcess.class);
        instanceQuery.setExampleObject((Object)sampleProcess);
        BpmProcess result = (BpmProcess)session.executeQuery((DatabaseQuery)instanceQuery);
        if (result != null) {
            AnalyticsLogger.debug(CLASSNAME, "selectProcess", (Object)"found ", (Object)result.getName());
            return (BpmProcess)session.refreshObject((Object)result);
        }
        AnalyticsLogger.debug(CLASSNAME, "selectProcess", (Object)this.m_component_model.getName(), (Object)" not found");
        return null;
    }

    private BpmProcess upsertProcess(Session session, UnitOfWork uow, TProcess bpelProcess, long sourceTimestamp) throws Exception {
        CompositeModel compositeModel = this.m_component_model.getComposite();
        BpmProcess result = (BpmProcess)uow.registerObject((Object)new BpmProcess());
        result.setCompositeDN(compositeModel.getDN());
        result.setApplicationName(this.m_component_model.getApplicationName());
        result.setCompositeName(compositeModel.getName());
        result.setRevision(compositeModel.getRevision());
        result.setCompositeLabel(compositeModel.getLabel());
        result.setProcessType("BPEL");
        result.setStatus(1);
        result.setName(bpelProcess.getName());
        result.setNamespace(bpelProcess.getTargetNamespace());
        result.setCreationDate(new Timestamp(sourceTimestamp));
        return result;
    }

    private void createActivities(Session session, UnitOfWork uow, BpmProcess bpmProcess, TProcess bpelProcess, List<BpmProcessPartner> partnerList) throws Exception {
        String methodName = "createActivities";
        XmlCursor processCursor = bpelProcess.newCursor();
        long nodeSeqNumber = 1L;
        long nodeBranchNumber = 1L;
        boolean hasNext = processCursor.toFirstChild();
        while (hasNext) {
            processCursor.push();
            XmlObject xobj = processCursor.getObject();
            String nodeBranch = null;
            AnalyticsLogger.debug(CLASSNAME, "createActivities", (Object)"createNode ", (Object)xobj.getClass().getName(), (Object)", seq# ", (Object)nodeSeqNumber, (Object)", branch# ", (Object)nodeBranchNumber);
            BpmActivity targetActivity = BpmActivityHandler.createActivityNode(session, uow, bpmProcess, partnerList, null, xobj, 1, nodeSeqNumber++, null, nodeBranchNumber++);
            if (targetActivity != null) {
                bpmProcess.addToBpmActivityCollection(targetActivity);
                nodeBranch = targetActivity.getNodeBranch() + ".";
            } else {
                --nodeSeqNumber;
                --nodeBranchNumber;
            }
            AnalyticsLogger.debug(CLASSNAME, "createActivities", (Object)"createSubNode ", (Object)xobj.getClass().getName(), (Object)", nodebranch ", (Object)nodeBranch);
            NodeSeqInfo nodeSeqInfo = this.createSubNodes(session, uow, bpmProcess, partnerList, targetActivity, xobj.newCursor(), 2, nodeSeqNumber++, nodeBranch, 1L);
            nodeSeqNumber = nodeSeqInfo.getSeq();
            nodeBranchNumber = nodeSeqInfo.getBranch();
            processCursor.pop();
            hasNext = processCursor.toNextSibling();
        }
        processCursor.dispose();
    }

    private NodeSeqInfo createSubNodes(Session session, UnitOfWork uow, BpmProcess bpmProcess, List<BpmProcessPartner> partnerList, BpmActivity bpmActivity, XmlCursor cursor, int level, long seqNumber, String branchPrefix, long branchNumber) {
        long localBranchNumber = 1L;
        if (cursor == null) {
            return new NodeSeqInfo(seqNumber, branchNumber);
        }
        boolean hasNext = cursor.toFirstChild();
        while (hasNext) {
            cursor.push();
            XmlObject cobj = cursor.getObject();
            String nodeBranch = null;
            BpmActivity targetActivity = BpmActivityHandler.createActivityNode(session, uow, bpmProcess, partnerList, bpmActivity, cobj, level, seqNumber++, branchPrefix, localBranchNumber++);
            if (targetActivity != null) {
                bpmProcess.addToBpmActivityCollection(targetActivity);
                if (targetActivity.getNodeBranch().contains(".")) {
                    nodeBranch = targetActivity.getNodeBranch() + ".";
                }
            } else {
                --seqNumber;
                --localBranchNumber;
            }
            NodeSeqInfo result = this.createSubNodes(session, uow, bpmProcess, partnerList, targetActivity, cobj.newCursor(), level + 1, seqNumber, nodeBranch, branchNumber);
            seqNumber = result.getSeq();
            branchNumber = result.getBranch();
            cursor.pop();
            hasNext = cursor.toNextSibling();
        }
        return new NodeSeqInfo(seqNumber, seqNumber == 1L ? 1L : seqNumber - branchNumber);
    }

    private void prepareSensorRegistry(Session session, UnitOfWork uow, BpmProcess bpmProcess) throws Exception {
        String methodName = "prepareSensorRegistry";
        ISensorRegistry sensorRegistry = this.m_cube_process.getSensorRegistry();
        Collection sensorCollection = sensorRegistry.getAllSensors();
        Collection sensorActionCollection = sensorRegistry.getAllSensorActions();
        AnalyticsLogger.debug(CLASSNAME, "prepareSensorRegistry", (Object)this.m_cube_process.getProcessDN().toString(), (Object)(" #sensors " + sensorCollection.size()), (Object)(", #sensor actions: " + sensorActionCollection.size()));
        AnalyticSensorActionInfo analyticSensorAction = this.createSensorAction();
        Map<String, AnalyticSensorInfo> analyticSensorMap = this.createSensorMap(session, uow, bpmProcess);
        AnalyticsLogger.debug(CLASSNAME, "prepareSensorRegistry", (Object)this.m_cube_process.getProcessDN().toString(), (Object)(" # analytic sensors " + analyticSensorMap.size()));
        sensorRegistry.addSensorAction((ISensorActionInfo)analyticSensorAction);
        for (Map.Entry<String, AnalyticSensorInfo> analyticSensor : analyticSensorMap.entrySet()) {
            analyticSensorAction.getFacade().addSensorName(analyticSensor.getKey());
            AnalyticsLogger.debug(CLASSNAME, "prepareSensorRegistry", (Object)"Add sensor ", (Object)analyticSensor.getKey(), (Object)" to action ", (Object)analyticSensorAction.getName());
            sensorRegistry.addSensor((ISensorInfo)analyticSensor.getValue());
            sensorRegistry.associate((ISensorInfo)analyticSensor.getValue(), (ISensorActionInfo)analyticSensorAction);
        }
    }

    private void purgeSensorRegistry(BpmProcess bpmProcess) throws Exception {
        String methodName = "purgeSensorRegistry";
        ISensorRegistry sensorRegistry = this.m_cube_process.getSensorRegistry();
        String sensorActionNamePrefix = this.m_component_model.getApplicationName() + "/" + this.m_component_model.getCompositeName() + "!" + this.m_component_model.getComposite().getRevision();
        ISensorActionInfo oldSensorAction = null;
        Collection sensorActionColl = sensorRegistry.getAllSensorActions();
        AnalyticsLogger.debug(CLASSNAME, "purgeSensorRegistry", (Object)"action prefix ", (Object)sensorActionNamePrefix, (Object)", component ", (Object)this.m_component_model.getName(), (Object)", #actions ", (Object)sensorActionColl.size());
        for (ISensorActionInfo sensorAction : sensorActionColl) {
            String sensorActionName = sensorAction.getName();
            AnalyticsLogger.debug(CLASSNAME, "purgeSensorRegistry", (Object)"check sensor action ", (Object)sensorActionName);
            if (!(sensorAction instanceof AnalyticSensorActionInfo) || !sensorActionName.startsWith(sensorActionNamePrefix) || !sensorActionName.contains(this.m_component_model.getName())) continue;
            AnalyticsLogger.debug(CLASSNAME, "purgeSensorRegistry", (Object)"found ", (Object)sensorAction.getName());
            oldSensorAction = sensorAction;
            break;
        }
        if (oldSensorAction != null) {
            sensorActionColl.remove(oldSensorAction);
            Collection sensorColl = sensorRegistry.getSensors(oldSensorAction);
            AnalyticsLogger.debug(CLASSNAME, "purgeSensorRegistry", (Object)", action ", (Object)oldSensorAction.getName(), (Object)"# sensors ", (Object)sensorColl.size());
            sensorColl.clear();
        }
    }

    private AnalyticSensorActionInfo createSensorAction() throws Exception {
        TSensorAction result = TSensorActionFactory.createFacade();
        result.setEnabled(true);
        result.setName(this.m_cube_process.getProcessDN() + "_Analytic_Action");
        result.setPublishType("Analytic");
        return new AnalyticSensorActionInfo(this.m_component_model, result);
    }

    private Map<String, AnalyticSensorInfo> createSensorMap(Session session, UnitOfWork uow, BpmProcess bpmProcess) throws Exception {
        String methodName = "createSensorMap";
        HashMap<String, AnalyticSensorInfo> result = new HashMap<String, AnalyticSensorInfo>();
        Collection bpmActivityCollection = bpmProcess.getBpmActivityCollection();
        AnalyticsLogger.debug(CLASSNAME, "createSensorMap", (Object)"# activities ", (Object)bpmActivityCollection.size(), (Object)" analytic level ", (Object)this.m_analytic_level.toString());
        for (BpmActivity bpmActivityShadow : bpmActivityCollection) {
            AnalyticSensorInfo sensorInfo;
            BpmActivity bpmActivity = (BpmActivity)uow.registerExistingObject((Object)bpmActivityShadow);
            if (bpmActivity.getNodeSequenceNumber() == 1L) {
                sensorInfo = this.createSensorInfoFromActivity(bpmProcess, bpmActivity);
                result.put(sensorInfo.getName(), sensorInfo);
            }
            if (this.m_analytic_level == AnalyticLevelEnum.RUNTIME_INTERMEDIATE || this.m_analytic_level == AnalyticLevelEnum.RUNTIME_ALL) {
                String activityType = bpmActivity.getType();
                if ((activityType.equals(BpelActivityEnum.SCOPE.getName()) || activityType.equals(BpelActivityEnum.DECIDE.getName()) || activityType.equals(BpelActivityEnum.WORKFLOW.getName())) && (sensorInfo = this.createSensorInfoFromActivity(bpmProcess, bpmActivity)) != null) {
                    AnalyticsLogger.debug(CLASSNAME, "createSensorMap", (Object)"Level ", (Object)this.m_analytic_level.toString(), (Object)", create sensor for ", (Object)bpmActivity.getType(), (Object)", name ", (Object)bpmActivity.getName(), (Object)", nodeId ", (Object)bpmActivity.getNodeId());
                    result.put(sensorInfo.getName(), sensorInfo);
                }
                if (this.m_analytic_level != AnalyticLevelEnum.RUNTIME_ALL || !activityType.equals(BpelActivityEnum.WHILE.getName()) && !activityType.equals(BpelActivityEnum.SWITCH.getName()) && !activityType.equals(BpelActivityEnum.INVOKE.getName()) || (sensorInfo = this.createSensorInfoFromActivity(bpmProcess, bpmActivity)) == null) continue;
                AnalyticsLogger.debug(CLASSNAME, "createSensorMap", (Object)"Level ", (Object)this.m_analytic_level.toString(), (Object)", create sensor for ", (Object)bpmActivity.getType(), (Object)", name ", (Object)bpmActivity.getName(), (Object)", nodeId ", (Object)bpmActivity.getNodeId());
                result.put(sensorInfo.getName(), sensorInfo);
                continue;
            }
            if (this.m_analytic_level != AnalyticLevelEnum.RUNTIME_CUSTOM) continue;
            Collection propColl = bpmActivity.getBpmActivityPropertyCollection();
            if (!propColl.isEmpty()) {
                for (BpmActivityProperty prop : propColl) {
                    if (!prop.getName().equals("label") || (sensorInfo = this.createSensorInfoFromActivity(bpmProcess, bpmActivity)) == null) continue;
                    AnalyticsLogger.debug(CLASSNAME, "createSensorMap", (Object)"Level ", (Object)this.m_analytic_level.toString(), (Object)", create sensor for ", (Object)bpmActivity.getType(), (Object)", name ", (Object)bpmActivity.getName(), (Object)", nodeId ", (Object)bpmActivity.getNodeId());
                    result.put(sensorInfo.getName(), sensorInfo);
                }
                continue;
            }
            AnalyticsLogger.debug(CLASSNAME, "createSensorMap", (Object)"No properties for ", (Object)bpmActivity.getType(), (Object)", name ", (Object)bpmActivity.getName(), (Object)", nodeId ", (Object)bpmActivity.getNodeId());
        }
        return result;
    }

    private AnalyticSensorInfo createSensorInfoFromActivity(BpmProcess bpmProcess, BpmActivity bpmActivity) throws Exception {
        if (bpmActivity.getName() == null) {
            return null;
        }
        TSensor sensor = TSensorFactory.createFacade();
        TActivityConfig activityConfig = TActivityConfigFactory.createFacade();
        sensor.setSensorName(this.m_cube_process.getProcessDN().toString() + "_" + bpmActivity.getNodeBranch());
        sensor.setKind("activity");
        sensor.setTarget(bpmActivity.getName());
        activityConfig.setEvalTime("all");
        sensor.setActivityConfig((ITActivityConfig)activityConfig);
        return new AnalyticSensorInfo(this.m_component_model, sensor, bpmProcess.getId(), bpmActivity.getId(), bpmActivity.getNodeId());
    }

    public static void main(String[] arg) {
        try {
            File bpelFile = new File("D:\\jdevinstance\\system11.1.1.0.22.49.11\\o.j2ee\\embedded-oc4j\\deployed-composites\\TopLevelComposite_rev1.0\\sca_TopLevelComposite_rev1.0\\SCA-INF\\bpel\\TopLevelProcess\\model\\TopLevelProcessModel.xml");
            ProcessDocument bpelProcessDoc = ProcessDocument.Factory.parse((File)bpelFile);
            TProcess bpelProcess = bpelProcessDoc.getProcess();
            TSequence outerSeq = bpelProcess.getSequence();
            TPartnerLinks partnerLinks = bpelProcess.getPartnerLinks();
            XmlCursor cursor = bpelProcess.newCursor();
            System.out.println("Outer seq: " + outerSeq.getName());
            System.out.println();
            for (TPartnerLink pl : partnerLinks.getPartnerLinkList()) {
                System.out.println("PL Type " + pl.getPartnerLinkType());
                System.out.println("PL name " + pl.getName());
            }
            BPELProcessAnalysisDeployer.printObj((XmlObject)bpelProcess, bpelProcess.newCursor(), 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printObj(XmlObject obj, XmlCursor cursor, int level) {
        if (cursor == null) {
            return;
        }
        boolean hasNext = cursor.toFirstChild();
        while (hasNext) {
            cursor.push();
            XmlObject cobj = cursor.getObject();
            for (int i = 0; i < level; ++i) {
                System.out.print(" ");
            }
            System.out.println("Class " + cobj.getClass().getName());
            System.out.println("Node Id: " + BpmActivityHandler.getNodeId(cobj));
            BPELProcessAnalysisDeployer.printObj(cobj, cobj.newCursor(), level + 2);
            cursor.pop();
            hasNext = cursor.toNextSibling();
        }
    }

    private class NodeSeqInfo {
        long m_seq;
        long m_branch;

        public NodeSeqInfo(long seq, long branch) {
            this.m_seq = seq;
            this.m_branch = branch;
        }

        public long getSeq() {
            return this.m_seq;
        }

        public long getBranch() {
            return this.m_branch;
        }
    }
}

