/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.bpel.datastore;

import oracle.bpm.analytics.AnalyticsLogger;
import oracle.integration.platform.blocks.FabricConfigManager;
import oracle.integration.platform.blocks.JRFServerInfoProvider;
import oracle.integration.platform.blocks.ServerInfo;
import oracle.integration.platform.instance.store.ToplinkSessionLogger;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.ServerPlatformSupport;
import oracle.jrf.ServerPlatformSupportFactory;
import oracle.soa.common.util.DatabaseInfo;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.helper.ConversionManager;
import oracle.toplink.sequencing.TableSequence;
import oracle.toplink.sessions.DatabaseLogin;
import oracle.toplink.sessions.Session;
import oracle.toplink.sessions.UnitOfWork;
import oracle.toplink.threetier.Server;
import oracle.toplink.tools.sessionconfiguration.XMLSessionConfigLoader;
import oracle.toplink.tools.sessionmanagement.SessionManager;

public class BpmDataStore {
    private static final String CLASS_NAME = "BpmDataStore";
    private static final String SESSION_PREFIX = "bpmanalysis_session_";
    private static final String SESSION_FILE = "oracle/bpm/analytics/bpel/datastore/bpmprocessanalysis-session.xml";
    private Server m_server = null;

    public BpmDataStore() {
        this.initServer();
    }

    public Session createSession() {
        this.connect();
        return this.m_server.acquireClientSession();
    }

    public void releaseSession(Session session) {
        if (session != null) {
            try {
                session.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void releaseUnitOfWork(UnitOfWork uow) {
        if (uow != null) {
            try {
                uow.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void close() {
        try {
            if (this.m_server != null) {
                this.m_server.release();
            }
            this.m_server = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void initServer() {
        String methodName = "initServer";
        String sessionName = "bpmanalysis_session_oracle";
        if (this.m_server == null) {
            try {
                ServerPlatformSupport platform = ServerPlatformSupportFactory.getInstance();
                FabricConfigManager fabricConfig = new FabricConfigManager(null, (ServerInfo)new JRFServerInfoProvider());
                DatabaseInfo dbInfo = fabricConfig.getDatabaseInfo();
                if (dbInfo.getDatabaseType().equals(DatabaseInfo.DB_TYPE_ORACLE)) {
                    sessionName = "bpmanalysis_session_oracle";
                } else if (dbInfo.getDatabaseType().equals(DatabaseInfo.DB_TYPE_SQLSERVER)) {
                    sessionName = "bpmanalysis_session_sqlserver";
                }
                if (dbInfo.getDatabaseType().equals(DatabaseInfo.DB_TYPE_DB2)) {
                    sessionName = "bpmanalysis_session_db2";
                } else {
                    AnalyticsLogger.debug(CLASS_NAME, methodName, (Object)"Unsupported DB type  ", (Object)dbInfo.getDatabaseType());
                }
                if (platform.isWebSphere() || platform.isWebSphereAS() || platform.isWebSphereND()) {
                    sessionName = sessionName + "_was";
                } else if (platform.isJBoss()) {
                    sessionName = sessionName + "_jboss";
                } else {
                    AnalyticsLogger.debug(CLASS_NAME, methodName, (Object)"Server platform ", (Object)platform.getPlatformName());
                }
            }
            catch (PortabilityLayerException ple) {
                ple.printStackTrace();
            }
            AnalyticsLogger.debug(CLASS_NAME, methodName, (Object)"Create new Toplink session ", (Object)sessionName);
            ConversionManager.getDefaultManager().setShouldUseClassLoaderFromCurrentThread(true);
            SessionManager manager = SessionManager.getManager();
            this.m_server = (Server)manager.getSession(new XMLSessionConfigLoader(SESSION_FILE), sessionName, Thread.currentThread().getContextClassLoader(), false, true, false);
            this.m_server.setSessionLog(ToplinkSessionLogger.getSessionLog((Session)this.m_server));
            DatabaseLogin dbLogin = this.m_server.getLogin();
            ((TableSequence)dbLogin.getDefaultSequence()).setTableName("BPM_CUBE_SEQUENCE");
            ((TableSequence)dbLogin.getDefaultSequence()).setNameFieldName("SEQ_NAME");
            ((TableSequence)dbLogin.getDefaultSequence()).setCounterFieldName("SEQ_COUNT");
            dbLogin.setUserName(null);
            dbLogin.setPassword(null);
            dbLogin.dontUseExternalTransactionController();
            dbLogin.useByteArrayBinding();
        }
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        if (!this.m_server.isConnected()) {
            BpmDataStore bpmDataStore = this;
            synchronized (bpmDataStore) {
                block6: {
                    try {
                        this.m_server.login();
                    }
                    catch (ValidationException ve) {
                        int errorCode = ve.getErrorCode();
                        if (errorCode == 7128) break block6;
                        throw ve;
                    }
                }
            }
        }
    }
}

