/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.wizards;

import java.io.File;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.wizards.NewProjectWizard;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.ui.wizards.ImportWizardUserObject;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardTask;

public class NewProjectTask
extends WizardTask {
    private Project newProject;
    private String projectDir;

    public NewProjectTask(NewProjectWizard wizard) {
        super((Wizard)wizard);
    }

    public String getDescription() {
        return DesignerMsg.CREATING_ALL_DIRECTORIES.getString();
    }

    public Project getNewProject() {
        return this.newProject;
    }

    public String getProjectFileLocation() {
        return this.projectDir;
    }

    public boolean execute() {
        ImportWizardUserObject importWizardUserObject = (ImportWizardUserObject)this.getWizard().getUserObject();
        String projectName = importWizardUserObject.getProjectName();
        String baseDir = importWizardUserObject.getProjectRootDirectory();
        this.projectDir = baseDir + File.separator + projectName;
        File baseDirFile = new File(baseDir);
        this.ensureExists(baseDirFile);
        try {
            ProjectRepository repository = RepositoryService.getInstance().getActiveRepository();
            this.newProject = repository.create(baseDirFile.toURI(), projectName);
            return true;
        }
        catch (ProjectException e) {
            UiUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    MessageDialog.showError((Throwable)e);
                }
            });
            return false;
        }
    }

    private void ensureExists(File dir) {
        dir.mkdirs();
    }
}

