/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.variables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bpm.designer.types.TypeItem;
import oracle.bpm.designer.types.TypeItemFactory;
import oracle.bpm.project.model.catalog.CatalogType;

public enum TypeCategory {
    NUMBER{

        @Override
        void addCompatibleTypes() {
            this.compatibleTypes.add(CatalogType.Default.getInt());
            this.compatibleTypes.add(CatalogType.Default.getDecimal());
            this.compatibleTypes.add(CatalogType.Default.getReal());
        }
    }
    ,
    VARCHAR{

        @Override
        void addCompatibleTypes() {
            this.compatibleTypes.add(CatalogType.Default.getString());
            this.compatibleTypes.add(CatalogType.Default.getBool());
        }
    }
    ,
    TIMESTAMP{

        @Override
        void addCompatibleTypes() {
            this.compatibleTypes.add(CatalogType.Default.getTime());
        }
    }
    ,
    UNKNOWN{

        @Override
        void addCompatibleTypes() {
        }
    };

    protected List<CatalogType> compatibleTypes = new ArrayList<CatalogType>();

    abstract void addCompatibleTypes();

    private TypeCategory() {
        this.addCompatibleTypes();
    }

    public static List<TypeItem> findCompatibleTypes(CatalogType type) {
        for (TypeCategory typeCategory : TypeCategory.values()) {
            if (TypeCategory.valueOf(type) != typeCategory) continue;
            return TypeCategory.buildTypeList(typeCategory);
        }
        return Collections.emptyList();
    }

    private static List<TypeItem> buildTypeList(TypeCategory typeCategory) {
        ArrayList<TypeItem> typeList = new ArrayList<TypeItem>();
        for (CatalogType catalogType : typeCategory.getCompatibleTypes()) {
            TypeItem typeItem = TypeItemFactory.createTypeItem(catalogType);
            typeList.add(typeItem);
        }
        return typeList;
    }

    private List<CatalogType> getCompatibleTypes() {
        return this.compatibleTypes;
    }

    public static TypeCategory valueOf(CatalogType type) {
        for (TypeCategory category : TypeCategory.values()) {
            if (!category.getCompatibleTypes().contains(type)) continue;
            return category;
        }
        return UNKNOWN;
    }
}

