/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.variables;

import java.nio.charset.Charset;
import oracle.bpm.designer.ProjectObjectEditorPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.types.CILTypeComboBox;
import oracle.bpm.designer.types.TypeItem;
import oracle.bpm.designer.types.TypeItemFactory;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.lang.Str;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.FormLayout;

public class MeasureBusinessIndicatorPanel
extends ProjectObjectEditorPanel<ProjectDataObject> {
    private IdentifierTextField idTextField;
    private CheckBox initializeCheckBox;
    private boolean isEdition;
    private String oldId;
    private CILTypeComboBox typeCombo;

    public MeasureBusinessIndicatorPanel(UiContainer parent, ProjectDataObject dataObject) {
        super(parent, dataObject);
        NodeContainer nodeContainer = (NodeContainer)dataObject.getParentObject();
        this.isEdition = nodeContainer.findLocalDeclaration(dataObject.getId()) != null;
        this.oldId = dataObject.getId();
        this.init();
    }

    @Override
    public void objectToEditor(ProjectDataObject dataObject) {
        this.idTextField.setText(dataObject.getId());
        CatalogType type = dataObject.getType();
        this.typeCombo.setSelectedItem(type);
        this.initializeCheckBox.setSelected(dataObject.isInitialize());
        this.initializeCheckBox.setEnabled(true);
    }

    @Override
    public ProjectDataObject editorToObject() throws ProjectException {
        ProjectDataObject dataObject = (ProjectDataObject)this.getProjectObject();
        CatalogType type = this.getTypeDescription();
        dataObject.setId(this.idTextField.getText().trim());
        dataObject.setInitialize(this.initializeCheckBox.isSelected());
        dataObject.setTypeDescription(type);
        return dataObject;
    }

    @Override
    public void validateEditor() throws ProjectException {
        NodeContainer nodeContainer;
        ProjectDataObject dataObject = (ProjectDataObject)this.getProjectObject();
        String id = this.idTextField.getText().trim();
        if (Str.isEmpty(id)) {
            throw new ProjectException((ProjectObject)dataObject, DesignerMsg.DECLARATION_NAME_IS_NULL(DesignerMsg.BUSINESS_INDICATOR.getString()));
        }
        if (id.getBytes(Charset.forName("UTF-8")).length > 28) {
            throw new ProjectException((ProjectObject)dataObject, DesignerMsg.ATTRIBUTE_VALUE_HAS_EXCEEDED_LIMIT(DesignerMsg.NAME.toString()));
        }
        if (!(this.isEdition && id.equals(this.oldId) || (nodeContainer = (NodeContainer)dataObject.getParentObject()).findLocalDeclaration(id) == null)) {
            throw new ProjectException((ProjectObject)dataObject, ProjectMsg.BUSINESS_INDICATOR_ALREADY_EXISTS((String)id));
        }
    }

    private void init() {
        this.idTextField = new IdentifierTextField((UiContainer)this, 30, true);
        this.idTextField.setTextLimit(28);
        this.typeCombo = new CILTypeComboBox((UiContainer)this){

            @Override
            protected void addTypes() {
                this.addItems(TypeItemFactory.createBusinessIndicatorProjectVariableValidTypes());
            }
        };
        this.typeCombo.setSelectedIndex(0);
        this.typeCombo.setEnabled(this.typeCombo.getItemCount() > 1);
        this.initializeCheckBox = CheckBox.create((UiContainer)this, (Msg)DesignerMsg.AUTO_INITIALIZE);
        FormLayout layout = this.createStandardLayout();
        this.setLayout((Layout)layout);
        this.appendRow(layout, (UiComponent)Label.create((UiContainer)this, (Msg)ProjectDrawMsg.NAME), (UiComponent)this.idTextField);
        this.appendRow(layout, (UiComponent)Label.create((UiContainer)this, (Msg)CoreMsg.TYPE), (UiComponent)this.typeCombo);
        layout.appendRow("pref");
        this.appendRow(layout, (UiComponent)this.initializeCheckBox);
        if (!this.isEdition) {
            this.idTextField.requestFocus();
            this.idTextField.selectAll();
        } else {
            this.typeCombo.requestFocus();
        }
    }

    private CatalogType getTypeDescription() {
        return ((TypeItem)this.typeCombo.getSelectedItem()).getRef();
    }
}

