/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.variables;

import java.nio.charset.Charset;
import java.util.List;
import oracle.bpm.data.BusinessVariableData;
import oracle.bpm.designer.ProjectObjectEditorPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.types.CILTypeComboBox;
import oracle.bpm.designer.types.TypeItem;
import oracle.bpm.designer.types.TypeItemFactory;
import oracle.bpm.designer.types.TypeItemId;
import oracle.bpm.designer.variables.DataPanel;
import oracle.bpm.designer.variables.TypeCategory;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.lang.Str;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.FormLayout;

public class DimensionBusinessIndicatorPanel
extends ProjectObjectEditorPanel<ProjectDataObject> {
    private TypeItem currentSelection;
    private DataPanel dataPanel;
    private IdentifierTextField idTextField;
    private CheckBox initializeCheckBox;
    private boolean isEdition;
    private String oldId;
    private CILTypeComboBox typeCombo;

    public DimensionBusinessIndicatorPanel(UiContainer parent, ProjectDataObject dataObject) {
        super(parent, dataObject);
        NodeContainer nodeContainer = (NodeContainer)dataObject.getParentObject();
        this.isEdition = nodeContainer.findLocalDeclaration(dataObject.getId()) != null;
        this.oldId = dataObject.getId();
        this.init();
    }

    @Override
    public void objectToEditor(ProjectDataObject dataObject) {
        this.idTextField.setText(dataObject.getId());
        CatalogType type = dataObject.getType();
        this.typeCombo.setSelectedItem(type);
        this.initializeCheckBox.setSelected(dataObject.isInitialize());
        this.dataPanel.setBusinessVariableData(dataObject.getBusinessVariableData());
        this.dataPanel.setInt(type.isInt());
        this.dataPanel.setEnabled(type.isNumber());
    }

    @Override
    public ProjectDataObject editorToObject() throws ProjectException {
        ProjectDataObject dataObject = (ProjectDataObject)this.getProjectObject();
        CatalogType type = this.getTypeDescription();
        BusinessVariableData data = this.getBusinessVariableData();
        dataObject.setId(this.idTextField.getText().trim());
        dataObject.setInitialize(this.initializeCheckBox.isSelected());
        dataObject.setTypeDescription(type);
        dataObject.setBusinessVariableData(data);
        return dataObject;
    }

    @Override
    public void validateEditor() throws ProjectException {
        NodeContainer nodeContainer;
        ProjectDataObject dataObject = (ProjectDataObject)this.getProjectObject();
        String id = this.idTextField.getText().trim();
        if (Str.isEmpty(id)) {
            throw new ProjectException((ProjectObject)dataObject, DesignerMsg.DECLARATION_NAME_IS_NULL(DesignerMsg.BUSINESS_INDICATOR.getString()));
        }
        if (id.getBytes(Charset.forName("UTF-8")).length > 28) {
            throw new ProjectException((ProjectObject)dataObject, DesignerMsg.ATTRIBUTE_VALUE_HAS_EXCEEDED_LIMIT(DesignerMsg.NAME.toString()));
        }
        if (!(this.isEdition && id.equals(this.oldId) || (nodeContainer = (NodeContainer)dataObject.getParentObject()).findLocalDeclaration(id) == null)) {
            throw new ProjectException((ProjectObject)dataObject, ProjectMsg.BUSINESS_INDICATOR_ALREADY_EXISTS((String)id));
        }
        if (this.dataPanel.isEnabled()) {
            this.dataPanel.validatePanel((DataObject)dataObject, id);
        }
    }

    private void init() {
        this.idTextField = new IdentifierTextField((UiContainer)this, 30, true);
        this.idTextField.setTextLimit(28);
        final List<TypeItem> validTypes = this.isEdition ? TypeCategory.findCompatibleTypes(((ProjectDataObject)this.getProjectObject()).getType()) : TypeItemFactory.createProjectVariableValidTypes();
        this.typeCombo = new CILTypeComboBox((UiContainer)this){

            @Override
            protected void addTypes() {
                this.addItems(validTypes);
            }
        };
        this.currentSelection = validTypes.isEmpty() ? null : validTypes.get(0);
        this.typeCombo.setSelectedItem(this.currentSelection.getRef());
        this.typeCombo.setEnabled(this.typeCombo.getItemCount() > 1);
        this.typeCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                TypeItemId currentSelectionId;
                TypeItem item;
                TypeItemId itemId;
                if (e.isStateSelected() && !(itemId = (item = (TypeItem)e.getItem()).getId()).equals((Object)(currentSelectionId = DimensionBusinessIndicatorPanel.this.currentSelection.getId()))) {
                    if (DimensionBusinessIndicatorPanel.this.hasRangesDefined()) {
                        int rc = MessageDialog.showQuestion((UiContainer)DimensionBusinessIndicatorPanel.this.typeCombo.getOwnerWindow(), (Msg)DesignerMsg.RANGES, (Msg)DesignerMsg.WARNING_RANGES_CLEAR, null, (int)6, null);
                        if (rc == 2) {
                            DimensionBusinessIndicatorPanel.this.currentSelection = item;
                            DimensionBusinessIndicatorPanel.this.clearDataPanel();
                            DimensionBusinessIndicatorPanel.this.updateDataPanelState(item.getRef());
                        } else {
                            DimensionBusinessIndicatorPanel.this.typeCombo.setSelectedItem(DimensionBusinessIndicatorPanel.this.currentSelection.getRef());
                        }
                    } else {
                        DimensionBusinessIndicatorPanel.this.currentSelection = item;
                        DimensionBusinessIndicatorPanel.this.updateDataPanelState(item.getRef());
                    }
                }
            }
        });
        this.initializeCheckBox = CheckBox.create((UiContainer)this, (Msg)DesignerMsg.AUTO_INITIALIZE);
        FormLayout layout = this.createStandardLayout();
        this.setLayout((Layout)layout);
        this.appendRow(layout, (UiComponent)Label.create((UiContainer)this, (Msg)ProjectDrawMsg.NAME), (UiComponent)this.idTextField);
        this.appendRow(layout, (UiComponent)Label.create((UiContainer)this, (Msg)CoreMsg.TYPE), (UiComponent)this.typeCombo);
        this.dataPanel = new DataPanel((UiContainer)this);
        if (!this.isEdition || this.isEdition && TypeCategory.valueOf(((ProjectDataObject)this.getProjectObject()).getType()) == TypeCategory.NUMBER) {
            this.appendExpandedRow(layout, (UiComponent)this.dataPanel);
            this.setPreferredSize(Dimension.valueOf(450, 200));
        }
        this.dataPanel.setEnabled(((ProjectDataObject)this.getProjectObject()).getBusinessVariableType().isDimension());
        layout.appendRow("pref");
        this.appendRow(layout, (UiComponent)this.initializeCheckBox);
        if (!this.isEdition) {
            this.idTextField.requestFocus();
            this.idTextField.selectAll();
        } else {
            this.typeCombo.requestFocus();
        }
    }

    private BusinessVariableData getBusinessVariableData() {
        return this.dataPanel.isEnabled() ? this.dataPanel.getBusinessVariableData() : null;
    }

    private CatalogType getTypeDescription() {
        return ((TypeItem)this.typeCombo.getSelectedItem()).getRef();
    }

    private boolean hasRangesDefined() {
        return this.dataPanel != null ? this.dataPanel.hasRangesDefined() : false;
    }

    private void clearDataPanel() {
        if (this.dataPanel != null) {
            this.dataPanel.clear();
        }
    }

    private void updateDataPanelState(CatalogType type) {
        if (this.dataPanel != null) {
            this.dataPanel.setInt(type.isInt());
            this.dataPanel.setEnabled(type.isNumber());
        }
    }
}

