/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.variables;

import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.action.NewCounterBIAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.process.action.BusinessIndicatorsActionsFactory;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.view.project.view.renderer.ProjectObjectRenderer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.TableModel;

public class BusinessIndicatorsPanel
extends Panel {
    private BusinessIndicatorsTableModel businessIndicatorsTableModel;
    private Project project;
    private ProjectListener<ProjectDataObject> projectDataObjectListener;
    private static final int NAME_COLUMN = 0;
    private static final int TYPE_COLUMN = 1;

    public BusinessIndicatorsPanel(UiContainer parent, Project project) {
        super(parent, null);
        this.project = project;
        this.buildUi();
        project.addListener(this.getProjectDataObjectListener());
    }

    public ProjectListener getProjectDataObjectListener() {
        if (this.projectDataObjectListener == null) {
            this.projectDataObjectListener = new ProjectListenerAdapter<ProjectDataObject>(ProjectDataObject.class){

                public void postObjectAdded(ProjectDataObject object, ProjectObject parent) {
                    BusinessIndicatorsPanel.this.getTableModel().addRow((Object)object);
                }

                public void postObjectRemoved(ProjectDataObject object, ProjectObject parent) {
                    BusinessIndicatorsPanel.this.getTableModel().removeRow(BusinessIndicatorsPanel.this.getTableModel().getRowIndex((Object)object));
                }
            };
        }
        return this.projectDataObjectListener;
    }

    private void buildUi() {
        this.setLayout((Layout)new BorderLayout());
        this.businessIndicatorsTableModel = new BusinessIndicatorsTableModel(this.project.getBusinessIndicators());
        BusinessIndicatorsTablePanel businessIndicatorsTablePanel = new BusinessIndicatorsTablePanel((UiContainer)this, (TableModel)this.businessIndicatorsTableModel);
        this.add((UiComponent)businessIndicatorsTablePanel, "Center");
    }

    private ProviderTableModel getTableModel() {
        return this.businessIndicatorsTableModel;
    }

    private class BusinessIndicatorsTablePanel
    extends BaseTablePanel {
        private NewCounterBIAction defaultDropDownAction;

        public BusinessIndicatorsTablePanel(UiContainer parent, TableModel tableModel) {
            super(parent, ProjectMsg.BUSINESS_INDICATORS, ProjectMsg.BUSINESS_INDICATORS, tableModel, BaseTablePanel.Style.TOOLBAR_TOP);
            this.getTable().getColumn(0).setLabelProvider((LabelProvider)new LabelProvider<DataObject>(){

                public Image getIcon(DataObject element) {
                    return ProjectObjectRenderer.Default.getIcon((ProjectObject)element);
                }

                public String getText(DataObject element) {
                    return ProjectObjectRenderer.Default.getLabel((ProjectObject)element);
                }
            });
        }

        public NewCounterBIAction getDefaultDropDownAction() {
            if (this.defaultDropDownAction == null) {
                this.defaultDropDownAction = new NewCounterBIAction();
            }
            return this.defaultDropDownAction;
        }

        protected ActionGroup createAddDropDownActionGroup() {
            return BusinessIndicatorsActionsFactory.createNewsActionGroup((NodeContainer)BusinessIndicatorsPanel.this.project.getProjectModel());
        }

        protected Msg getDefaultDropDownActionName() {
            return UIMsg.ADD_SOMETHING((String)this.getDefaultDropDownAction().getMsg().getString());
        }

        protected void addAction() {
            this.defaultDropDownAction.runWithSelection(BusinessIndicatorsPanel.this.project.getProjectModel());
        }

        protected void deleteAction() {
            int[] selectedRows = this.getTable().getSelectedRows();
            try {
                for (int selectedRow : selectedRows) {
                    ProjectDataObject projectDataObject = (ProjectDataObject)BusinessIndicatorsPanel.this.businessIndicatorsTableModel.getRow(selectedRow);
                    projectDataObject.delete();
                }
                this.updateSelection(selectedRows);
            }
            catch (ProjectException e) {
                MessageDialog.showError((Throwable)e);
            }
        }
    }

    private static class BusinessIndicatorsTableModel
    extends ProviderTableModel<ProjectDataObject> {
        public BusinessIndicatorsTableModel(Iterable<ProjectDataObject> businessIndicators) {
            super(MsgList.create(DesignerMsg.NAME, DesignerMsg.TYPE));
            this.addRows(businessIndicators);
        }

        public Object getValueAt(int row, int column) {
            ProjectDataObject businessIndicator = (ProjectDataObject)this.getRow(row);
            return column == 0 ? businessIndicator : businessIndicator.getBusinessVariableType().getString();
        }
    }
}

