/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.variables;

import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.designer.ProjectObjectEditorPanel;
import oracle.bpm.designer.variables.AttributeBusinessIndicatorPanel;
import oracle.bpm.designer.variables.CounterBusinessIndicatorPanel;
import oracle.bpm.designer.variables.DimensionBusinessIndicatorPanel;
import oracle.bpm.designer.variables.MeasureBusinessIndicatorPanel;
import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

public class BusinessIndicatorsEditorPanelFactory {
    public static ProjectObjectEditorPanel<ProjectDataObject> create(UiContainer parent, ProjectDataObject dataObject, @NotNull BusinessVariableType type) {
        if (type.isCounter()) {
            return new CounterBusinessIndicatorPanel(parent, dataObject);
        }
        if (type.isDimension()) {
            return new DimensionBusinessIndicatorPanel(parent, dataObject);
        }
        if (type.isMeasure()) {
            return new MeasureBusinessIndicatorPanel(parent, dataObject);
        }
        if (type.isAttribute()) {
            return new AttributeBusinessIndicatorPanel(parent, dataObject);
        }
        throw new ProgramException("Could not create panel for type: " + type.getString());
    }
}

