/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.variables;

import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.ProjectObjectEditorDialog;
import oracle.bpm.designer.ProjectObjectEditorPanel;
import oracle.bpm.designer.variables.BusinessIndicatorsEditorPanelFactory;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import org.jetbrains.annotations.NotNull;

public class BusinessIndicatorDialog
extends ProjectObjectEditorDialog<ProjectDataObject> {
    private boolean isEdition;
    private BusinessVariableType type;

    public BusinessIndicatorDialog(UiWindow parent, Msg title, ProjectDataObject dataObject, @NotNull BusinessVariableType type) {
        super(parent, title);
        this.type = type;
        NodeContainer nodeContainer = (NodeContainer)dataObject.getParentObject();
        this.isEdition = nodeContainer.findLocalDeclaration(dataObject.getId()) != null;
        this.init(dataObject);
    }

    @Override
    public ProjectObjectEditorPanel<ProjectDataObject> buildEditor(UiContainer parent, ProjectDataObject dataObject) {
        return BusinessIndicatorsEditorPanelFactory.create(parent, dataObject, this.type);
    }

    public String getHelpId() {
        return this.getHelpIdWithMsg();
    }

    @Override
    public void save(ProjectDataObject dataObject) throws ProjectException {
        NodeContainer nodeContainer = (NodeContainer)dataObject.getParentObject();
        if (!this.isEdition) {
            nodeContainer.addDeclaration((DataDeclaration)dataObject);
        }
        AbstractStudioWorkbench.storeProjectObjectIfNecessary((ProjectObject)dataObject.getProject().getProjectModel());
    }
}

