/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.validator.organization;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.validator.AbstractProjectObjectValidator;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.organization.HolidayRule;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;

public class HolidayRuleExistenceValidator
extends AbstractProjectObjectValidator<HolidayRule> {
    public HolidayRuleExistenceValidator(Project project) {
        super(project);
    }

    @Override
    public Msg validate(HolidayRule holidayRule) {
        if (Str.isEmpty(holidayRule.getName())) {
            return DesignerMsg.OBJECT_NAME_CANNOT_BE_EMPTY;
        }
        if (this.getProject().getOrganization().findHolidayRule(holidayRule.getId()) != null) {
            return DesignerMsg.OBJECT_ALREADY_EXISTS(ProjectMsg.HOLIDAY_RULE, holidayRule.getId());
        }
        Sequence holidays = this.getProject().getOrganization().getHolidayRules();
        for (HolidayRule rule : holidays) {
            if (!holidayRule.getName().equals(rule.getName())) continue;
            return DesignerMsg.OBJECT_ALREADY_EXISTS(ProjectMsg.HOLIDAY_RULE, holidayRule.getName());
        }
        return null;
    }
}

