/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.utils;

import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComposedIcon;
import oracle.bpm.ui.Image;
import org.jetbrains.annotations.NotNull;

public class IconFactory {
    private static final Map<Image, Image> readOnlyImages = new WeakHashMap<Image, Image>();
    private static final Map<Image, Image> grayImages = new WeakHashMap<Image, Image>();
    private static final Map<Image, Image> businessIndicatorImages = new WeakHashMap<Image, Image>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image createGreyIcon(Image image) {
        Map<Image, Image> map = grayImages;
        synchronized (map) {
            Image grayImage = grayImages.get(image);
            if (grayImage == null) {
                grayImage = Image.createGrey((Image)image);
                grayImages.put(image, grayImage);
            }
            return grayImage;
        }
    }

    public static Image createReadOnly(Image image) {
        Image decorator = Image.create((Msg)DesignerMsg.READONLY);
        return IconFactory.createCachedDecorator(image, decorator, readOnlyImages);
    }

    public static Image createBusinessIndicator(Image image) {
        Image decorator = Image.create((Msg)DesignerMsg.BUSINESS_INDICATOR_FILTER);
        return IconFactory.createCachedDecorator(image, decorator, businessIndicatorImages);
    }

    public static Image createProcessImageIcon(boolean readOnly) {
        Image result = Image.create((Msg)LibMsg.PROCESS);
        if (readOnly) {
            result = IconFactory.createReadOnly(result);
        }
        return result;
    }

    public static Image createXMasIcon(Image icon) {
        ArrayList<Image> list = new ArrayList<Image>();
        list.add(icon);
        list.add(Image.create((Msg)DesignerMsg.XMAS));
        ComposedIcon c = new ComposedIcon(list);
        return Image.create((Icon)c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image createCachedDecorator(@NotNull Image image, @NotNull Image decorator, @NotNull Map<Image, Image> cache) {
        Map<Image, Image> map = cache;
        synchronized (map) {
            Image result = cache.get(image);
            if (result == null) {
                ArrayList<Image> list = new ArrayList<Image>();
                list.add(image);
                list.add(decorator);
                ComposedIcon c = new ComposedIcon(list);
                result = Image.create((Icon)c);
                cache.put(image, result);
            }
            return result;
        }
    }
}

