/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import oracle.bpm.log.Log;

public class ExecUtils {
    public static int exec(String ... args) throws IOException {
        try {
            Process process = Runtime.getRuntime().exec(args);
            Dumper out = new Dumper("INFO ", process.getInputStream(), System.out);
            Dumper err = new Dumper("ERROR", process.getErrorStream(), System.out);
            out.start();
            err.start();
            return process.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return -1;
        }
    }

    private static class Dumper
    extends Thread {
        private InputStream in;
        private PrintStream out;
        private String prefix;

        Dumper(String prefix, InputStream in, PrintStream out) {
            super("Stream Dumper[ " + prefix + " ]");
            this.prefix = prefix;
            this.in = in;
            this.out = out;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            block3: {
                InputStreamReader isr = new InputStreamReader(this.in);
                BufferedReader reader = new BufferedReader(isr);
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        this.out.print(this.prefix);
                        this.out.print(": ");
                        this.out.println(line);
                        line = reader.readLine();
                    }
                }
                catch (IOException e) {
                    if (!Log.isDebugging()) break block3;
                    Log.logDebug(e);
                }
            }
        }
    }
}

