/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.update;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.expression.ExpressionContainerListener;
import oracle.bpm.designer.expression.ExpressionPanel;
import oracle.bpm.designer.expression.ExpressionPanelFactory;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.selectorpanel.ComboBoxSelectorPanel;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.dataassociations.DataAssignmentItemEndpoint;
import oracle.bpm.project.model.processes.update.AllUserTasksUpdateTargetDefinition;
import oracle.bpm.project.model.processes.update.TaskIdUpdateTargetDefinition;
import oracle.bpm.project.model.processes.update.UpdateTargetDefinition;
import oracle.bpm.project.model.processes.update.UpdateTargetType;
import oracle.bpm.project.model.processes.update.UpdateTask;
import oracle.bpm.project.model.processes.update.UserTaskUpdateTargetDefinition;
import oracle.bpm.project.view.project.view.renderer.ProjectObjectRenderer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ReferenceComboBox;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;

public class UpdateTaskTargetPanel
extends ComboBoxSelectorPanel<UpdateTargetType> {
    private UpdateTask updateTask;

    public UpdateTaskTargetPanel(@NotNull UiContainer parent, @NotNull UpdateTask updateTask) {
        super(parent, DesignerMsg.TARGET, DesignerMsg.TARGET, 5);
        this.updateTask = updateTask;
        this.init();
    }

    public void validateEditor() throws ProjectException {
        this.getInnerPanel().validatePanel();
    }

    @Override
    public UpdateTargetDefinitionPanel getInnerPanel() {
        return (UpdateTargetDefinitionPanel)super.getInnerPanel();
    }

    @Override
    protected void applySelectionChanges() {
        UpdateTargetType type = (UpdateTargetType)this.getSelectedOption();
        this.updateTask.setUpdateTargetType(type);
    }

    @Override
    protected Panel createInnerPanel(@NotNull UiContainer container, @NotNull UpdateTargetType selectedItem) {
        UpdateTargetDefinitionPanel result = null;
        if (selectedItem == UpdateTargetType.ALL_USER_TASKS) {
            AllUserTasksUpdateTargetDefinition definition = (AllUserTasksUpdateTargetDefinition)this.updateTask.getUpdateTargetDefinition().as(AllUserTasksUpdateTargetDefinition.class);
            result = new AllUserTasksUpdateTargetDefinitionPanel(container, (UpdateTargetDefinition)definition);
        } else if (selectedItem == UpdateTargetType.USER_TASK) {
            UserTaskUpdateTargetDefinition definition = (UserTaskUpdateTargetDefinition)this.updateTask.getUpdateTargetDefinition().as(UserTaskUpdateTargetDefinition.class);
            result = new UserTaskUpdateTargetDefinitionPanel(container, (UpdateTargetDefinition)definition);
        } else if (selectedItem == UpdateTargetType.TASK_ID) {
            TaskIdUpdateTargetDefinition definition = (TaskIdUpdateTargetDefinition)this.updateTask.getUpdateTargetDefinition().as(TaskIdUpdateTargetDefinition.class);
            result = new TaskIdTargetDefinitionPanel(container, (UpdateTargetDefinition)definition);
        }
        return result;
    }

    private void init() {
        UpdateTargetType type = this.updateTask.getUpdateTargetType();
        for (UpdateTargetType updateType : UpdateTargetType.values()) {
            this.addOption(updateType);
        }
        this.setSelectedOption(type);
        this.setLabelProvider(new LabelProvider<UpdateTargetType>(){

            public Image getIcon(UpdateTargetType element) {
                return null;
            }

            public String getText(UpdateTargetType element) {
                return element.getMsg().getString();
            }
        });
    }

    private static class UserTaskUpdateTargetDefinitionPanel
    extends UpdateTargetDefinitionPanel {
        private Button clearButton;
        private ReferenceComboBox<UserTask> targetUserTaskComboBox;

        public UserTaskUpdateTargetDefinitionPanel(@NotNull UiContainer parent, @NotNull UpdateTargetDefinition updateTargetDefinition) {
            super(parent, updateTargetDefinition);
        }

        @Override
        public void validatePanel() throws ProjectException {
            if (!this.targetUserTaskComboBox.isValidSelection()) {
                throw new ProjectException((ProjectObject)this.getUpdateTargetDefinition().getUpdateTask(), DesignerMsg.DYNAMIC_SELECTION_INVALID(DesignerMsg.USER_TASK));
            }
        }

        protected UserTaskUpdateTargetDefinition getUpdateTargetDefinition() {
            return (UserTaskUpdateTargetDefinition)super.getUpdateTargetDefinition();
        }

        @Override
        protected UiComponent createDefinitionPanel(@NotNull UiContainer parent) {
            Panel result = new Panel(parent);
            result.setLayout((Layout)new MigLayout("ins 0, gap 5, fillx"));
            UpdateTask updateTask = this.getUpdateTargetDefinition().getUpdateTask();
            Label label = Label.create((UiContainer)result, (Msg)DesignerMsg.USER_TASK);
            result.add((UiComponent)label);
            this.targetUserTaskComboBox = this.createTargetUserTaskComboBox((UiContainer)result, updateTask);
            this.targetUserTaskComboBox.setValue((Object)this.getUpdateTargetDefinition().getTargetUserTask());
            this.targetUserTaskComboBox.addModificationListener(new ModificationListener(){

                public void objectModified(ModificationEvent modificationEvent) {
                    UserTaskUpdateTargetDefinitionPanel.this.getUpdateTargetDefinition().setTargetUserTask((UserTask)UserTaskUpdateTargetDefinitionPanel.this.targetUserTaskComboBox.getSelectedItem());
                }
            });
            result.add(this.targetUserTaskComboBox, (Object)"growx");
            this.clearButton = Button.createIconic((UiContainer)result, (Msg)UIMsg.CLEAR);
            this.clearButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    UserTaskUpdateTargetDefinitionPanel.this.targetUserTaskComboBox.setValue(null);
                }
            });
            result.add((UiComponent)this.clearButton);
            return result;
        }

        private ReferenceComboBox<UserTask> createTargetUserTaskComboBox(@NotNull UiContainer parent, @NotNull UpdateTask updateTask) {
            ReferenceComboBox result = new ReferenceComboBox(parent);
            Sequence sources = updateTask.getProcess().getDescendants(UserTask.class);
            for (UserTask source : sources) {
                result.addItem((Object)source);
            }
            result.setLabelProvider((LabelProvider)new LabelProvider<UserTask>(){

                public Image getIcon(UserTask element) {
                    return ProjectObjectRenderer.Default.getIcon((ProjectObject)element);
                }

                public String getText(UserTask element) {
                    return ProjectObjectRenderer.Default.getLabel((ProjectObject)element);
                }
            });
            return result;
        }
    }

    private static class TaskIdTargetDefinitionPanel
    extends UpdateTargetDefinitionPanel {
        private ExpressionPanel taskIdExpressionPanel;

        public TaskIdTargetDefinitionPanel(@NotNull UiContainer parent, @NotNull UpdateTargetDefinition updateTargetDefinition) {
            super(parent, updateTargetDefinition);
        }

        @Override
        public void validatePanel() throws ProjectException {
            if (!this.taskIdExpressionPanel.isExpressionValid()) {
                throw new ProjectException((ProjectObject)this.getUpdateTargetDefinition().getUpdateTask(), DesignerMsg.INVALID_ATTRIBUTE_EXPRESSION(ProjectModelMsg.TASK_ID.getString()));
            }
        }

        protected TaskIdUpdateTargetDefinition getUpdateTargetDefinition() {
            return (TaskIdUpdateTargetDefinition)super.getUpdateTargetDefinition();
        }

        @Override
        protected UiComponent createDefinitionPanel(@NotNull UiContainer parent) {
            Panel result = new Panel(parent);
            result.setLayout((Layout)new MigLayout("ins 0, gap 5, fillx"));
            Label label = Label.create((UiContainer)result, (Msg)ProjectModelMsg.TASK_ID);
            result.add((UiComponent)label);
            ExpressionContext taskIdExpressionContext = new ExpressionContext(this.getExpressionContext(), TaskIdUpdateTargetDefinition.ResultType.getTaskId());
            this.taskIdExpressionPanel = ExpressionPanelFactory.createUpdatePropertyPanel((UiContainer)result, taskIdExpressionContext, false);
            this.taskIdExpressionPanel.setExpression(this.getUpdateTargetDefinition().getTaskId());
            this.taskIdExpressionPanel.addListener(new ExpressionContainerListener(){

                @Override
                public void expressionChanged() {
                    TaskIdTargetDefinitionPanel.this.getUpdateTargetDefinition().setTaskId(TaskIdTargetDefinitionPanel.this.taskIdExpressionPanel.getExpression());
                }
            });
            result.add(this.taskIdExpressionPanel.getUiComponent(), (Object)"growx");
            return result;
        }

        protected DataDeclarationContainer getExpressionContext() {
            UpdateTask task = this.getUpdateTargetDefinition().getUpdateTask();
            return task.getInputDataAssociationSet().getDataDeclarationContainer(DataAssignmentItemEndpoint.SOURCE);
        }
    }

    private static class AllUserTasksUpdateTargetDefinitionPanel
    extends UpdateTargetDefinitionPanel {
        public AllUserTasksUpdateTargetDefinitionPanel(@NotNull UiContainer parent, @NotNull UpdateTargetDefinition updateTargetDefinition) {
            super(parent, updateTargetDefinition);
        }

        @Override
        public void validatePanel() throws ProjectException {
        }

        @Override
        protected UiComponent createDefinitionPanel(@NotNull UiContainer parent) {
            return null;
        }
    }

    private static abstract class UpdateTargetDefinitionPanel
    extends Panel {
        private UpdateTargetDefinition updateTargetDefinition;

        protected UpdateTargetDefinitionPanel(@NotNull UiContainer parent, @NotNull UpdateTargetDefinition updateTargetDefinition) {
            super(parent);
            this.updateTargetDefinition = updateTargetDefinition;
            this.init();
        }

        public abstract void validatePanel() throws ProjectException;

        protected abstract UiComponent createDefinitionPanel(@NotNull UiContainer var1);

        protected UpdateTargetDefinition getUpdateTargetDefinition() {
            return this.updateTargetDefinition;
        }

        private void init() {
            this.setLayout((Layout)new MigLayout("ins 0, gap 0, fillx"));
            UiComponent definitionPanel = this.createDefinitionPanel((UiContainer)this);
            if (definitionPanel != null) {
                this.add(definitionPanel, "growx, wrap");
            }
        }
    }
}

