/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.update;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.selectorpanel.ComboBoxSelectorPanel;
import oracle.bpm.designer.update.DefaultUpdateDefinitionPanel;
import oracle.bpm.designer.update.OutcomeUpdateDefinitionPanel;
import oracle.bpm.designer.update.PriorityUpdateDefinitionPanel;
import oracle.bpm.designer.update.ReassignUpdateDefinitionPanel;
import oracle.bpm.designer.update.UpdateDefinitionPanel;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.update.DefaultUpdateDefinition;
import oracle.bpm.project.model.processes.update.OutcomeUpdateDefinition;
import oracle.bpm.project.model.processes.update.PriorityUpdateDefinition;
import oracle.bpm.project.model.processes.update.ReassignUpdateDefinition;
import oracle.bpm.project.model.processes.update.UpdateTask;
import oracle.bpm.project.model.processes.update.UpdateType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

public class UpdateTaskOperationPanel
extends ComboBoxSelectorPanel<UpdateType> {
    private UpdateTask updateTask;

    public UpdateTaskOperationPanel(@NotNull UiContainer parent, @NotNull UpdateTask updateTask) {
        super(parent, DesignerMsg.UPDATE_OPERATION, DesignerMsg.UPDATE_OPERATION, 5);
        this.updateTask = updateTask;
        this.init();
    }

    public void validateEditor() throws ProjectException {
        this.getInnerPanel().validatePanel();
    }

    @Override
    public UpdateDefinitionPanel getInnerPanel() {
        return (UpdateDefinitionPanel)super.getInnerPanel();
    }

    @Override
    protected void applySelectionChanges() {
        UpdateType type = (UpdateType)this.getSelectedOption();
        this.updateTask.setUpdateType(type);
    }

    @Override
    protected Panel createInnerPanel(@NotNull UiContainer container, @NotNull UpdateType selectedItem) {
        UpdateDefinitionPanel result;
        if (selectedItem == UpdateType.UPDATE_OUTCOME) {
            OutcomeUpdateDefinition definition = (OutcomeUpdateDefinition)this.updateTask.getUpdateDefinition().as(OutcomeUpdateDefinition.class);
            result = new OutcomeUpdateDefinitionPanel(container, definition);
        } else if (selectedItem == UpdateType.UPDATE_PRIORITY) {
            PriorityUpdateDefinition definition = (PriorityUpdateDefinition)this.updateTask.getUpdateDefinition().as(PriorityUpdateDefinition.class);
            result = new PriorityUpdateDefinitionPanel(container, definition);
        } else if (selectedItem == UpdateType.REASSIGN) {
            ReassignUpdateDefinition definition = (ReassignUpdateDefinition)this.updateTask.getUpdateDefinition().as(ReassignUpdateDefinition.class);
            result = new ReassignUpdateDefinitionPanel(container, definition);
        } else {
            DefaultUpdateDefinition definition = (DefaultUpdateDefinition)this.updateTask.getUpdateDefinition().as(DefaultUpdateDefinition.class);
            result = new DefaultUpdateDefinitionPanel(container, definition);
        }
        return result;
    }

    private void init() {
        UpdateType type = this.updateTask.getUpdateType();
        for (UpdateType updateType : UpdateType.values()) {
            this.addOption(updateType);
        }
        this.setSelectedOption(type);
        this.setLabelProvider(new LabelProvider<UpdateType>(){

            public Image getIcon(UpdateType element) {
                return Image.create((Msg)DesignerMsg.UPDATE_OPERATION);
            }

            public String getText(UpdateType element) {
                return element.getMsg().getString();
            }
        });
    }
}

