/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.update;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.expression.ExpressionContainerListener;
import oracle.bpm.designer.expression.ExpressionPanel;
import oracle.bpm.designer.expression.ExpressionPanelFactory;
import oracle.bpm.designer.identity.LookupDialog;
import oracle.bpm.designer.identity.LookupService;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.update.UpdateDefinitionPanel;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.update.ReassignUpdateDefinition;
import oracle.bpm.project.model.processes.update.UpdateDefinition;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

class ReassignUpdateDefinitionPanel
extends UpdateDefinitionPanel {
    private ExpressionPanel assignedUserExpressionPanel;

    protected ReassignUpdateDefinitionPanel(@NotNull UiContainer parent, @NotNull ReassignUpdateDefinition reassignUpdateDefinition) {
        super(parent, (UpdateDefinition)reassignUpdateDefinition);
    }

    @Override
    public void validatePanel() throws ProjectException {
        if (!this.assignedUserExpressionPanel.isExpressionValid()) {
            throw new ProjectException((ProjectObject)this.getUpdateDefinition().getUpdateTask(), DesignerMsg.INVALID_ATTRIBUTE_EXPRESSION(ProjectModelMsg.ASSIGNED_USER.getString()));
        }
    }

    protected ReassignUpdateDefinition getUpdateDefinition() {
        return (ReassignUpdateDefinition)super.getUpdateDefinition();
    }

    @Override
    protected UiComponent createDefinitionPanel(@NotNull UiContainer parent) {
        Panel panel = new Panel(parent);
        panel.setLayout((Layout)new MigLayout("ins 0, gap 5, fillx"));
        ExpressionContext assignedUserExpressionContext = new ExpressionContext(this.getExpressionContext(), ReassignUpdateDefinition.ResultType.getAssignedUser());
        Label label = Label.create((UiContainer)panel, (Msg)ProjectModelMsg.ASSIGNED_USER);
        panel.add((UiComponent)label);
        this.assignedUserExpressionPanel = ExpressionPanelFactory.createUpdatePropertyPanel((UiContainer)panel, assignedUserExpressionContext, false);
        this.assignedUserExpressionPanel.setExpression(this.getUpdateDefinition().getAssignedUser());
        this.assignedUserExpressionPanel.addListener(new ExpressionContainerListener(){

            @Override
            public void expressionChanged() {
                ReassignUpdateDefinitionPanel.this.getUpdateDefinition().setAssignedUser(ReassignUpdateDefinitionPanel.this.assignedUserExpressionPanel.getExpression());
            }
        });
        panel.add(this.assignedUserExpressionPanel.getUiComponent(), (Object)"growx");
        Button lookupButton = Button.createBrowse((UiContainer)panel, (Msg)DesignerMsg.SEARCH);
        lookupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LookupDialog.LookupDialogType type;
                LookupDialog dialog;
                LookupService service = AbstractStudioWorkbench.getInstance().getLookupService();
                if (service != null && (dialog = service.getDialog(type = LookupDialog.LookupDialogType.USER)).showDialog()) {
                    String value = dialog.getValue();
                    Expression lookupExpression = ExpressionHelper.createTextExpression((String)value);
                    ReassignUpdateDefinitionPanel.this.assignedUserExpressionPanel.setExpression(lookupExpression);
                }
            }
        });
        panel.add((UiComponent)lookupButton);
        return panel;
    }
}

