/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.update;

import oracle.bpm.designer.expression.ExpressionContainerListener;
import oracle.bpm.designer.expression.ExpressionPanel;
import oracle.bpm.designer.expression.ExpressionPanelFactory;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.update.UpdateDefinitionPanel;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.update.PriorityUpdateDefinition;
import oracle.bpm.project.model.processes.update.UpdateDefinition;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

class PriorityUpdateDefinitionPanel
extends UpdateDefinitionPanel {
    private ExpressionPanel priorityExpressionPanel;

    protected PriorityUpdateDefinitionPanel(@NotNull UiContainer parent, @NotNull PriorityUpdateDefinition priorityUpdateDefinition) {
        super(parent, (UpdateDefinition)priorityUpdateDefinition);
    }

    @Override
    public void validatePanel() throws ProjectException {
        if (!this.priorityExpressionPanel.isExpressionValid()) {
            throw new ProjectException((ProjectObject)this.getUpdateDefinition().getUpdateTask(), DesignerMsg.INVALID_ATTRIBUTE_EXPRESSION(ProjectModelMsg.PRIORITY.getString()));
        }
    }

    protected PriorityUpdateDefinition getUpdateDefinition() {
        return (PriorityUpdateDefinition)super.getUpdateDefinition();
    }

    @Override
    protected UiComponent createDefinitionPanel(@NotNull UiContainer parent) {
        Panel panel = new Panel(parent);
        panel.setLayout((Layout)new MigLayout("ins 0, gap 5, fillx"));
        ExpressionContext priorityExpressionContext = new ExpressionContext(this.getExpressionContext(), PriorityUpdateDefinition.ResultType.getPriority());
        Label label = Label.create((UiContainer)panel, (Msg)ProjectModelMsg.BY_PRIORITY);
        panel.add((UiComponent)label);
        this.priorityExpressionPanel = ExpressionPanelFactory.createUserTaskPriorityPanel((UiContainer)panel, priorityExpressionContext);
        this.priorityExpressionPanel.setExpression(this.getUpdateDefinition().getPriority());
        this.priorityExpressionPanel.addListener(new ExpressionContainerListener(){

            @Override
            public void expressionChanged() {
                PriorityUpdateDefinitionPanel.this.getUpdateDefinition().setPriority(PriorityUpdateDefinitionPanel.this.priorityExpressionPanel.getExpression());
            }
        });
        panel.add(this.priorityExpressionPanel.getUiComponent(), (Object)"growx");
        return panel;
    }
}

