/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.update;

import oracle.bpm.designer.expression.ExpressionContainerListener;
import oracle.bpm.designer.expression.ExpressionPanel;
import oracle.bpm.designer.expression.ExpressionPanelFactory;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.update.UpdateDefinitionPanel;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.update.OutcomeUpdateDefinition;
import oracle.bpm.project.model.processes.update.UpdateDefinition;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

class OutcomeUpdateDefinitionPanel
extends UpdateDefinitionPanel {
    private ExpressionPanel outcomeExpressionPanel;

    protected OutcomeUpdateDefinitionPanel(@NotNull UiContainer parent, @NotNull OutcomeUpdateDefinition outcomeUpdateDefinition) {
        super(parent, (UpdateDefinition)outcomeUpdateDefinition);
    }

    @Override
    public void validatePanel() throws ProjectException {
        if (!this.outcomeExpressionPanel.isExpressionValid()) {
            throw new ProjectException((ProjectObject)this.getUpdateDefinition().getUpdateTask(), DesignerMsg.INVALID_ATTRIBUTE_EXPRESSION(ProjectModelMsg.OUTCOME.getString()));
        }
    }

    protected OutcomeUpdateDefinition getUpdateDefinition() {
        return (OutcomeUpdateDefinition)super.getUpdateDefinition();
    }

    @Override
    protected UiComponent createDefinitionPanel(@NotNull UiContainer parent) {
        Panel panel = new Panel(parent);
        panel.setLayout((Layout)new MigLayout("ins 0, gap 5, fillx"));
        ExpressionContext outcomeExpressionContext = new ExpressionContext(this.getExpressionContext(), OutcomeUpdateDefinition.ResultType.getOutcome());
        Label label = Label.create((UiContainer)panel, (Msg)ProjectModelMsg.OUTCOME);
        panel.add((UiComponent)label);
        this.outcomeExpressionPanel = ExpressionPanelFactory.createOutcomeUpdatePanel((UiContainer)panel, outcomeExpressionContext);
        this.outcomeExpressionPanel.setExpression(this.getUpdateDefinition().getOutcome());
        this.outcomeExpressionPanel.addListener(new ExpressionContainerListener(){

            @Override
            public void expressionChanged() {
                OutcomeUpdateDefinitionPanel.this.getUpdateDefinition().setOutcome(OutcomeUpdateDefinitionPanel.this.outcomeExpressionPanel.getExpression());
            }
        });
        panel.add(this.outcomeExpressionPanel.getUiComponent(), (Object)"growx");
        return panel;
    }
}

