/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.types;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.designer.TypesFilter;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.types.ArrayPanel;
import oracle.bpm.designer.types.AssociativeArrayPanel;
import oracle.bpm.designer.types.CILTypeComboBox;
import oracle.bpm.designer.types.ComponentPanel;
import oracle.bpm.designer.types.DefaultPanel;
import oracle.bpm.designer.types.TypeItem;
import oracle.bpm.designer.types.TypeItemFactory;
import oracle.bpm.designer.types.TypeItemId;
import oracle.bpm.designer.types.TypePanel;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.project.view.filter.ProjectFilters;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.CustomEvent;
import oracle.bpm.ui.event.CustomEventListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.forms.FormsFactory;
import oracle.bpm.ui.forms.StandardForm;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Layout;

@Deprecated
public class TypesDialog
extends OkCancelDialog
implements ItemListener {
    private boolean arraysEnabled = true;
    private CardLayout cardLayout;
    private Panel cardPanel;
    private ComponentCatalog componentCatalog;
    private boolean isInitialized = false;
    private boolean isMethod;
    private int options = 3;
    private Project project;
    private ProjectFilter projectFilter;
    private TypeItem selectedTypeItem;
    private TypesFilter selectionFilter;
    private TypeItem type;
    private TypesFilter typeFilter;
    private CILTypeComboBox typesLst;
    private Map<TypeItemId, TypePanel> typesMap;
    public static final int COMPONENT = 1;
    public static final int TYPES = 2;
    public static final int VOID = 4;
    public static final int NONE = 8;
    public static final int DEFAULT = 3;

    public TypesDialog(UiWindow parent, Project project) {
        this(parent, project, true);
    }

    public TypesDialog(UiWindow parent, Project project, boolean arraysEnabled) {
        this(parent, 3, project, arraysEnabled);
    }

    public TypesDialog(UiWindow parent, int options, Project project, boolean arraysEnabled) {
        this(parent, options, project, null, arraysEnabled);
    }

    public TypesDialog(UiWindow parent, int options, Project project, ProjectFilter filter, boolean arraysEnabled) {
        super(parent, DesignerMsg.BROWSE_TYPES, true);
        this.project = project;
        this.projectFilter = filter == null ? ProjectFilters.BPM_OBJECTS : filter;
        this.arraysEnabled = arraysEnabled;
        this.init(options);
    }

    public String getHelpId() {
        return this.getHelpIdWithMsg();
    }

    public void setInitialTypeRef(CatalogType typeRef) {
        if (typeRef != null) {
            if (this.typesLst != null) {
                this.typesLst.setSelectedItem(typeRef);
            }
            if (typeRef.getKind() == 5) {
                this.updateTypePanel();
            }
            this.updateTypePanel();
        }
    }

    public void setMethod(boolean method) {
        this.isMethod = method;
    }

    public boolean isMethod() {
        return this.isMethod;
    }

    public void setSelectedTypeItem(TypeItem typeItem) {
        this.selectedTypeItem = typeItem;
    }

    public TypeItem getSelectedTypeItem() {
        return this.selectedTypeItem;
    }

    public void setSelectionFilter(TypesFilter selectionFilter) {
        this.selectionFilter = selectionFilter;
    }

    public void setTypeCatalog(ComponentCatalog catalog) {
        if (catalog == null) {
            throw new IllegalArgumentException("ConfigType Catalog cannot be null");
        }
        this.componentCatalog = catalog;
    }

    public ComponentCatalog getTypeCatalog() {
        return this.componentCatalog;
    }

    public void setTypeFilter(TypesFilter typeFilter) {
        this.typeFilter = typeFilter;
    }

    public boolean isValidType() {
        TypeItem typeItem = this.getSelectedTypeItem();
        if (typeItem != null) {
            TypePanel typePanel = this.typesMap.get((Object)typeItem.getId());
            return typeItem.getRef() != null && typePanel.isValidType();
        }
        return false;
    }

    public void setVisible(boolean visible) {
        if (visible && !this.isInitialized) {
            this.updateTypePanel();
        }
        super.setVisible(visible);
    }

    public void ok() {
        if (this.isValidType()) {
            this.setVisible(false);
            this.dispose();
        } else {
            TypeItem typeItem = this.getSelectedTypeItem();
            if (typeItem != null) {
                this.typesMap.get((Object)typeItem.getId()).showTypeErrors();
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.typesLst) {
            this.updateTypePanel();
        }
    }

    public void setProjectFilter(ProjectFilter projectFilter) {
        this.projectFilter = projectFilter;
    }

    public void setArraysEnabled(boolean arraysEnabled) {
        this.arraysEnabled = arraysEnabled;
    }

    private TypeItem getSelectedItem() {
        if (this.typesLst == null) {
            return this.type;
        }
        return (TypeItem)this.typesLst.getSelectedItem();
    }

    private void updateTypePanel() {
        TypeItem typeItem = this.getSelectedItem();
        this.setSelectedTypeItem(typeItem);
        TypePanel typePanel = this.typesMap.get((Object)typeItem.getId());
        typePanel.setTypeItem(typeItem);
        if (!typePanel.isInitialized()) {
            this.initializeTypePanel(typePanel);
        }
        this.cardLayout.show((UiContainer)this.cardPanel, typeItem.getId().toString());
        this.isInitialized = true;
    }

    private void initializeTypePanel(TypePanel typePanel) {
        ComponentCatalog catalog = this.getTypeCatalog();
        assert (catalog != null) : "ConfigType Catalog cannot be null!";
        typePanel.setTypeCatalog(catalog);
        typePanel.addCustomEventListener((CustomEventListener)new CustomEventListener<TypeItem>(){

            public void eventChanged(CustomEvent<TypeItem> customEvent) {
                if (customEvent.getEventKey().equals("oracle.bpm.designer.types.TypeItem")) {
                    TypeItem typeItem = (TypeItem)customEvent.getNewValue();
                    TypesDialog.this.setSelectedTypeItem(typeItem);
                }
            }
        });
        if (this.selectionFilter != null) {
            typePanel.setSelectionFilter(this.selectionFilter);
        }
        if (this.typeFilter != null) {
            typePanel.setTypesFilter(this.typeFilter);
        }
        typePanel.initialize();
        typePanel.revalidate();
        typePanel.requestFocus();
    }

    private void init(int opt) {
        boolean moreThanOneType;
        this.options = opt;
        UiContainer contentPane = this.getContentPane();
        final List<TypeItem> typeItemIterable = TypeItemFactory.createAllTypes(opt, this.isMethod);
        if (!this.arraysEnabled) {
            Iterator<TypeItem> it = typeItemIterable.iterator();
            while (it.hasNext()) {
                TypeItem item = it.next();
                if (item.getId() != TypeItemId.ARRAY && item.getId() != TypeItemId.ASSOCIATIVE_ARRAY) continue;
                it.remove();
            }
        }
        boolean bl = moreThanOneType = typeItemIterable.size() > 1;
        if (moreThanOneType) {
            Panel typePanel = new Panel(contentPane);
            StandardForm form = FormsFactory.createStandardForm((UiContainer)typePanel);
            this.typesLst = new CILTypeComboBox(contentPane){

                @Override
                protected void addTypes() {
                    for (TypeItem typeItem : typeItemIterable) {
                        this.addType(typeItem);
                    }
                }
            };
            this.typesLst.addItemListener(this);
            form.add(CoreMsg.TYPE, (UiComponent)this.typesLst);
            contentPane.add((UiComponent)typePanel, (Object)"North");
        } else {
            this.type = typeItemIterable.get(0);
        }
        this.cardLayout = new CardLayout();
        this.cardPanel = new Panel(contentPane);
        this.cardPanel.setLayout((Layout)this.cardLayout);
        this.typesMap = this.createPanelsMap((UiContainer)this.cardPanel);
        for (Map.Entry<TypeItemId, TypePanel> entry : this.typesMap.entrySet()) {
            this.cardPanel.add((UiComponent)entry.getValue(), (Object)entry.getKey().toString());
        }
        contentPane.add((UiComponent)this.cardPanel, (Object)"Center");
        this.setSize(450, 500);
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private TypePanel createDefaultPanel(UiContainer parent) {
        return new DefaultPanel(parent);
    }

    private Map<TypeItemId, TypePanel> createPanelsMap(UiContainer parent) {
        LinkedHashMap<TypeItemId, TypePanel> map = new LinkedHashMap<TypeItemId, TypePanel>();
        if ((this.options & 1) != 0) {
            map.put(TypeItemId.COMPONENT, this.initPanel(new ComponentPanel(parent, this.project, this.projectFilter)));
        }
        if ((this.options & 2) != 0) {
            if (this.arraysEnabled) {
                map.put(TypeItemId.ARRAY, this.initPanel(new ArrayPanel(parent, this.project)));
                map.put(TypeItemId.ASSOCIATIVE_ARRAY, this.initPanel(new AssociativeArrayPanel(parent, this.project)));
            }
            map.put(TypeItemId.BINARY, this.createDefaultPanel(parent));
            map.put(TypeItemId.BOOL, this.createDefaultPanel(parent));
            map.put(TypeItemId.DECIMAL, this.createDefaultPanel(parent));
            map.put(TypeItemId.INT, this.createDefaultPanel(parent));
            map.put(TypeItemId.INTERVAL, this.createDefaultPanel(parent));
            map.put(TypeItemId.REAL, this.createDefaultPanel(parent));
            map.put(TypeItemId.STRING, this.createDefaultPanel(parent));
            map.put(TypeItemId.TIME, this.createDefaultPanel(parent));
            map.put(TypeItemId.ANY, this.createDefaultPanel(parent));
        }
        if ((this.options & 4) != 0 || this.isMethod()) {
            map.put(TypeItemId.VOID, this.createDefaultPanel(parent));
        }
        if ((this.options & 8) != 0) {
            map.put(TypeItemId.NONE, this.createDefaultPanel(parent));
        }
        return map;
    }

    private TypePanel initPanel(TypePanel typePanel) {
        typePanel.setParentDialog((Dialog)this);
        typePanel.setTypeItem(this.getSelectedTypeItem());
        return typePanel;
    }
}

