/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.types;

import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.type.TypeRenderer;
import oracle.bpm.designer.types.TypeItem;
import oracle.bpm.editor.EditorPreferences;
import oracle.bpm.lang.IllegalTypeException;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeParser;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.event.InputVerifier;
import oracle.bpm.util.LoggingUtils;

public class TypeUtils {
    public static TypeRef getTypeRefFor(String type, ComponentCatalog componentCatalog) {
        assert (componentCatalog != null) : "ConfigType Catalog cannot be null";
        if (type == null || type.trim().equals("")) {
            return null;
        }
        LanguageSpec languageSpec = EditorPreferences.getInstance().getLanguageSpec();
        TypeParser typeParser = languageSpec.getTypeParser();
        try {
            return typeParser.parse(type, componentCatalog);
        }
        catch (IllegalTypeException e) {
            return null;
        }
    }

    public static String renderFuegoType(TypeDescription targetType) {
        try {
            LanguageSpec languageSpec = LanguageSpec.getLanguageSpec((String)"Fuego");
            return languageSpec.getTypeRenderer().render((TypeRef)targetType);
        }
        catch (InvalidLanguageException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String renderPrimitiveType(CatalogType type) {
        return TypeUtils.renderType(type.primitiveEquivalent(true));
    }

    public static String renderType(CatalogType type) {
        TypeRenderer typeRenderer = null;
        try {
            typeRenderer = LanguageSpec.getLanguageSpec((String)"Fuego").getTypeRenderer();
        }
        catch (InvalidLanguageException e) {
            LoggingUtils.assertPrintStackTrace((Exception)((Object)e));
        }
        assert (typeRenderer != null);
        return typeRenderer.render((TypeRef)type.getDelegate());
    }

    static class TypeRefVerifier
    implements InputVerifier {
        private ComponentCatalog componentCatalog;

        public TypeRefVerifier(ComponentCatalog componentCatalog) {
            this.componentCatalog = componentCatalog;
        }

        public ComponentCatalog getTypeCatalog() {
            return this.componentCatalog;
        }

        public boolean verify(String input) {
            if (input == null || input.trim().equals("")) {
                System.out.println("TypeUtils$TypeRefVerifier.verify typeText is null or empty");
                return false;
            }
            ComponentCatalog componentCatalog = this.getTypeCatalog();
            if (componentCatalog == null) {
                System.out.println("TypeUtils$TypeRefVerifier.verify componentCatalog is null");
                return false;
            }
            return TypeUtils.getTypeRefFor(input, componentCatalog) != null;
        }
    }

    static class TypeLabelProvider
    extends LabelProvider.Default<TypeItem> {
        TypeLabelProvider() {
        }

        public String getText(TypeItem item) {
            return item.isPredefined() ? item.getText() : "<" + item.getText() + ">";
        }
    }
}

