/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.types;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.project.CatalogTypeImpl;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;

public enum TypeItemId {
    COMPONENT,
    ARRAY,
    ITERATOR,
    ASSOCIATIVE_ARRAY,
    STRING,
    INT,
    BOOL,
    REAL,
    DECIMAL,
    TIME,
    INTERVAL,
    BINARY,
    ANY,
    REGEXP,
    VOID,
    NONE;

    private static Map<Integer, TypeItemId> idForKind;

    public static TypeItemId idForTypeRef(CatalogType typeRef) {
        int kind = typeRef.getKind();
        if (17 == kind || 11 == kind) {
            if (typeRef.equivalent(CatalogTypeImpl.get((TypeRef)TypeFactory.wellKnown("RegExp")))) {
                return REGEXP;
            }
            return COMPONENT;
        }
        return TypeItemId.getIdForKindMap().get(kind);
    }

    private static Map<Integer, TypeItemId> getIdForKindMap() {
        if (idForKind == null) {
            TypeItemId.createIdForKindMap();
        }
        return idForKind;
    }

    private static void createIdForKindMap() {
        idForKind = new HashMap<Integer, TypeItemId>();
        idForKind.put(12, ARRAY);
        idForKind.put(13, ASSOCIATIVE_ARRAY);
        idForKind.put(16, ITERATOR);
        idForKind.put(10, ANY);
        idForKind.put(8, BINARY);
        idForKind.put(1, BOOL);
        idForKind.put(3, DECIMAL);
        idForKind.put(2, INT);
        idForKind.put(7, INTERVAL);
        idForKind.put(4, REAL);
        idForKind.put(5, STRING);
        idForKind.put(6, TIME);
        idForKind.put(0, VOID);
        idForKind.put(-1, NONE);
    }
}

