/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.types;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.types.TypeItem;
import oracle.bpm.designer.types.TypePanel;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.text.NumericField;

public class DecimalPanel
extends TypePanel {
    private CheckBox lengthCheckBox;
    private NumericField<Integer> lengthSpinner;
    private CheckBox scaleCheckBox;
    private NumericField<Integer> scaleSpinner;

    public DecimalPanel(UiContainer parent) {
        super(parent, DesignerMsg.TYPES_DECIMAL);
    }

    @Override
    protected void initialize() {
        this.setLayout((Layout)new BorderLayout());
        Panel panel = new Panel((UiContainer)this);
        this.scaleCheckBox = CheckBox.create((UiContainer)panel, (Msg)DesignerMsg.TYPES_SCALE);
        this.scaleCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean isSelected = DecimalPanel.this.scaleCheckBox.isSelected();
                DecimalPanel.this.scaleSpinner.setEnabled(isSelected);
                DecimalPanel.this.showLength(isSelected);
                if (isSelected) {
                    DecimalPanel.this.updateValue();
                } else {
                    TypeItem typeItem = DecimalPanel.this.getTypeItem();
                    typeItem.setRef(CatalogType.Default.getDecimal());
                }
            }
        });
        this.lengthCheckBox = CheckBox.create((UiContainer)panel, (Msg)DesignerMsg.TYPES_LENGTH);
        this.lengthCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean isSelected = DecimalPanel.this.lengthCheckBox.isSelected();
                DecimalPanel.this.lengthSpinner.setEnabled(isSelected);
                DecimalPanel.this.updateValue();
            }
        });
        this.scaleSpinner = NumericField.createIntegerNumericField((UiContainer)panel);
        this.scaleSpinner.setValue((Number)1);
        this.scaleSpinner.setRange((Number)1, (Number)100);
        this.scaleSpinner.setStepSize((Number)1);
        this.lengthSpinner = NumericField.createIntegerNumericField((UiContainer)panel);
        this.lengthSpinner.setValue((Number)1);
        this.lengthSpinner.setRange((Number)1, (Number)100);
        this.lengthSpinner.setStepSize((Number)1);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DecimalPanel.this.updateValue();
            }
        };
        this.scaleSpinner.addChangeListener(changeListener);
        this.lengthSpinner.addChangeListener(changeListener);
        FormLayout layout = new FormLayout("1dlu, pref, 1dlu, pref, 1dlu", "pref, 5dlu, pref");
        PanelBuilder builder = layout.createBuilder(panel);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)this.scaleCheckBox, cc.xy(2, 1));
        builder.add(this.scaleSpinner, cc.xy(4, 1));
        builder.add((UiComponent)this.lengthCheckBox, cc.xy(2, 3));
        builder.add(this.lengthSpinner, cc.xy(4, 3));
        this.add((UiComponent)panel, "Center");
        this.setInitialized(true);
        this.updateDefaults();
    }

    @Override
    protected void updateDefaults() {
        TypeItem typeItem = this.getTypeItem();
        CatalogType typeRef = typeItem.getRef();
        if (typeRef != null) {
            CatalogType decimalType = typeRef;
            int scale = decimalType.getScale();
            int length = decimalType.getLength();
            if (scale != -1) {
                this.scaleCheckBox.setSelected(true);
                this.scaleSpinner.setEnabled(true);
                this.scaleSpinner.setValue((Number)scale);
                this.showLength(true);
                if (length != -1) {
                    this.lengthCheckBox.setSelected(true);
                    this.lengthSpinner.setEnabled(true);
                    this.lengthSpinner.setValue((Number)length);
                } else {
                    this.lengthCheckBox.setSelected(false);
                    this.lengthSpinner.setEnabled(false);
                }
            } else {
                this.setOnlyDecimal();
            }
        } else {
            typeItem.setRef(CatalogType.Default.getDecimal());
            this.setOnlyDecimal();
        }
    }

    private void showLength(boolean enabled) {
        this.lengthCheckBox.setVisible(enabled);
        this.lengthSpinner.setVisible(enabled);
    }

    private void setOnlyDecimal() {
        this.scaleCheckBox.setSelected(false);
        this.scaleCheckBox.setEnabled(true);
        this.scaleSpinner.setEnabled(false);
        this.showLength(false);
        this.lengthCheckBox.setSelected(false);
        this.lengthSpinner.setEnabled(false);
    }

    private void updateValue() {
        TypeItem typeItem = this.getTypeItem();
        this.lengthSpinner.setEnabled(this.lengthCheckBox.isSelected());
        int scaleValue = (Integer)this.scaleSpinner.getValue();
        int lengthValue = this.lengthCheckBox.isSelected() ? (Integer)this.lengthSpinner.getValue() : -1;
        typeItem.setRef(CatalogType.Default.getDecimal((int)lengthValue, (int)scaleValue));
    }
}

