/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.types;

import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.text.FilteredTextField;
import oracle.bpm.ui.text.TextFilter;

public class CILTypeTextField
extends FilteredTextField {
    public CILTypeTextField(UiContainer parent) {
        this(parent, "");
    }

    public CILTypeTextField(UiContainer parent, String text) {
        super(parent);
        this.setText(text);
        super.setFilter(this.getFilter());
    }

    public CILTypeTextField(UiContainer parent, String text, int columns) {
        super(parent, null, text, columns);
        super.setFilter(this.getFilter());
    }

    private TextFilter getFilter() {
        return new CILTypeTextFilter();
    }

    static class CILTypeTextFilter
    implements TextFilter {
        private static final String allowedChars = " _[].,()<>@";

        CILTypeTextFilter() {
        }

        public boolean accepts(String str, int offs) {
            if (str == null) {
                return true;
            }
            for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                if (Character.isLetterOrDigit(ch) || allowedChars.indexOf(ch) != -1) continue;
                return false;
            }
            return true;
        }

        public String filter(String str, int offs) {
            return str;
        }
    }
}

