/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.types;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import oracle.bpm.designer.types.TypeItem;
import oracle.bpm.designer.types.TypeItemFactory;
import oracle.bpm.designer.types.TypeItemId;
import oracle.bpm.designer.types.TypeUtils;
import oracle.bpm.editor.EditorPreferences;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.VisibilityAdapter;
import oracle.bpm.ui.event.VisibilityListener;

public class CILTypeComboBox
extends ComboBox<TypeItem>
implements PropertyChangeListener {
    private boolean eventsEnabled = true;
    private boolean isMethod;

    public CILTypeComboBox(UiContainer parent) {
        this(parent, false);
    }

    protected CILTypeComboBox(UiContainer parent, boolean isMethod) {
        super(parent, false);
        this.isMethod = isMethod;
        this.setLabelProvider((LabelProvider)new TypeUtils.TypeLabelProvider());
        this.setModel(new TypeComboModel());
        this.addTypes();
        this.setMaximumRowCount(10);
        this.setSelectedIndex(0);
        final EditorPreferences prefs = EditorPreferences.getInstance();
        prefs.addListener((PropertyChangeListener)this);
        this.addVisibilityListener((VisibilityListener)new VisibilityAdapter(){

            public void onDispose() {
                prefs.removeListener((PropertyChangeListener)CILTypeComboBox.this);
            }
        });
    }

    public boolean isEventsEnabled() {
        return this.eventsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("language")) {
            try {
                this.eventsEnabled = false;
                int selected = this.getSelectedIndex();
                this.removeAllItems();
                this.addTypes();
                if (selected < this.getItemCount()) {
                    this.setSelectedIndex(selected);
                }
            }
            finally {
                this.eventsEnabled = true;
            }
        }
    }

    public void setSelectedItem(Object item) {
        if (item != null) {
            throw new RuntimeException("THIS METHOD SHOULD NOT BE USED!!!!");
        }
        super.setSelectedItem(null);
    }

    public void setSelectedItem(CatalogType type) {
        TypeItem item = this.findType(TypeItemId.idForTypeRef(type));
        if (item == null) {
            item = this.createTypeItem(type);
        }
        item.setRef(type);
        this.setSelectedItem(item);
        this.repaint();
    }

    protected void addType(TypeItem typeItem) {
        super.addItem((Object)typeItem);
    }

    protected void addTypes() {
        for (TypeItem type : TypeItemFactory.createPredefinedTypes(3, this.isMethod)) {
            this.addType(type);
        }
    }

    private TypeItem createTypeItem(CatalogType type) {
        return new TypeItem(TypeItemId.idForTypeRef(type), TypeUtils.renderPrimitiveType(type), type){

            @Override
            public String getText() {
                return TypeUtils.renderPrimitiveType(this.getRef());
            }
        };
    }

    private void setSelectedItem(TypeItem item) {
        if (this.getModel() instanceof TypeComboModel && !this.containsItem(item)) {
            this.addType(item);
        }
        super.setSelectedItem((Object)item);
    }

    private TypeItem findType(TypeItemId typeItemId) {
        int size = this.getItemCount();
        for (int i = 0; i < size; ++i) {
            TypeItem typeItem = (TypeItem)this.getItemAt(i);
            if (typeItem.getId() != typeItemId) continue;
            return typeItem;
        }
        return null;
    }

    private final class TypeComboModel
    extends DefaultComboBoxModel {
        private TypeComboModel() {
        }

        @Override
        public void insertElementAt(Object anObject, int index) {
            if (this.getIndexOf(anObject) < 0) {
                super.insertElementAt(anObject, index);
            }
        }

        @Override
        public void addElement(Object anObject) {
            if (this.getIndexOf(anObject) < 0) {
                super.addElement(anObject);
            }
        }

        @Override
        protected void fireIntervalAdded(Object source, int index0, int index1) {
            if (CILTypeComboBox.this.eventsEnabled) {
                super.fireIntervalAdded(source, index0, index1);
            }
        }

        @Override
        protected void fireContentsChanged(Object source, int index0, int index1) {
            if (CILTypeComboBox.this.eventsEnabled) {
                super.fireContentsChanged(source, index0, index1);
            }
        }
    }
}

