/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.types;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.types.CILTypeComboBox;
import oracle.bpm.designer.types.DetailedCILTypeComboBox;
import oracle.bpm.designer.types.TypeItem;
import oracle.bpm.designer.types.TypePanel;
import oracle.bpm.designer.types.TypesDialog;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.event.UiEvent;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;

class AssociativeArrayPanel
extends TypePanel
implements ActionListener,
ItemListener {
    private RadioButton ascRadioBtn;
    private Button elemTypeBtn;
    private CILTypeComboBox elemTypeLst;
    private Button indexTypeBtn;
    private CILTypeComboBox indexTypeLst;
    private RadioButton insRadioBtn;
    private Project project;

    public AssociativeArrayPanel(UiContainer parent, Project project) {
        super(parent, DesignerMsg.TYPES_ASSOCIATIVE_ARRAY);
        this.project = project;
    }

    public void actionPerformed(ActionEvent e) {
        this.processEvent((UiEvent)e);
    }

    public void itemStateChanged(ItemEvent e) {
        this.processEvent((UiEvent)e);
    }

    @Override
    protected void initialize() {
        this.setLayout((Layout)new BorderLayout());
        Panel panel = new Panel((UiContainer)this);
        this.elemTypeLst = new DetailedCILTypeComboBox((UiContainer)panel, this.getTypeRepository());
        this.elemTypeLst.addItemListener(this);
        this.elemTypeBtn = new Button((UiContainer)panel, UIMsg.TO_MSG((String)"..."));
        this.elemTypeBtn.addActionListener((ActionListener)this);
        FormLayout layout = new FormLayout("1dlu, pref, 1dlu, pref:grow, 1dlu, min, 1dlu", "pref, 3dlu, pref, 1px, pref, pref, pref");
        this.indexTypeLst = new DetailedCILTypeComboBox((UiContainer)panel, this.getTypeRepository());
        this.indexTypeLst.addItemListener(this);
        this.indexTypeBtn = new Button((UiContainer)panel, UIMsg.TO_MSG((String)"..."));
        this.indexTypeBtn.addActionListener((ActionListener)this);
        this.insRadioBtn = new RadioButton((UiContainer)panel, DesignerMsg.TYPES_INSERTION);
        this.insRadioBtn.addActionListener((ActionListener)this);
        this.ascRadioBtn = new RadioButton((UiContainer)panel, DesignerMsg.TYPES_ASCENDING);
        this.ascRadioBtn.addActionListener((ActionListener)this);
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add((AbstractButton)this.insRadioBtn);
        btnGroup.add((AbstractButton)this.ascRadioBtn);
        PanelBuilder builder = layout.createBuilder(panel);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.TYPES_ELEMENTS_TYPE), cc.xy(2, 1));
        builder.add((UiComponent)this.elemTypeLst, cc.xy(4, 1));
        builder.add((UiComponent)this.elemTypeBtn, cc.xy(6, 1));
        builder.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.TYPES_INDEX_TYPE), cc.xy(2, 3));
        builder.add((UiComponent)this.indexTypeLst, cc.xy(4, 3));
        builder.add((UiComponent)this.indexTypeBtn, cc.xy(6, 3));
        builder.addSeparator(DesignerMsg.TYPES_INDEX_ORDER.getString(), cc.xywh(2, 5, 5, 1));
        builder.add((UiComponent)this.insRadioBtn, cc.xywh(2, 6, 5, 1));
        builder.add((UiComponent)this.ascRadioBtn, cc.xywh(2, 7, 5, 1));
        this.add((UiComponent)panel, "Center");
        this.setInitialized(true);
        this.updateDefaults();
    }

    @Override
    protected void updateDefaults() {
        TypeItem typeItem = this.getTypeItem();
        CatalogType typeRef = typeItem.getRef();
        if (typeRef != null) {
            CatalogType elemType = typeRef.getElementType();
            CatalogType indexType = typeRef.getIndexType();
            this.elemTypeLst.setSelectedItem(elemType);
            this.indexTypeLst.setSelectedItem(indexType);
            if (typeRef.isOrdered()) {
                this.ascRadioBtn.setSelected(true);
            } else {
                this.insRadioBtn.setSelected(true);
            }
        } else {
            CatalogType type = CatalogType.Default.getAny();
            typeItem.setRef(CatalogType.Default.getMap((CatalogType)CatalogType.Default.getAny(), (CatalogType)type));
            this.elemTypeLst.setSelectedItem(type);
            this.indexTypeLst.setSelectedItem(type);
            this.insRadioBtn.setSelected(true);
        }
    }

    private void processEvent(UiEvent e) {
        UiComponent source = e.getSource();
        TypeItem currentType = this.getTypeItem();
        CatalogType mapType = currentType.getRef();
        if (source == this.elemTypeBtn) {
            CatalogType elemTypeRef = this.showTypeDialog(this.getElemTypeRef());
            if (elemTypeRef != null) {
                this.elemTypeLst.setSelectedItem(elemTypeRef);
                mapType.setElementType(elemTypeRef);
            }
        } else if (source == this.indexTypeBtn) {
            CatalogType indexTypeRef = this.showTypeDialog(this.getIndexTypeRef());
            if (indexTypeRef != null) {
                this.indexTypeLst.setSelectedItem(indexTypeRef);
                mapType.setIndexType(indexTypeRef);
            }
        } else if (source == this.elemTypeLst) {
            CatalogType elemType = ((TypeItem)this.elemTypeLst.getSelectedItem()).getRef();
            if (elemType != null) {
                mapType.setElementType(elemType);
            }
        } else if (source == this.indexTypeLst) {
            CatalogType indexTypeRef = ((TypeItem)this.indexTypeLst.getSelectedItem()).getRef();
            if (indexTypeRef != null) {
                mapType.setIndexType(indexTypeRef);
            }
        } else if (source == this.ascRadioBtn) {
            mapType.setOrdered(true);
        } else if (source == this.insRadioBtn) {
            mapType.setOrdered(false);
        }
        this.firePropertyChange("oracle.bpm.designer.types.TypeItem", null, currentType);
    }

    private CatalogType getElemTypeRef() {
        return ((TypeItem)this.elemTypeLst.getSelectedItem()).getRef();
    }

    private CatalogType getIndexTypeRef() {
        return ((TypeItem)this.indexTypeLst.getSelectedItem()).getRef();
    }

    private CatalogType showTypeDialog(CatalogType initialTypeRef) {
        TypesDialog dialog = new TypesDialog((UiWindow)this.getParentDialog(), this.project);
        dialog.setTypeCatalog(this.getTypeCatalog());
        if (initialTypeRef != null) {
            dialog.setInitialTypeRef(initialTypeRef);
        }
        dialog.setVisible(true);
        TypeItem indexType = dialog.getSelectedTypeItem();
        return indexType.getRef();
    }
}

