/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.types;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.types.CILTypeComboBox;
import oracle.bpm.designer.types.DetailedCILTypeComboBox;
import oracle.bpm.designer.types.TypeItem;
import oracle.bpm.designer.types.TypePanel;
import oracle.bpm.designer.types.TypeUtils;
import oracle.bpm.designer.types.TypesDialog;
import oracle.bpm.lang.Str;
import oracle.bpm.project.CatalogTypeImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.event.UiEvent;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;

class ArrayPanel
extends TypePanel
implements ActionListener,
ItemListener {
    private Button browseBtn;
    private CILTypeComboBox elemTypeLst;
    private Project project;

    public ArrayPanel(UiContainer parent, Project project) {
        super(parent, DesignerMsg.TYPES_ARRAY);
        this.project = project;
    }

    public void actionPerformed(ActionEvent e) {
        this.processEvent((UiEvent)e);
    }

    public void itemStateChanged(ItemEvent e) {
        this.processEvent((UiEvent)e);
    }

    @Override
    protected void initialize() {
        this.setLayout((Layout)new BorderLayout());
        Panel panel = new Panel((UiContainer)this);
        FormLayout layout = new FormLayout("1dlu, pref, 1dlu, pref:grow, 1dlu, min, 1dlu", "pref");
        this.elemTypeLst = new DetailedCILTypeComboBox((UiContainer)panel, this.getTypeRepository());
        this.elemTypeLst.addItemListener(this);
        this.browseBtn = new Button((UiContainer)panel, UIMsg.TO_MSG((String)"..."));
        this.browseBtn.addActionListener((ActionListener)this);
        PanelBuilder builder = layout.createBuilder(panel);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.TYPES_ELEMENTS_TYPE), cc.xy(2, 1));
        builder.add((UiComponent)this.elemTypeLst, cc.xy(4, 1));
        builder.add((UiComponent)this.browseBtn, cc.xy(6, 1));
        this.add((UiComponent)panel, "Center");
        this.setInitialized(true);
        this.updateDefaults();
    }

    @Override
    protected void updateDefaults() {
        TypeItem typeItem = this.getTypeItem();
        CatalogType typeRef = typeItem.getRef();
        if (typeRef != null) {
            CatalogType elemType = typeRef.getElementType();
            this.elemTypeLst.setSelectedItem(elemType);
        } else {
            CatalogType elemType = CatalogType.Default.getAny();
            typeItem.setRef(CatalogType.Default.getArray((CatalogType)elemType));
            this.elemTypeLst.setSelectedItem(elemType);
        }
    }

    private void processEvent(UiEvent e) {
        if (e.getSource() == this.browseBtn) {
            TypesDialog dialog = new TypesDialog((UiWindow)this.getParentDialog(), this.project, false);
            dialog.setTypeCatalog(this.getTypeCatalog());
            CatalogType elemType = this.getElemTypeRef();
            if (elemType != null) {
                dialog.setInitialTypeRef(elemType);
            }
            dialog.setVisible(true);
            TypeItem elemTypeItem = dialog.getSelectedTypeItem();
            CatalogType elemTypeRef = elemTypeItem.getRef();
            if (elemTypeRef != null) {
                this.elemTypeLst.setSelectedItem(elemTypeRef);
                TypeItem currentType = this.getTypeItem();
                currentType.setRef(CatalogType.Default.getArray((CatalogType)elemTypeRef));
                this.firePropertyChange("oracle.bpm.designer.types.TypeItem", null, currentType);
            }
        } else if (e.getSource() == this.elemTypeLst) {
            CatalogType elemType;
            TypeItem item = (TypeItem)this.elemTypeLst.getSelectedItem();
            CatalogType catalogType = elemType = item != null ? item.getRef() : null;
            if (elemType != null) {
                TypeItem currentType = this.getTypeItem();
                currentType.setRef(CatalogType.Default.getArray((CatalogType)elemType));
                this.firePropertyChange("oracle.bpm.designer.types.TypeItem", null, currentType);
            }
        }
    }

    private CatalogType getElemTypeRef() {
        String type;
        CatalogType result;
        TypeItem item = (TypeItem)this.elemTypeLst.getSelectedItem();
        CatalogType catalogType = result = item != null ? item.getRef() : null;
        if (result == null && !Str.isEmpty(type = this.elemTypeLst.getText().trim())) {
            TypeRef ref = TypeUtils.getTypeRefFor(type, this.getTypeCatalog());
            result = ref != null ? CatalogTypeImpl.get((TypeRef)ref.get()) : null;
        }
        return result;
    }
}

