/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.type;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.type.TypeChooserUseCase;
import oracle.bpm.designer.type.TypeItemKind;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.project.view.filter.ProjectFilters;
import org.jetbrains.annotations.NotNull;

class TypesFactory {
    private TypeChooserUseCase useCase;

    public TypesFactory(@NotNull TypeChooserUseCase useCase) {
        this.useCase = useCase;
    }

    public Sequence<TypeItemKind> getKindsForUseCase() {
        return this.getKindsForUseCase(this.useCase);
    }

    public Sequence<TypeItemKind> getNestedKindsForUseCase() {
        ArrayList<TypeItemKind> result = new ArrayList<TypeItemKind>();
        TypeChooserUseCase useCaseFilter = this.useCase == TypeChooserUseCase.ARRAYS_ONLY ? TypeChooserUseCase.ALL_TYPES : this.useCase;
        Sequence<TypeItemKind> kindsForUseCase = this.getKindsForUseCase(useCaseFilter);
        for (TypeItemKind kind : kindsForUseCase) {
            if (kind == TypeItemKind.ARRAY) continue;
            result.add(kind);
        }
        return CollectionUtils.asSequence(result);
    }

    public ProjectFilter getComponentFilterForUseCase() {
        ProjectFilter result = this.useCase == TypeChooserUseCase.BUSINESS_OBJECT_ATTRIBUTE ? ProjectFilters.NON_WSDL_OBJECTS : ProjectFilters.BPM_OBJECTS;
        return result;
    }

    public Sequence<CatalogType> getPrimitiveCatalogTypesForUseCase() {
        ArrayList<CatalogType> result = new ArrayList<CatalogType>();
        Sequence<TypeItemKind> kinds = this.getKindsForUseCase();
        for (TypeItemKind kind : kinds) {
            if (!TypeItemKind.isPredefinedKind(kind)) continue;
            CatalogType type = TypeItemKind.getPredefinedType(kind);
            result.add(type);
        }
        return CollectionUtils.asSequence(result);
    }

    private Sequence<TypeItemKind> getKindsForUseCase(@NotNull TypeChooserUseCase useCase) {
        List<Object> result = new ArrayList<TypeItemKind>();
        switch (useCase) {
            case ALL_TYPES: 
            case BUSINESS_OBJECT_ATTRIBUTE: 
            case ARGUMENT_TYPES_WITH_ARRAYS: {
                result.add((Object)TypeItemKind.ARRAY);
            }
            case ARGUMENT_TYPES: 
            case DATA_OBJECT_TYPES: 
            case PROJECT_DATA_OBJECT_TYPES: {
                result.add((Object)TypeItemKind.LONG);
                result.add((Object)TypeItemKind.COMPONENT);
                result.add((Object)TypeItemKind.INTERVAL);
                result.add((Object)TypeItemKind.BINARY);
            }
            case PRIMITIVES: {
                result.add((Object)TypeItemKind.STRING);
                result.add((Object)TypeItemKind.INT);
                result.add((Object)TypeItemKind.BOOL);
                result.add((Object)TypeItemKind.REAL);
                result.add((Object)TypeItemKind.DECIMAL);
                result.add((Object)TypeItemKind.TIME);
            }
        }
        if (useCase == TypeChooserUseCase.ARRAYS_ONLY) {
            result.add((Object)TypeItemKind.ARRAY);
        }
        result = CollectionUtils.sort(result, new Comparator<TypeItemKind>(){

            @Override
            public int compare(TypeItemKind typeItemKind, TypeItemKind typeItemKind1) {
                return typeItemKind.compareTo(typeItemKind1);
            }
        });
        return CollectionUtils.asSequence(result);
    }
}

