/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.type;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.bpmobject.msg.BpmObjectMsg;
import oracle.bpm.collections.maps.BiMap;
import oracle.bpm.collections.maps.HashBiMap;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.renderers.CatalogTypeRenderer;
import oracle.bpm.designer.type.TypeUtils;
import oracle.bpm.project.CatalogTypeImpl;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Image;
import org.jetbrains.annotations.NotNull;

enum TypeItemKind {
    STRING,
    INT,
    LONG,
    REAL,
    DECIMAL,
    BOOL,
    TIME,
    INTERVAL,
    BINARY,
    ANY,
    REGEXP,
    VOID,
    NONE,
    COMPONENT,
    ARRAY,
    ITERATOR,
    ASSOCIATIVE_ARRAY;

    private static BiMap<Integer, TypeItemKind> typeItemKindForCatalogKind;
    private static Map<TypeItemKind, CatalogType> predefinedTypeForTypeItemKind;
    private static CatalogTypeRenderer catalogTypeRenderer;

    public static TypeItemKind getTypeItemKind(@NotNull CatalogType catalogType) {
        int kind = catalogType.getKind();
        if (17 == kind || 11 == kind) {
            if (catalogType.equivalent(CatalogTypeImpl.get((TypeRef)TypeFactory.wellKnown("RegExp")))) {
                return REGEXP;
            }
            return COMPONENT;
        }
        if (kind == 2) {
            if (catalogType.getLength() == 64) {
                return LONG;
            }
            return INT;
        }
        return (TypeItemKind)((Object)TypeItemKind.getTypeItemKindForCatalogKindMap().get(kind));
    }

    public static boolean isPredefinedKind(@NotNull TypeItemKind kind) {
        return TypeItemKind.getPredefinedTypeForTypeItemKindMap().containsKey((Object)kind);
    }

    public static CatalogType getPredefinedType(@NotNull TypeItemKind kind) {
        return TypeItemKind.getPredefinedTypeForTypeItemKindMap().get((Object)kind);
    }

    public static String getText(@NotNull TypeItemKind kind) {
        String result;
        if (TypeItemKind.isPredefinedKind(kind)) {
            CatalogType type = TypeItemKind.getPredefinedType(kind);
            result = TypeUtils.renderPrimitiveType(type);
        } else {
            result = "<";
            result = kind == ARRAY ? result + DesignerMsg.TYPES_ARRAY.getString() : (kind == COMPONENT ? result + DesignerMsg.TYPES_COMPONENT.getString() : result + kind.name());
            result = result + ">";
        }
        return result;
    }

    public static Image getIcon(@NotNull TypeItemKind kind) {
        Image result = null;
        if (TypeItemKind.isPredefinedKind(kind)) {
            CatalogType type = TypeItemKind.getPredefinedType(kind);
            result = TypeItemKind.getCatalogTypeRendererInstance().getIcon(type);
        } else if (kind == ARRAY) {
            result = Image.create((Msg)DesignerMsg.DATATYPE_COLLECTION);
        } else if (kind == COMPONENT) {
            result = Image.create((Msg)BpmObjectMsg.BPM_OBJECT);
        }
        return result;
    }

    private static CatalogTypeRenderer getCatalogTypeRendererInstance() {
        if (catalogTypeRenderer == null) {
            catalogTypeRenderer = new CatalogTypeRenderer();
        }
        return catalogTypeRenderer;
    }

    private static BiMap<Integer, TypeItemKind> getTypeItemKindForCatalogKindMap() {
        if (typeItemKindForCatalogKind == null) {
            TypeItemKind.createTypeItemKindForCatalogKindMap();
        }
        return typeItemKindForCatalogKind;
    }

    private static Map<TypeItemKind, CatalogType> getPredefinedTypeForTypeItemKindMap() {
        if (predefinedTypeForTypeItemKind == null) {
            TypeItemKind.createPredefinedTypeForTypeItemKind();
        }
        return predefinedTypeForTypeItemKind;
    }

    private static void createTypeItemKindForCatalogKindMap() {
        typeItemKindForCatalogKind = new HashBiMap<Integer, TypeItemKind>();
        typeItemKindForCatalogKind.put(12, ARRAY);
        typeItemKindForCatalogKind.put(13, ASSOCIATIVE_ARRAY);
        typeItemKindForCatalogKind.put(16, ITERATOR);
        typeItemKindForCatalogKind.put(10, ANY);
        typeItemKindForCatalogKind.put(8, BINARY);
        typeItemKindForCatalogKind.put(1, BOOL);
        typeItemKindForCatalogKind.put(3, DECIMAL);
        typeItemKindForCatalogKind.put(7, INTERVAL);
        typeItemKindForCatalogKind.put(4, REAL);
        typeItemKindForCatalogKind.put(5, STRING);
        typeItemKindForCatalogKind.put(6, TIME);
        typeItemKindForCatalogKind.put(0, VOID);
        typeItemKindForCatalogKind.put(-1, NONE);
    }

    private static void createPredefinedTypeForTypeItemKind() {
        predefinedTypeForTypeItemKind = new HashMap<TypeItemKind, CatalogType>();
        predefinedTypeForTypeItemKind.put(ANY, CatalogType.Default.getAny());
        predefinedTypeForTypeItemKind.put(BINARY, CatalogType.Default.getBinary());
        predefinedTypeForTypeItemKind.put(BOOL, CatalogType.Default.getBool());
        predefinedTypeForTypeItemKind.put(DECIMAL, CatalogType.Default.getDecimal());
        predefinedTypeForTypeItemKind.put(INT, CatalogType.Default.getInt());
        predefinedTypeForTypeItemKind.put(LONG, CatalogType.Default.getInt((int)64));
        predefinedTypeForTypeItemKind.put(INTERVAL, CatalogType.Default.getInterval());
        predefinedTypeForTypeItemKind.put(REAL, CatalogType.Default.getReal());
        predefinedTypeForTypeItemKind.put(STRING, CatalogType.Default.getString());
        predefinedTypeForTypeItemKind.put(TIME, CatalogType.Default.getTime());
        predefinedTypeForTypeItemKind.put(VOID, CatalogType.Default.getVoid());
        predefinedTypeForTypeItemKind.put(NONE, CatalogType.Default.getNone());
    }
}

