/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.type;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.type.ArrayDetailsPanel;
import oracle.bpm.designer.type.CatalogTypeBuilder;
import oracle.bpm.designer.type.ComponentDetailsPanel;
import oracle.bpm.designer.type.PredefinedTypeDetailsPanel;
import oracle.bpm.designer.type.TypeBrowserPanel;
import oracle.bpm.designer.type.TypeChooserUseCase;
import oracle.bpm.designer.type.TypeDetailsPanel;
import oracle.bpm.designer.type.TypeItemKind;
import oracle.bpm.designer.type.TypesFactory;
import oracle.bpm.editor.msg.EditorMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextField;
import org.jetbrains.annotations.NotNull;

public class TypeChooserPanel
extends Panel
implements CatalogTypeBuilder {
    private TypeBrowserPanel panel;

    private TypeChooserPanel(@NotNull UiContainer container, @NotNull Project project, @NotNull TypeChooserUseCase useCase) {
        super(container);
        this.init(project, useCase);
    }

    public static TypeChooserPanel create(@NotNull UiContainer container, @NotNull Project project, @NotNull TypeChooserUseCase useCase) {
        return new TypeChooserPanel(container, project, useCase);
    }

    @Override
    public CatalogType getCatalogType() {
        return this.panel.getCatalogType();
    }

    @Override
    public void setCatalogType(@NotNull CatalogType catalogType) {
        this.panel.setCatalogType(catalogType);
    }

    @Override
    public boolean isValidType() {
        return this.getCatalogType() != null;
    }

    private void init(@NotNull Project project, @NotNull TypeChooserUseCase useCase) {
        this.setLayout((Layout)new MigLayout("ins 0, gap 0, fillx"));
        TypesFactory typesFactory = new TypesFactory(useCase);
        this.panel = new DeferredTypeBrowserPanel((UiContainer)this, project, typesFactory);
        this.add((UiComponent)this.panel, "growx");
    }

    private static class DeferredTypeBrowserPanel
    extends TypeBrowserPanel {
        private final Project project;
        private final TypesFactory typesFactory;

        public DeferredTypeBrowserPanel(UiContainer parent, Project project, TypesFactory typesFactory) {
            this(parent, project, typesFactory, false);
        }

        public DeferredTypeBrowserPanel(UiContainer parent, Project project, TypesFactory typesFactory, boolean nested) {
            super(parent, project, typesFactory, nested);
            this.project = project;
            this.typesFactory = typesFactory;
        }

        @Override
        protected void selectionModified() {
            super.selectionModified();
            UiWindow window = this.getOwnerWindow();
            if (window != null) {
                window.pack();
            }
        }

        @Override
        protected Panel createInnerPanel(final @NotNull UiContainer container, @NotNull TypeItemKind selectedItem) {
            TypeDetailsPanel result = null;
            if (TypeItemKind.isPredefinedKind(selectedItem)) {
                CatalogType type = TypeItemKind.getPredefinedType(selectedItem);
                result = new PredefinedTypeDetailsPanel(container);
                result.setCatalogType(type);
            } else if (selectedItem == TypeItemKind.ARRAY) {
                result = new ArrayPanel(container, this.project, this.typesFactory);
            } else if (selectedItem == TypeItemKind.COMPONENT) {
                result = new DeferredField(container){

                    @Override
                    protected TypeDetailsPanel createTypeDetailsPanel() {
                        ProjectFilter componentFilter = DeferredTypeBrowserPanel.this.typesFactory.getComponentFilterForUseCase();
                        return new ComponentDetailsPanel(container, DeferredTypeBrowserPanel.this.project, componentFilter);
                    }
                };
            }
            if (result != null) {
                result.requestFocus();
            }
            return result;
        }

        @Override
        protected Msg getLabel() {
            return null;
        }
    }

    private static class ArrayPanel
    extends TypeDetailsPanel {
        private ArrayDetailsPanel details;
        private Project project;
        private TypesFactory typesFactory;

        public ArrayPanel(UiContainer container, Project project, TypesFactory typesFactory) {
            super(container);
            this.project = project;
            this.typesFactory = typesFactory;
            this.init();
        }

        @Override
        public CatalogType getCatalogType() {
            return this.details.getCatalogType();
        }

        @Override
        public void setCatalogType(@NotNull CatalogType catalogType) {
            this.details.setCatalogType(catalogType);
        }

        @Override
        public boolean isValidType() {
            return this.details.isValidType();
        }

        private void init() {
            this.setLayout((Layout)new MigLayout("ins 5, gap 5, fillx"));
            this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.ARRAY_TYPE), "top");
            this.details = new ArrayDetailsPanel((UiContainer)this, this.project, this.typesFactory){

                @Override
                protected TypeBrowserPanel createBrowserPanel(Project project, TypesFactory typesFactory) {
                    return new DeferredTypeBrowserPanel((UiContainer)this, project, typesFactory, true);
                }

                @Override
                protected boolean useTitle() {
                    return false;
                }
            };
            this.add((UiComponent)this.details, "growx, growy,top");
        }
    }

    private static abstract class DeferredField
    extends TypeDetailsPanel {
        private CatalogType catalogType;
        private TextField text;

        public DeferredField(UiContainer parent) {
            super(parent);
            this.setLayout((Layout)new MigLayout("ins 0, gap 0, fillx"));
            this.text = new TextField((UiContainer)this);
            this.text.setEnabled(false);
            this.add((UiComponent)this.text, "growx");
            Button browseButton = this.createBrowseButton((UiContainer)this);
            this.add((UiComponent)browseButton, "gapx 5");
        }

        @Override
        public CatalogType getCatalogType() {
            return this.catalogType;
        }

        @Override
        public void setCatalogType(@NotNull CatalogType catalogType) {
            if (catalogType != null) {
                this.text.setText(catalogType.getText());
            } else {
                this.text.setText("");
            }
            this.catalogType = catalogType;
        }

        @Override
        public boolean isValidType() {
            return this.catalogType != null;
        }

        protected abstract TypeDetailsPanel createTypeDetailsPanel();

        private Button createBrowseButton(@NotNull UiContainer container) {
            Button result = Button.createBrowse((UiContainer)container, (Msg)EditorMsg.COMPONENT_PANEL_BROWSE_TYPES);
            result.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    UiWindow ownerWindow = DeferredField.this.getOwnerWindow();
                    CatalogType selectedItem = DeferredField.this.getCatalogType();
                    TypeDetailsPanel panel = DeferredField.this.createTypeDetailsPanel();
                    if (selectedItem != null) {
                        panel.setCatalogType(selectedItem);
                    }
                    OkCancelDialog dialog = new OkCancelDialog(ownerWindow, EditorMsg.COMPONENT_PANEL_BROWSE_TYPES, true){

                        public void ok() {
                            this.close();
                        }
                    };
                    dialog.getContentPane().add((UiComponent)panel, (Object)"Center");
                    dialog.setSize(450, 400);
                    dialog.setLocationRelativeTo((UiComponent)dialog.getParent());
                    dialog.setVisible(true);
                    boolean isOk = dialog.userAccepted();
                    if (isOk) {
                        CatalogType type = panel.getCatalogType();
                        DeferredField.this.setCatalogType(type);
                    }
                }
            });
            return result;
        }
    }
}

