/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.type;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.selectorpanel.ComboBoxSelectorPanel;
import oracle.bpm.designer.type.ArrayDetailsPanel;
import oracle.bpm.designer.type.CatalogTypeBuilder;
import oracle.bpm.designer.type.ComponentDetailsPanel;
import oracle.bpm.designer.type.PredefinedTypeDetailsPanel;
import oracle.bpm.designer.type.TypeDetailsPanel;
import oracle.bpm.designer.type.TypeItemKind;
import oracle.bpm.designer.type.TypesFactory;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

class TypeBrowserPanel
extends ComboBoxSelectorPanel<TypeItemKind>
implements CatalogTypeBuilder {
    private Project project;
    private TypesFactory typesFactory;

    public TypeBrowserPanel(@NotNull UiContainer container, @NotNull Project project, @NotNull TypesFactory typesFactory, boolean isNested) {
        super(container, null, DesignerMsg.TYPE);
        this.project = project;
        this.typesFactory = typesFactory;
        this.init(isNested);
    }

    @Override
    public CatalogType getCatalogType() {
        TypeDetailsPanel panel = this.getTypeImplementationPanel();
        return panel != null ? panel.getCatalogType() : null;
    }

    @Override
    public void setCatalogType(@NotNull CatalogType catalogType) {
        TypeItemKind selectedOption = TypeItemKind.getTypeItemKind(catalogType);
        this.setSelectedOption(selectedOption);
        this.getTypeImplementationPanel().setCatalogType(catalogType);
    }

    @Override
    public boolean isValidType() {
        return this.getTypeImplementationPanel().isValidType();
    }

    @Override
    protected boolean canAddEmptyInnerPanel() {
        return true;
    }

    @Override
    protected Panel createInnerPanel(@NotNull UiContainer container, @NotNull TypeItemKind selectedItem) {
        TypeDetailsPanel result = null;
        if (TypeItemKind.isPredefinedKind(selectedItem)) {
            CatalogType type = TypeItemKind.getPredefinedType(selectedItem);
            result = new PredefinedTypeDetailsPanel(container);
            result.setCatalogType(type);
        } else if (selectedItem == TypeItemKind.ARRAY) {
            result = new ArrayDetailsPanel(container, this.project, this.typesFactory);
        } else if (selectedItem == TypeItemKind.COMPONENT) {
            ProjectFilter componentFilter = this.typesFactory.getComponentFilterForUseCase();
            result = new ComponentDetailsPanel(container, this.project, componentFilter);
        }
        if (result != null) {
            result.requestFocus();
        }
        return result;
    }

    private void init(boolean isNested) {
        Sequence<TypeItemKind> kinds = isNested ? this.typesFactory.getNestedKindsForUseCase() : this.typesFactory.getKindsForUseCase();
        for (TypeItemKind item : kinds) {
            this.addOption(item);
        }
        this.setLabelProvider(new LabelProvider.Default<TypeItemKind>(){

            public String getText(TypeItemKind element) {
                String result = "";
                if (element != null) {
                    result = TypeItemKind.getText(element);
                }
                return result;
            }

            public Image getIcon(TypeItemKind element) {
                Image result = null;
                if (element != null) {
                    result = TypeItemKind.getIcon(element);
                }
                return result;
            }
        });
    }

    private TypeDetailsPanel getTypeImplementationPanel() {
        return (TypeDetailsPanel)this.getInnerPanel();
    }
}

