/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.type;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.type.CatalogTypeBuilder;
import oracle.bpm.designer.type.TypeBrowserPanel;
import oracle.bpm.designer.type.TypesFactory;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

class TypeBrowserDialog
extends OkCancelDialog
implements CatalogTypeBuilder {
    private TypeBrowserPanel typeBrowserPanel;

    private TypeBrowserDialog(@NotNull UiWindow parent, @NotNull Project project, @NotNull TypesFactory typesFactory) {
        super(parent, DesignerMsg.BROWSE_TYPES);
        this.init(project, typesFactory);
    }

    public static TypeBrowserDialog create(@NotNull UiWindow parent, @NotNull Project project, @NotNull TypesFactory typesFactory) {
        return new TypeBrowserDialog(parent, project, typesFactory);
    }

    public String getHelpId() {
        return this.getHelpIdWithMsg();
    }

    public void ok() {
        if (!this.isValidType()) {
            MessageDialog.showError((Msg)DesignerMsg.INVALID_SELECTED_TYPE);
            return;
        }
        this.close();
    }

    @Override
    public CatalogType getCatalogType() {
        return this.typeBrowserPanel.getCatalogType();
    }

    @Override
    public void setCatalogType(@NotNull CatalogType catalogType) {
        this.typeBrowserPanel.setCatalogType(catalogType);
    }

    @Override
    public boolean isValidType() {
        return this.typeBrowserPanel.isValidType();
    }

    private void init(@NotNull Project project, @NotNull TypesFactory typesFactory) {
        UiContainer container = this.getContentPane();
        container.setLayout((Layout)new MigLayout("ins 10, gap 0, fill"));
        this.typeBrowserPanel = this.createTypeBrowserPanel(container, project, typesFactory);
        container.add((UiComponent)this.typeBrowserPanel, (Object)"grow");
        this.setSize(450, 500);
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private TypeBrowserPanel createTypeBrowserPanel(@NotNull UiContainer container, @NotNull Project project, @NotNull TypesFactory typesFactory) {
        return new TypeBrowserPanel(container, project, typesFactory, false);
    }
}

