/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.type;

import java.util.ArrayList;
import javax.swing.ListModel;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.action.NewBpmObjectAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.type.TypeDetailsPanel;
import oracle.bpm.draw.Color;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.Str;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.project.view.project.view.renderer.ProjectObjectRenderer;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.List;
import oracle.bpm.ui.MutableListListModel;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.TitledBorder;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentDetailsPanel
extends TypeDetailsPanel {
    private CatalogObjectList componentList;
    private TextField findField;
    private Label fullNameLabel;
    private final Project project;
    private final ProjectFilter projectFilter;

    public ComponentDetailsPanel(@NotNull UiContainer parent, @NotNull Project project, @NotNull ProjectFilter projectFilter) {
        super(parent);
        this.project = project;
        this.projectFilter = projectFilter;
        this.init();
    }

    @Override
    public CatalogType getCatalogType() {
        return (CatalogType)this.componentList.getSelectedValue();
    }

    @Override
    public boolean isValidType() {
        return this.getCatalogType() != null;
    }

    @Override
    public void setCatalogType(@NotNull CatalogType catalogType) {
        CatalogObject catalogObject = CatalogObjectImpl.create((TypeRef)catalogType.getDynamicRef());
        this.componentList.setSelectedValue(catalogObject, true);
    }

    public void requestFocus() {
        this.findField.requestFocus();
    }

    protected void init() {
        this.setBorder((Border)new TitledBorder(DesignerMsg.TYPES_COMPONENT));
        this.setLayout((Layout)new MigLayout("ins 5, gap 0, fill"));
        Panel findPanel = new Panel((UiContainer)this);
        findPanel.setLayout((Layout)new MigLayout("ins 0, gap 0, fillx"));
        findPanel.add((UiComponent)Label.create((UiContainer)findPanel, (Msg)DesignerMsg.FIND));
        this.findField = this.createFindField((UiContainer)findPanel);
        findPanel.add((UiComponent)this.findField, (Object)"gapx 5, growx");
        findPanel.add((UiComponent)this.createNewBPMObjectButton((UiContainer)this, this.project), (Object)"gapx 5");
        this.componentList = this.createComponentList((UiContainer)this, this.project, this.projectFilter);
        this.fullNameLabel = this.createFullNameLabel((UiContainer)this);
        this.add((UiComponent)findPanel, "growx, wrap");
        this.add((UiComponent)this.componentList, "gapy 5, grow, wrap");
        this.add((UiComponent)this.fullNameLabel, "gapy 5, growx");
        if (this.componentList.getVisibleRowCount() > 0) {
            this.componentList.setSelectedIndex(0);
        }
        this.updateFullNameLabel();
    }

    private void updateFullNameLabel() {
        String status = "";
        CatalogType type = this.getCatalogType();
        if (type != null) {
            status = type.getText();
        }
        this.fullNameLabel.setText(status);
    }

    private Button createNewBPMObjectButton(@NotNull UiContainer container, @NotNull Project project) {
        Button result = Button.createIconic((UiContainer)container, (Msg)DesignerMsg.NEW);
        result.addActionListener((ActionListener)new NewBpmObjectAction(project.getCatalogRoot()){

            @Override
            public boolean doIt() {
                boolean result = super.doIt();
                if (result) {
                    ComponentDetailsPanel.this.reloadList();
                }
                return result;
            }
        });
        return result;
    }

    private TextField createFindField(@NotNull UiContainer container) {
        TextField result = new TextField(container);
        result.setRequestFocusEnabled(true);
        result.addDocumentListener((DocumentListener)new DocumentListener.Default(){

            public void anyUpdate(DocumentEvent e) {
                ComponentDetailsPanel.this.reloadList();
            }
        });
        return result;
    }

    private void reloadList() {
        String findString = this.findField.getText();
        boolean elementsFound = this.componentList.getModel().reloadModel(findString);
        this.findField.setForeground(findString.length() == 0 || elementsFound ? Color.BLACK : Color.RED);
    }

    private CatalogObjectList createComponentList(@NotNull UiContainer container, @NotNull Project project, @NotNull ProjectFilter projectFilter) {
        CatalogObjectList result = CatalogObjectList.create(container, project, projectFilter);
        result.setLabelProvider((LabelProvider)new CatalogObjectLabelProvider());
        result.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ComponentDetailsPanel.this.updateFullNameLabel();
            }
        });
        return result;
    }

    private Label createFullNameLabel(@NotNull UiContainer container) {
        Label result = Label.createWithNoColon((UiContainer)container, (Msg)Msg.QUOTE(""));
        result.setForeground(Color.GRAY);
        return result;
    }

    private class CatalogObjectLabelProvider
    extends LabelProvider.Default<CatalogObject> {
        public Image getIcon(CatalogObject element) {
            return ProjectObjectRenderer.Default.getIcon((ProjectObject)element);
        }

        public String getText(CatalogObject element) {
            return ProjectObjectRenderer.Default.getLabel((ProjectObject)element);
        }
    }

    private static class CatalogObjectList
    extends List<CatalogObject> {
        private CatalogObjectList(@NotNull UiContainer parent, @NotNull CatalogObjectListModel model) {
            super(parent, (ListModel)((Object)model));
        }

        public static CatalogObjectList create(@NotNull UiContainer parent, @NotNull Project project, @NotNull ProjectFilter projectFilter) {
            CatalogObjectListModel model = new CatalogObjectListModel(project, projectFilter);
            return new CatalogObjectList(parent, model);
        }

        public CatalogObjectListModel getModel() {
            return (CatalogObjectListModel)((Object)super.getModel());
        }

        private static class CatalogObjectListModel
        extends MutableListListModel<CatalogObject> {
            private final Project project;
            private final ProjectFilter projectFilter;

            public CatalogObjectListModel(@NotNull Project project, @NotNull ProjectFilter projectFilter) {
                super(new ArrayList());
                this.project = project;
                this.projectFilter = projectFilter;
                this.reloadModel(null);
            }

            public boolean reloadModel(final String findFilter) {
                this.removeAllElements();
                Sequence<CatalogObject> catalogObjects = this.getCatalogObjects();
                if (!Str.isEmpty(findFilter)) {
                    catalogObjects = catalogObjects.select(new Predicate<CatalogObject>(){

                        @Override
                        public boolean check(@Nullable CatalogObject value) {
                            return value != null && value.getName().contains(findFilter);
                        }
                    });
                }
                for (CatalogObject catalogObject : catalogObjects) {
                    this.addElement(catalogObject);
                }
                return !catalogObjects.isEmpty();
            }

            private Sequence<CatalogObject> getCatalogObjects() {
                return (Sequence)Cast.force(this.projectFilter.getChildren((ProjectObjectContainer)this.project.getCatalogRoot()));
            }
        }
    }
}

