/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.type;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.renderers.CatalogTypeRenderer;
import oracle.bpm.designer.type.TypesFactory;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

class CatalogTypeComboBox
extends ComboBox<CatalogType> {
    private CatalogTypeComboBox(@NotNull UiContainer parent, @NotNull TypesFactory typesFactory) {
        super(parent, false);
        final CatalogTypeRenderer renderer = new CatalogTypeRenderer();
        this.setLabelProvider((LabelProvider)new LabelProvider.Default<CatalogType>(){

            public String getText(CatalogType type) {
                return renderer.getLabel(type);
            }

            public Image getIcon(CatalogType type) {
                return renderer.getIcon(type);
            }
        });
        Sequence<CatalogType> types = typesFactory.getPrimitiveCatalogTypesForUseCase();
        for (CatalogType type : types) {
            this.addItem(type);
        }
    }

    public static CatalogTypeComboBox create(@NotNull UiContainer parent, @NotNull TypesFactory typesFactory) {
        return new CatalogTypeComboBox(parent, typesFactory);
    }

    public boolean typeExists(@NotNull CatalogType catalogType) {
        int itemCount = this.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            CatalogType type = (CatalogType)this.getItemAt(i);
            if (!type.equals(catalogType)) continue;
            return true;
        }
        return false;
    }
}

