/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.type;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.type.TypeBrowserPanel;
import oracle.bpm.designer.type.TypeDetailsPanel;
import oracle.bpm.designer.type.TypesFactory;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.TitledBorder;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

class ArrayDetailsPanel
extends TypeDetailsPanel {
    private TypeBrowserPanel typeBrowserPanel;

    public ArrayDetailsPanel(@NotNull UiContainer parent, @NotNull Project project, @NotNull TypesFactory typesFactory) {
        super(parent);
        this.init(project, typesFactory);
    }

    public void requestFocus() {
        this.typeBrowserPanel.requestFocus();
    }

    @Override
    public CatalogType getCatalogType() {
        return this.typeBrowserPanel.getCatalogType() == null ? null : CatalogType.Default.getArray((CatalogType)this.typeBrowserPanel.getCatalogType());
    }

    @Override
    public void setCatalogType(@NotNull CatalogType catalogType) {
        assert (catalogType.isArray()) : "CatalogType must be an Array";
        CatalogType elementType = catalogType.getElementType();
        this.typeBrowserPanel.setCatalogType(elementType);
    }

    @Override
    public boolean isValidType() {
        return this.typeBrowserPanel.isValidType();
    }

    protected TypeBrowserPanel createBrowserPanel(Project project, TypesFactory typesFactory) {
        return new TypeBrowserPanel((UiContainer)this, project, typesFactory, true);
    }

    protected boolean useTitle() {
        return true;
    }

    private void init(@NotNull Project project, @NotNull TypesFactory typesFactory) {
        if (this.useTitle()) {
            this.setBorder((Border)new TitledBorder(DesignerMsg.TYPES_ARRAY));
            this.setLayout((Layout)new MigLayout("ins 5, gap 0, fill"));
        } else {
            this.setLayout((Layout)new MigLayout("ins 0, gap 0, fill"));
        }
        this.typeBrowserPanel = this.createBrowserPanel(project, typesFactory);
        this.add((UiComponent)this.typeBrowserPanel, "grow");
    }
}

