/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.toolbar;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.ActivityRibbonSection;
import oracle.bpm.designer.ArtifactRibbonSection;
import oracle.bpm.designer.CatchEventRibbonSection;
import oracle.bpm.designer.DesignerStateManager;
import oracle.bpm.designer.GatewayRibbonSection;
import oracle.bpm.designer.InteractiveRibbonSection;
import oracle.bpm.designer.NotificationRibbonSection;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.ThrowEventRibbonSection;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBoxMenuItem;
import oracle.bpm.ui.MenuItem;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.RibbonComponentBuilder;
import oracle.bpm.ui.RibbonSection;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.ToolBarItem;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.selection.DefaultSelection;

public class UtilityToolBar {
    public static void rebuildUtilityToolbar(ToolBar toolBar, DesignerStateManager manager) {
        toolBar.removeAll();
        toolBar.setLayout((Layout)new MigLayout("fillx, insets 0 0 0 0"));
        UtilityToolBar.addRibbon(toolBar, manager);
        UtilityToolBar.addGotoComposite(toolBar, manager);
    }

    private static void addGotoComposite(ToolBar toolBar, DesignerStateManager manager) {
        BaseAction action = AbstractStudioWorkbench.getInstance().createGotoCompositeAction();
        if (action != null) {
            Process process = manager.getDomain().getDomainElement();
            action.setSelection(DefaultSelection.createSingle((Object)process.getProject()));
            ToolBarItem toolBarItem = toolBar.add(action);
            toolBarItem.setToolTipText(action.getMsg());
        }
    }

    private static void addRibbon(final ToolBar toolBar, DesignerStateManager manager) {
        ProcessDomain domain = manager.getDomain();
        final RibbonComponentBuilder ribbonComponentBuilder = new RibbonComponentBuilder((UiContainer)toolBar);
        ribbonComponentBuilder.addSection((RibbonSection)new ActivityRibbonSection((UiContainer)ribbonComponentBuilder, domain));
        ribbonComponentBuilder.addSection((RibbonSection)new InteractiveRibbonSection((UiContainer)ribbonComponentBuilder, domain));
        ribbonComponentBuilder.addSection((RibbonSection)new NotificationRibbonSection((UiContainer)ribbonComponentBuilder, domain));
        ribbonComponentBuilder.addSection((RibbonSection)new CatchEventRibbonSection((UiContainer)ribbonComponentBuilder, domain));
        ribbonComponentBuilder.addSection((RibbonSection)new ThrowEventRibbonSection((UiContainer)ribbonComponentBuilder, domain));
        ribbonComponentBuilder.addSection((RibbonSection)new GatewayRibbonSection((UiContainer)ribbonComponentBuilder, domain));
        ribbonComponentBuilder.addSection((RibbonSection)new ArtifactRibbonSection((UiContainer)ribbonComponentBuilder, domain));
        toolBar.add((UiComponent)ribbonComponentBuilder, (Object)"growx");
        final PopupMenu menu = new PopupMenu((UiContainer)toolBar);
        final CheckBoxMenuItem showLabelsItem = new CheckBoxMenuItem((UiContainer)toolBar, Msg.QUOTE(""));
        DesignerPreferences designerPreferences = DesignerPreferences.getPreferences();
        boolean lastPreference = designerPreferences.getShowLabelPref();
        showLabelsItem.setSelected(lastPreference);
        ribbonComponentBuilder.removeTitles(lastPreference);
        BaseAction showLabel = new BaseAction(DesignerMsg.RIBBON_MENU_ACTION){

            public void run() {
                DesignerPreferences designerPreferences = DesignerPreferences.getPreferences();
                designerPreferences.setShowLabelPref(showLabelsItem.isSelected());
                designerPreferences.store();
                ribbonComponentBuilder.removeTitles(showLabelsItem.isSelected());
                ribbonComponentBuilder.revalidate();
            }
        };
        showLabelsItem.setAction(showLabel);
        menu.add((MenuItem)showLabelsItem);
        toolBar.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseDoubleClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                if ((e.getModifiers() & 4) == 4) {
                    menu.show((UiComponent)toolBar, e.getX(), e.getY());
                }
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
    }
}

