/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.toolbar;

import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.diagram.editor.Domain;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.geom.Dimension;
import oracle.bpm.project.command.design.ChangeScaleCommand;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.ViewScaleFeature;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MenuItem;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.Slider;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;

public class ScaleTool {
    private Domain domain;
    private Panel panel;
    private UiContainer parent;
    private Process process;
    private ViewScaleFeature scaleFeature;
    private Label scaleLabel;
    private ScaleSlider scaleSlider;

    public ScaleTool(Domain processDomain, UiContainer parent) {
        this(processDomain, parent, null);
    }

    public ScaleTool(Domain processDomain, UiContainer parent, Process process) {
        this.parent = parent;
        this.domain = processDomain;
        this.process = process;
        this.init();
        this.addListeners();
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
        float value = domain.getContext().getScale();
        this.changeScale(value);
    }

    public UiComponent getComponent(int height) {
        int width = 160;
        this.panel.setPreferredSize(Dimension.valueOf(width, height));
        this.scaleSlider.setSize(this.scaleSlider.getSize().getWidth(), height);
        return this.panel;
    }

    private void init() {
        this.panel = new Panel(this.parent);
        this.panel.setLayout((Layout)new BorderLayout());
        this.scaleLabel = Label.createWithNoColon((UiContainer)this.panel, (Msg)DesignerMsg.ZOOM_CLICK_TO_CHOOSE(100));
        this.scaleLabel.setIcon(Image.create((Msg)UIMsg.HIDE_PROGRESS_DETAILS));
        this.scaleLabel.setHorizontalTextPosition(10);
        this.scaleLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ScaleTool.this.showZoomPoup();
            }
        });
        int minimumScale = 0;
        Float defaultValue = Float.valueOf(1.0f);
        if (this.process != null) {
            this.scaleFeature = (ViewScaleFeature)this.process.getFeature(ViewScaleFeature.class);
            defaultValue = this.scaleFeature.getValue();
            this.updateScaleText();
        }
        this.scaleSlider = new ScaleSlider((UiContainer)this.panel, 0, minimumScale * 1000, (int)(ViewScaleFeature.MAXIMUM_SCALE.floatValue() * 1000.0f), (int)(1000.0f * defaultValue.floatValue()));
        int major = (int)((ViewScaleFeature.MAXIMUM_SCALE.floatValue() - (float)minimumScale) * 1000.0f) / 2;
        int minor = (int)(ViewScaleFeature.INCREMENT_SCALE.floatValue() * 1000.0f);
        this.scaleSlider.setMajorTickSpacing(major);
        this.scaleSlider.setMinorTickSpacing(minor);
        this.scaleSlider.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClicked(MouseEvent e) {
                ScaleTool.this.scaleSlider.setValue(1000);
            }
        });
        this.scaleSlider.setToolTipText(DesignerMsg.ZOOM_DCLICK_TO_RESET);
        Button resetZoom = Button.createIconic((UiContainer)this.panel, (Msg)UIMsg.ZOOM_RESET);
        resetZoom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScaleTool.this.scaleSlider.setValue(1000);
            }
        });
        this.panel.add((UiComponent)this.scaleSlider, (Object)"Center");
        Panel buttonPanel = new Panel((UiContainer)this.panel);
        buttonPanel.setLayout((Layout)new BorderLayout());
        buttonPanel.add((UiComponent)resetZoom, (Object)"East");
        buttonPanel.add((UiComponent)this.scaleLabel, (Object)"West");
        this.panel.add((UiComponent)buttonPanel, (Object)"East");
    }

    private void showZoomPoup() {
        PopupMenu menu = new PopupMenu();
        for (float i = ViewScaleFeature.MAXIMUM_SCALE.floatValue() * 100.0f; i >= ViewScaleFeature.MINIMUM_SCALE.floatValue() * 100.0f; i -= ViewScaleFeature.INCREMENT_SCALE.floatValue() * 100.0f) {
            MenuItem added = menu.add(this.createZoomAction(i));
            added.setHorizontalAlignment(0);
        }
        int x = this.scaleLabel.getWidth() - menu.getPreferredSize().getWidth();
        int y = 0 - menu.getPreferredSize().getHeight();
        menu.show((UiComponent)this.scaleLabel, x, y);
    }

    private BaseAction createZoomAction(final float zoom) {
        return new BaseAction(oracle.bpm.resources.UIMsg.QUOTE((int)zoom + "%")){

            public void actionPerformed(ActionEvent event) {
                ScaleTool.this.changeScale(zoom / 100.0f);
            }
        };
    }

    private void updateScaleText() {
        int value = (int)(this.scaleFeature.getValue().floatValue() * 100.0f);
        this.scaleLabel.setMsg(DesignerMsg.ZOOM_CLICK_TO_CHOOSE(value));
    }

    private void addListeners() {
        this.scaleSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                float newValue = (float)ScaleTool.this.scaleSlider.getValue() / 1000.0f;
                ScaleTool.this.changeScale(Math.max(newValue, ViewScaleFeature.MINIMUM_SCALE.floatValue()));
            }
        });
        if (this.scaleFeature != null) {
            ModificationListener<Feature> viewScaleListener = new ModificationListener<Feature>(){

                @Override
                public void objectModified(ModificationEvent<Feature> event) {
                    ScaleTool.this.scaleSlider.setValue((int)(ScaleTool.this.scaleFeature.getValue().floatValue() * 1000.0f));
                    ScaleTool.this.updateScaleText();
                }
            };
            this.scaleFeature.addModificationListener((ModificationListener)viewScaleListener);
        }
    }

    private void changeScale(float value) {
        if (this.process != null) {
            ActionRunner.getInstance().run((Command)new ChangeScaleCommand(this.process, value));
            this.domain.getContext().setScale(((Float)this.process.getFeatureValue(ViewScaleFeature.class)).floatValue());
        } else {
            this.domain.getContext().setScale(value);
            this.scaleSlider.setValue((int)(value * 1000.0f));
            this.scaleLabel.setMsg(DesignerMsg.ZOOM_CLICK_TO_CHOOSE((int)(value * 100.0f)));
            this.domain.getCanvas().revalidate();
        }
        this.domain.getCanvas().repaint();
    }

    private static class ScaleSlider
    extends Slider {
        public ScaleSlider(UiContainer parent, int orientation, int min, int max, int value) {
            super(parent, orientation, min, max, value);
            this.setIconUI();
        }

        public void setValue(int value) {
            super.setValue(value);
        }
    }
}

