/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.toolbar;

import oracle.bpm.designer.HighlightSlider;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.designer.preferences.HighlightLevel;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;

public class HighlightTool {
    public HighlightSlider highlightSlider;
    private ProcessDomain domain;

    public HighlightTool(ProcessDomain processDomain) {
        this.domain = processDomain;
    }

    public HighlightSlider getHighlightUtility(UiContainer parent) {
        HighlightLevel level = DesignerPreferences.getPreferences().getHighlight();
        this.highlightSlider = HighlightSlider.create(parent, Image.create((Msg)UIMsg.ERROR), level);
        this.highlightSlider.setToolTipText(DesignerMsg.HIGHLIGHTING_LEVEL);
        this.addListeners();
        return this.highlightSlider;
    }

    public UiComponent getComponent(UiContainer container) {
        return this.getHighlightUtility(container);
    }

    private void addListeners() {
        this.highlightSlider.addSliderListener(new HighlightSliderListener());
    }

    private class HighlightSliderListener
    implements HighlightSlider.SliderListener {
        private HighlightSliderListener() {
        }

        @Override
        public void sliderChanged(@NotNull HighlightLevel newLevel) {
            DesignerPreferences preferences = DesignerPreferences.getPreferences();
            preferences.setHighlight(newLevel);
            preferences.store();
            HighlightTool.this.domain.getCanvas().repaint();
        }
    }
}

